/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.util.CollectingServerEventCollector;
import de.justsoftware.onx.common.business.events.util.ImmediatelyFiringServerEventCollector;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.business.EntityAdministrationWorkflowService;
import de.justsoftware.onx.container.business.EntityMemberChangedCallback;
import de.justsoftware.onx.container.business.EntityMemberReadDataService;
import de.justsoftware.onx.container.business.EntityMemberService;
import de.justsoftware.onx.container.business.EntityMemberWorkflowImportService;
import de.justsoftware.onx.container.business.EntityMemberWorkflowService;
import de.justsoftware.onx.container.shared.model.AddMemberResultKey;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import de.justsoftware.onx.container.shared.model.EntityMemberWithPerson;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.FailedAndSuccessfulActions;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.MemberChangeOptions;
import de.justsoftware.onx.container.shared.model.util.AddEntityMemberRoleActionVisitor;
import de.justsoftware.onx.container.shared.model.util.EntityMemberUtil;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Service
@ParametersAreNonnullByDefault
public class EntityMemberWorkflowServiceImpl
implements EntityMemberWorkflowService,
EntityMemberWorkflowImportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityMemberWorkflowServiceImpl.class);
    private final I18nService _i18nService;
    private final JCEventBus _eventBus;
    private final EntityMemberService _entityMemberService;
    private final EntityAdministrationWorkflowService _entityAdministrationService;
    private final EntityMemberReadDataService _entityMemberReadDataService;
    private final TransactionHelper _transactionHelper;

    @Autowired
    @ParametersAreNonnullByDefault
    public EntityMemberWorkflowServiceImpl(I18nService i18nService, JCEventBus eventBus, EntityMemberService entityMemberService, EntityAdministrationWorkflowService entityAdministrationService, TransactionHelper transactionHelper, EntityMemberReadDataService entityMemberReadDataService) {
        this._i18nService = i18nService;
        this._eventBus = eventBus;
        this._entityMemberService = entityMemberService;
        this._entityAdministrationService = entityAdministrationService;
        this._entityMemberReadDataService = entityMemberReadDataService;
        this._transactionHelper = transactionHelper;
    }

    @Override
    public FailedAndSuccessfulActions<EntityId> leaveEntities(Set<EntityId> entityIds, final PersonId personId, final MemberChangeOptions options, AuthorizationCheckContextWithUserId authCtx) {
        StaticEntityAction actionToCheck = personId.equals(authCtx.getUserId()) ? StaticEntityAction.ENTITY_LEAVE : StaticEntityAction.ENTITY_MANAGE_MEMBER;
        final ImmutableSet<EntityId> allowedEntityIds = authCtx.filterAllowedIds(entityIds, actionToCheck);
        final CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                EntityMemberWorkflowServiceImpl.this._entityMemberService.updateMemberRoles((Set<EntityId>)allowedEntityIds, personId, (Set<EntityMemberRole>)EntityMemberRoles.MEMBERSTATUS_EXCEPT_HAS_REJECTED, (Set<EntityMemberRole>)EntityMemberRoles.EMPTY, (ServerEventCollector)eventCollector, options, EntityMemberChangedCallback.NOTHING);
                EntityMemberWorkflowServiceImpl.this._entityAdministrationService.deleteCoAdmins((Set<EntityId>)allowedEntityIds, personId, eventCollector, options);
            }
        });
        eventCollector.fireEvents(this._eventBus);
        return FailedAndSuccessfulActions.builder().addSuccessfullyProcessedObjects((Iterable<EntityId>)allowedEntityIds).addErrorMessages((Iterable<EntityId>)Sets.difference(entityIds, allowedEntityIds), "not allowed!").build();
    }

    @Override
    public FailedAndSuccessfulActions<EntityId> leaveEntities(Set<EntityId> entityIds, PersonId personId, AuthorizationCheckContextWithUserId authCtx) {
        return this.leaveEntities(entityIds, personId, MemberChangeOptions.buildDefaultWith(authCtx), authCtx);
    }

    @Override
    public void removeMembersFromEntity(EntityId entityId, ImmutableSet<PersonId> persons, AuthorizationContext authorizationContext) {
        authorizationContext.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_MANAGE_MEMBER);
        CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        this._entityMemberService.updateMemberRoles(entityId, (Set<PersonId>)persons, (Set<EntityMemberRole>)EntityMemberRoles.MEMBERSTATUS_EXCEPT_HAS_REJECTED, (Set<EntityMemberRole>)EntityMemberRoles.EMPTY, (ServerEventCollector)eventCollector, MemberChangeOptions.buildDefaultWith(authorizationContext), null);
        eventCollector.fireEvents(this._eventBus);
    }

    @Override
    public void leaveEntity(EntityId entityId, PersonId personId, AuthorizationCheckContextWithUserId authCtx) {
        this.leaveEntities((Set<EntityId>)ImmutableSet.of((Object)entityId), personId, authCtx);
    }

    @Override
    public void joinEntity(EntityId entityId, AuthorizationCheckContextWithUserId authorizationContext) throws PermissionDeniedException {
        FailedAndSuccessfulActions<EntityId> joinedEntities = this.joinEntities((ImmutableSet<EntityId>)ImmutableSet.of((Object)entityId), authorizationContext);
        if (!joinedEntities.getSuccessfullyProcessedObjects().contains((Object)entityId)) {
            throw new PermissionDeniedException();
        }
    }

    @Override
    public FailedAndSuccessfulActions<EntityId> joinEntities(ImmutableSet<EntityId> entityIds, AuthorizationCheckContextWithUserId authorizationContext) {
        final PersonId personId = authorizationContext.getUserId();
        final CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        final MemberChangeOptions options = MemberChangeOptions.buildDefaultWith(authorizationContext);
        ImmutableSetMultimap mayByIds = authorizationContext.mayByIds(entityIds, ImmutableSet.of((Object)StaticEntityAction.ENTITY_JOIN, (Object)StaticEntityAction.ENTITY_JOIN_REQUEST)).inverse();
        final ImmutableSet assignMembership = ImmutableSet.copyOf((Iterable)Optional.presentInstances((Iterable)mayByIds.get((Object)StaticEntityAction.ENTITY_JOIN)));
        final ImmutableSet assignJoinRequest = FluentIterable.from((Iterable)Optional.presentInstances((Iterable)mayByIds.get((Object)StaticEntityAction.ENTITY_JOIN_REQUEST))).filter(Predicates.not((Predicate)Predicates.in((Collection)assignMembership))).toSet();
        Sets.SetView assignError = Sets.difference(entityIds, (Set)Sets.union((Set)assignMembership, (Set)assignJoinRequest));
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                EntityMemberWorkflowServiceImpl.this._entityMemberService.updateMemberRoles((Set<EntityId>)assignMembership, personId, (Set<EntityMemberRole>)EntityMemberRoles.ALL_MEMBER_STATUS, (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.MEMBER), (ServerEventCollector)eventCollector, options, EntityMemberChangedCallback.NOTHING);
                EntityMemberWorkflowServiceImpl.this._entityMemberService.updateMemberRoles((Set<EntityId>)assignJoinRequest, personId, (Set<EntityMemberRole>)EntityMemberRoles.ALL_MEMBER_STATUS, (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.HAS_SENT_JOINREQUEST), (ServerEventCollector)eventCollector, options, EntityMemberChangedCallback.NOTHING);
            }
        });
        eventCollector.fireEvents(this._eventBus);
        BasicConstants basicConstants = this._i18nService.getLocalizedMessages(authorizationContext.getLocale()).basicConstants();
        return FailedAndSuccessfulActions.builder().addErrorMessages(assignError, basicConstants.noPermission()).addSuccessfullyProcessedObjects(assignMembership).addSuccessfullyProcessedObjects(assignJoinRequest).build();
    }

    @Override
    public void acceptJoinRequests(EntityId entityId, Set<PersonId> personIds, AuthorizationCheckContextWithUserId authCtx) {
        authCtx.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_MODIFY);
        ImmutableSet rolesToRemove = ImmutableSet.of((Object)EntityMemberRole.HAS_SENT_JOINREQUEST);
        ImmutableSetMultimap<PersonId, EntityId> personIdsWithOpenJoinRequests = this._entityMemberService.getPersonIdsByEntityIdAndMemberRoles((Set<EntityId>)ImmutableSet.of((Object)entityId), (Set<EntityMemberRole>)rolesToRemove);
        Sets.SetView difference = Sets.difference(personIds, (Set)personIdsWithOpenJoinRequests.keySet());
        if (!difference.isEmpty()) {
            throw new IllegalStateException(MessageFormatter.format((String)"Not all persons in {} have open join requests for entity {}!", (Object)difference, (Object)entityId).getMessage());
        }
        ImmutableSet rolesToAdd = ImmutableSet.of((Object)EntityMemberRole.MEMBER);
        CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        this._entityMemberService.updateMemberRoles(entityId, personIds, (Set<EntityMemberRole>)rolesToRemove, (Set<EntityMemberRole>)rolesToAdd, (ServerEventCollector)eventCollector, MemberChangeOptions.buildDefaultWith(authCtx), EntityMemberChangedCallback.NOTHING);
        eventCollector.fireEvents(this._eventBus);
    }

    @Override
    public void acceptJoinRequest(EntityId entityId, PersonId personId, AuthorizationCheckContextWithUserId authCtx) {
        this.acceptJoinRequests(entityId, (Set<PersonId>)ImmutableSet.of((Object)personId), authCtx);
    }

    @Override
    public void declineJoinRequest(ImmutableSet<EntityId> entityIds, PersonId personId, AuthorizationCheckContextWithUserId authCtx) {
        MemberChangeOptions options = MemberChangeOptions.builder().setActor(authCtx).build();
        this.leaveEntities((Set<EntityId>)entityIds, personId, options, authCtx);
        ImmutableSet<EntityId> allowedEntityIds = authCtx.filterAllowedIds(entityIds, StaticEntityAction.ENTITY_MANAGE_MEMBER);
        this._entityMemberService.updateMemberRoles((Set<EntityId>)allowedEntityIds, personId, (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.HAS_SENT_JOINREQUEST), (Set<EntityMemberRole>)EntityMemberRoles.EMPTY, (ServerEventCollector)new ImmediatelyFiringServerEventCollector(this._eventBus), options, EntityMemberChangedCallback.NOTHING);
    }

    @Override
    public void withdrawJoinRequest(EntityId entityId, AuthorizationCheckContextWithUserId authCtx) {
        authCtx.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_REMOVE_JOIN_REQUEST);
        MemberChangeOptions noMailOptions = MemberChangeOptions.builder().disableEmailNotification().setActor(authCtx).build();
        this._entityMemberService.updateMemberRoles((Set<EntityId>)ImmutableSet.of((Object)entityId), authCtx.getUserId(), (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.HAS_SENT_JOINREQUEST), (Set<EntityMemberRole>)EntityMemberRoles.EMPTY, (ServerEventCollector)new ImmediatelyFiringServerEventCollector(this._eventBus), noMailOptions, EntityMemberChangedCallback.NOTHING);
    }

    @Override
    public void rejectInvitationToEntity(EntityId entityId, AuthorizationCheckContextWithUserId auth) {
        ImmediatelyFiringServerEventCollector eventCollector = new ImmediatelyFiringServerEventCollector(this._eventBus);
        this.rejectInvitationToEntity(entityId, eventCollector, auth);
    }

    @Override
    public void rejectInvitationToEntity(EntityId entityId, ServerEventCollector eventCollector, AuthorizationCheckContextWithUserId authorizationContext) {
        ImmutableSet everythingAllowed = ImmutableSet.of();
        this._entityMemberService.updateMemberRoles(entityId, (Set<? extends Action>)everythingAllowed, (Set<EntityMemberRole>)EntityMemberRoles.ALL_MEMBER_STATUS, (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.HAS_REJECTED), authorizationContext, eventCollector, MemberChangeOptions.buildDefaultWith(authorizationContext), EntityMemberChangedCallback.NOTHING);
    }

    @Override
    public ImmutableMultiset<AddMemberResultKey> managerAssignRoleToPerson(EntityId entityId, Set<PersonId> personIds, EntityMemberRole roleToAssign, MemberChangeOptions options, AuthorizationCheckContext authorizationContext) {
        authorizationContext.check((ItemId)entityId, (Action)roleToAssign.accept(AddEntityMemberRoleActionVisitor.INSTANCE));
        ImmutableMap<PersonId, EntityMemberWithPerson> allEntityMembers = this._entityMemberService.getEntityMembersMappedByEntityId(entityId);
        ImmutableMultiset.Builder result = ImmutableMultiset.builder();
        ImmutableSet.Builder makeMemberBuilder = ImmutableSet.builder();
        for (PersonId personId : personIds) {
            EntityMemberWithPerson memberWithPerson = (EntityMemberWithPerson)allEntityMembers.get((Object)personId);
            if (memberWithPerson != null && EntityMemberUtil.isShownAsMember(memberWithPerson)) {
                result.add((Object)AddMemberResultKey.ALREADY_MEMBER);
                continue;
            }
            result.add((Object)AddMemberResultKey.MEMBER_ADDED);
            makeMemberBuilder.add((Object)personId);
        }
        CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        this._entityMemberService.updateMemberRoles(entityId, (Set<PersonId>)makeMemberBuilder.build(), (Set<EntityMemberRole>)EntityMemberRoles.ALL_MEMBER_STATUS, (Set<EntityMemberRole>)ImmutableSet.of((Object)roleToAssign), (ServerEventCollector)eventCollector, options, EntityMemberChangedCallback.NOTHING);
        eventCollector.fireEvents(this._eventBus);
        return result.build();
    }

    @Override
    public void addMembers(EntityId entityId, Set<PersonId> membershipsToAdd, MemberChangeOptions options, ServerEventCollector eventCollector) {
        if (!membershipsToAdd.isEmpty()) {
            this._entityMemberService.updateMemberRoles(entityId, membershipsToAdd, (Set<EntityMemberRole>)EntityMemberRoles.ALL_MEMBER_STATUS, (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.MEMBER), eventCollector, options, EntityMemberChangedCallback.NOTHING);
        }
    }

    @Override
    public void removeMembers(EntityId entityId, Set<PersonId> membershipsToRemove, MemberChangeOptions options, ServerEventCollector eventCollector) {
        if (!membershipsToRemove.isEmpty()) {
            this._entityMemberService.updateMemberRoles(entityId, membershipsToRemove, (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.MEMBER), (Set<EntityMemberRole>)EntityMemberRoles.EMPTY, eventCollector, options, EntityMemberChangedCallback.NOTHING);
        }
    }

    @Override
    public void addUnallowedUsersToMemberList(EntityId entityId, Set<PersonId> persons, AuthorizationContext authCtx) {
        if (!authCtx.may((ItemId)entityId, (Action)StaticEntityAction.ENTITY_MANAGE_MEMBER)) {
            LOGGER.warn("user {} is not allowed to add members to entity {}.", (Object)authCtx.getUserId(), (Object)entityId);
            return;
        }
        ImmutableSet membersToAdd = authCtx.getPersonIndependentAuthorizationContext().groupByAllowed(entityId, StaticEntityAction.ENTITY_READ_DETAILS, persons).get((Object)Boolean.FALSE);
        if (!membersToAdd.isEmpty()) {
            LOGGER.info("adding users {} as members to recommended entity {}: ", (Object)entityId.asString(), (Object)membersToAdd.toString());
            MemberChangeOptions options = MemberChangeOptions.builder().disableEmailNotification().setEntityNewMembershipWorkstreamMessage(false).setMakeOldAdminCoAdmin(false).setUpdateSubscriptions(false).build();
            this.moveToMemberList(entityId, (Set<PersonId>)membersToAdd, options, authCtx);
        }
    }

    @Override
    public void moveToMemberList(EntityId entityId, Set<PersonId> personIds, MemberChangeOptions options, AuthorizationCheckContextWithUserId authorizationContext) {
        authorizationContext.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_MANAGE_MEMBER);
        Map currentMembers = Maps.filterKeys(this._entityMemberService.getEntityMembersMappedByEntityId(entityId), (Predicate)Predicates.in(personIds));
        ImmutableSet admins = ImmutableSet.copyOf(Maps.filterValues((Map)currentMembers, (Predicate)new NullIsFalsePredicate<EntityMember>(){

            @Override
            protected boolean applySafe(EntityMember input) {
                return EntityMemberRoles.isAdmin(input.getRoles());
            }
        }).keySet());
        boolean currentUserIsAdmin = admins.contains((Object)authorizationContext.getUserId());
        Sets.SetView personsToUpdate = currentUserIsAdmin ? Sets.difference(personIds, (Set)ImmutableSet.of((Object)authorizationContext.getUserId())) : personIds;
        if (!admins.isEmpty()) {
            authorizationContext.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_MAKE_ADMIN);
        }
        if (FluentIterable.from(currentMembers.values()).firstMatch((Predicate)new NullIsFalsePredicate<EntityMember>(){

            @Override
            protected boolean applySafe(EntityMember input) {
                return EntityMemberRoles.isCoAdmin(input.getRoles());
            }
        }).isPresent()) {
            authorizationContext.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_MAKE_COADMIN);
        }
        CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        this._entityMemberService.updateMemberRoles(entityId, (Set<PersonId>)personsToUpdate, (Set<EntityMemberRole>)Sets.union(EntityMemberRoles.ALL_MEMBER_STATUS, EntityMemberRoles.ADMIN_OR_COADMIN), (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.MEMBER), (ServerEventCollector)eventCollector, options, EntityMemberChangedCallback.NOTHING);
        if (!admins.isEmpty() && !currentUserIsAdmin) {
            this._entityAdministrationService.grantMemberToAdmin(entityId, authorizationContext.getUserId(), MemberChangeOptions.buildDefaultWith(authorizationContext));
        }
        eventCollector.fireEvents(this._eventBus);
    }

    @Override
    public void acceptInvitation(EntityId entityId, AuthorizationCheckContextWithUserId authorizationContext) {
        if (!this.acceptInvitationInternal(entityId, authorizationContext)) {
            throw new PermissionDeniedException(this._i18nService.createProxy(BasicConstants.class, authorizationContext.getLocale()).noPermission());
        }
    }

    private boolean acceptInvitationInternal(EntityId entity, AuthorizationCheckContextWithUserId authorizationContext) {
        CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        ImmutableSet permissionsNeeded = ImmutableSet.of((Object)StaticEntityAction.ENTITY_ACCEPT_INVITE);
        boolean result = this._entityMemberService.updateMemberRoles(entity, (Set<? extends Action>)permissionsNeeded, (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.HAS_INVITATION, (Object)EntityMemberRole.HAS_REJECTED), (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.MEMBER), authorizationContext, eventCollector, MemberChangeOptions.buildDefaultWith(authorizationContext), EntityMemberChangedCallback.NOTHING);
        eventCollector.fireEvents(this._eventBus);
        return result;
    }

    @Override
    public ImmutableSetMultimap<EntityId, PersonId> getEntityMembersByEntityTypesAndEntityIdsAndRoles(Set<EntityType> entityTypes, Set<EntityId> entityIds, Set<EntityMemberRole> roles) {
        return this._entityMemberReadDataService.getEntityMembersByEntityTypesAndEntityIdsAndRoles(entityTypes, entityIds, roles);
    }
}

