/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.util.CollectingServerEventCollector;
import de.justsoftware.onx.common.business.events.util.ImmediatelyFiringServerEventCollector;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.business.EntityChildrenService;
import de.justsoftware.onx.container.business.EntityEventWorkflowService;
import de.justsoftware.onx.container.business.EntityMemberChangedCallback;
import de.justsoftware.onx.container.business.EntityMemberReadWriteDataService;
import de.justsoftware.onx.container.business.EntityMemberService;
import de.justsoftware.onx.container.business.EntityMembershipUpdateHandler;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.ObjectWithDepth;
import de.justsoftware.onx.container.business.events.EntityAdminChangedEvent;
import de.justsoftware.onx.container.business.events.EntityInternalInvitationRejectedEvent;
import de.justsoftware.onx.container.business.events.EntityInvitationWithdrawnEvent;
import de.justsoftware.onx.container.business.events.EntityJoinRequestProcessedEvent;
import de.justsoftware.onx.container.business.events.EntityMemberRolesChangedEvent;
import de.justsoftware.onx.container.business.events.EntityMembershipChangedEvent;
import de.justsoftware.onx.container.business.events.NewEntityJoinRequestEvent;
import de.justsoftware.onx.container.business.events.NewMembershipEvent;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import de.justsoftware.onx.container.shared.model.EntityMemberWithEntityType;
import de.justsoftware.onx.container.shared.model.EntityMemberWithPerson;
import de.justsoftware.onx.container.shared.model.EntityMemberWorkflow;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.InheritsRole;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.MemberChangeOptions;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.util.EntityMemberUtil;
import de.justsoftware.onx.events.PersonUpdatedEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Service
@ParametersAreNonnullByDefault
public class EntityMemberServiceImpl
implements EntityMemberService,
EntityMemberChangedCallback {
    @Autowired
    private EntityService _entityService;
    @Autowired
    private EntityChildrenService _entityChildrenService;
    @Autowired
    private JCEventBus _eventBus;
    @Autowired
    private EntityConfigService _entityConfig;
    @Autowired
    private Collection<EntityMembershipUpdateHandler> _entityMembershipUpdateHandlers;
    @Autowired
    private EntityMemberReadWriteDataService _entityMemberReadWriteDataService;
    @Autowired
    private EntityEventWorkflowService _entityEventWorkflowService;
    @Autowired
    private TransactionHelper _transactionHelper;

    private void notifyEntityMemberDeleted(EntityMember oldMember, ServerEventCollector eventCollector) {
        for (EntityMembershipUpdateHandler handler : this._entityMembershipUpdateHandlers) {
            handler.onEntityMemberDelete(oldMember.getEntityId(), oldMember.getPersonId());
        }
        if (EntityMemberUtil.isAdminOrCoAdmin(oldMember)) {
            eventCollector.add(new EntityAdminChangedEvent(oldMember.getEntityId(), oldMember.getPersonId(), EntityMemberRoles.EMPTY, oldMember.getRoles()));
        }
        if (EntityMemberUtil.isShownAsMember(oldMember)) {
            eventCollector.add(new EntityMembershipChangedEvent(oldMember.getEntityId(), (ImmutableSetMultimap<PersonId, EntityMemberRole>)ImmutableSetMultimap.of(), (ImmutableSetMultimap<PersonId, EntityMemberRole>)ImmutableSetMultimap.builder().putAll((Object)oldMember.getPersonId(), oldMember.getRoles()).build(), false));
        }
        if (!EntityMemberUtil.isAdminOrCoAdmin(oldMember) && !EntityMemberUtil.isShownAsMember(oldMember)) {
            eventCollector.add(new EntityMemberRolesChangedEvent(oldMember.getPersonId(), oldMember.getEntityId(), oldMember.getRoles(), (ImmutableSet<EntityMemberRole>)ImmutableSet.of()));
        }
        if (oldMember.getRoles().contains((Object)EntityMemberRole.HAS_INVITATION)) {
            eventCollector.add(new EntityInvitationWithdrawnEvent(oldMember.getPersonId(), oldMember.getEntityId()));
        }
        eventCollector.add(new PersonUpdatedEvent(oldMember.getPersonId()));
    }

    @Override
    public EntityMemberWithEntityType getMemberByPersonIdAndEntityId(PersonId personId, EntityId entityId) {
        if (personId == null) {
            return null;
        }
        ImmutableList<EntityMemberWithEntityType> memberships = this._entityMemberReadWriteDataService.getEntityMembersByPersonId(personId);
        return (EntityMemberWithEntityType)Iterables.find(memberships, (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)entityId), EntityMember.GET_ENTITY_ID), null);
    }

    @Override
    public ImmutableSetMultimap<EntityId, PersonId> getInheritedMembers(InheritsRole role, Set<EntityId> entities) {
        if (entities.isEmpty()) {
            return ImmutableSetMultimap.of();
        }
        ImmutableSetMultimap<EntityId, EntityId> parents = this._entityChildrenService.getBequeathingEntityParentsByChildIds(entities, role);
        ImmutableListMultimap<EntityId, EntityMemberWithPerson> members = this._entityMemberReadWriteDataService.getByEntityIds((Set<EntityId>)parents.inverse().keySet());
        Multimap filteredMembers = Multimaps.filterValues(members, EntityMemberUtil.composeRoleFilterPredicate(role.getRoles()));
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        for (Map.Entry entityEntry : parents.asMap().entrySet()) {
            for (EntityId parent : (Collection)entityEntry.getValue()) {
                result.putAll((Object)((EntityId)entityEntry.getKey()), Iterables.transform((Iterable)filteredMembers.get((Object)parent), EntityMember.GET_PERSON_ID));
            }
        }
        return result.build();
    }

    @Nonnull
    private static ImmutableSet<EntityId> objectWithDepthToEntityId(Iterator<ObjectWithDepth<DBEntity>> objectsWithDepth) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        while (objectsWithDepth.hasNext()) {
            builder.add((Object)objectsWithDepth.next().getObject().getId());
        }
        return builder.build();
    }

    @Override
    public void deleteMember(PersonId personId, EntityId entityId) {
        EntityMemberWithEntityType oldMember = this.getMemberByPersonIdAndEntityId(personId, entityId);
        this.deleteMember(personId, entityId, oldMember);
    }

    private void deleteMember(PersonId personId, EntityId entityId, @Nullable EntityMember oldMember) {
        this._entityMemberReadWriteDataService.mergeMemberRoles((Set<EntityId>)ImmutableSet.of((Object)entityId), (Set<PersonId>)ImmutableSet.of((Object)personId), (Set<EntityMemberRole>)EntityMemberRoles.ALL_MEMBER_STATUS, (Set<EntityMemberRole>)EntityMemberRoles.EMPTY);
        if (oldMember != null) {
            this.notifyEntityMemberDeleted(oldMember, new ImmediatelyFiringServerEventCollector(this._eventBus));
        }
    }

    @Override
    public ImmutableListMultimap<PersonId, EntityMemberWithPerson> getEntityAndInheritedMembersByEntityId(EntityId id) {
        ImmutableList directMembers = this._entityMemberReadWriteDataService.getByEntityIds((Set<EntityId>)ImmutableSet.of((Object)id)).get((Object)id);
        ImmutableList<EntityMemberWithPerson> inheritAdmins = this.getInheritEntityMembersWithPerson(id, InheritsRole.INHERIT_ADMINS);
        ImmutableList<EntityMemberWithPerson> inheritMember = this.getInheritEntityMembersWithPerson(id, InheritsRole.INHERIT_MEMBERS);
        return FluentIterable.concat((Iterable)directMembers, inheritAdmins, inheritMember).index(EntityMember::getPersonId);
    }

    @Override
    public ImmutableListMultimap<EntityId, EntityMemberWithPerson> getEntityMembersByEntityIds(Set<EntityId> ids) {
        return this._entityMemberReadWriteDataService.getByEntityIds(ids);
    }

    @Override
    public ImmutableListMultimap<PersonId, EntityMemberWithEntityType> getEntityMembersByPersonIds(Set<PersonId> ids) {
        return this._entityMemberReadWriteDataService.getByPersonIds(ids);
    }

    @Override
    public ImmutableList<EntityMemberWithPerson> getEntityMembersByEntityId(EntityId id) {
        return this._entityMemberReadWriteDataService.getEntityMemberByEntityId(id);
    }

    @Override
    public ImmutableMap<PersonId, EntityMemberWithPerson> getEntityMembersMappedByEntityId(EntityId id) {
        ImmutableList<EntityMemberWithPerson> unfiltered = this._entityMemberReadWriteDataService.getEntityMemberByEntityId(id);
        return Maps.uniqueIndex(unfiltered, EntityMember.GET_PERSON_ID);
    }

    @Nonnull
    private ImmutableMap<EntityId, EntityMemberWithEntityType> getEntityMembersMappedByPersonId(PersonId id) {
        ImmutableList<EntityMemberWithEntityType> unfiltered = this._entityMemberReadWriteDataService.getEntityMembersByPersonId(id);
        return Maps.uniqueIndex(unfiltered, EntityMember.GET_ENTITY_ID);
    }

    @Override
    public ImmutableSetMultimap<EntityId, EntityMemberRole> getMemberRolesByPersonIdAndEntityTypes(PersonId personId, ImmutableSet<EntityType> types, AuthorizationCheckContextWithUserId auth) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        ImmutableList<EntityMemberWithEntityType> allDirectRoles = this._entityMemberReadWriteDataService.getEntityMembersByPersonId(personId);
        ImmutableSet<EntityId> inheritedAdmins = this.getInheritedRolesByDirectRoles((Iterable<EntityMemberWithEntityType>)allDirectRoles, EntityMemberUtil.composeRoleFilterPredicate(EntityMemberRoles.ADMIN_OR_COADMIN), InheritsRole.INHERIT_ADMINS, types);
        ImmutableSet<EntityId> inheritedMemberships = this.getInheritedRolesByDirectRoles((Iterable<EntityMemberWithEntityType>)allDirectRoles, EntityMemberUtil.composeRoleFilterPredicate(EntityMemberRoles.VISIBLE_MEMBER), InheritsRole.INHERIT_MEMBERS, types);
        for (EntityMemberWithEntityType member : this.getFilteredByEntityType((Iterable<EntityMemberWithEntityType>)allDirectRoles, types)) {
            result.putAll((Object)member.getEntityId(), member.getRoles());
        }
        for (EntityId id : inheritedAdmins) {
            result.put((Object)id, (Object)EntityMemberRole.CO_ADMIN);
        }
        for (EntityId id : inheritedMemberships) {
            result.put((Object)id, (Object)EntityMemberRole.MEMBER);
        }
        return result.build();
    }

    @Nonnull
    private ImmutableSet<EntityId> getInheritedRolesByDirectRoles(Iterable<EntityMemberWithEntityType> directRoles, Predicate<EntityMember> hasRolesPredicate, InheritsRole inheritedRole, ImmutableSet<EntityType> resultTypes) {
        ImmutableSet parentEntityIds = FluentIterable.from(directRoles).filter(hasRolesPredicate).transform(EntityMember.GET_ENTITY_ID).toSet();
        return ImmutableSet.copyOf((Collection)this._entityChildrenService.getInheritedEntityChildrenByParentIds((ImmutableSet<EntityId>)parentEntityIds, resultTypes, inheritedRole).values());
    }

    @Nonnull
    private Iterable<EntityMemberWithEntityType> getFilteredByEntityType(Iterable<EntityMemberWithEntityType> members, ImmutableSet<EntityType> types) {
        return Iterables.filter(members, (Predicate)Predicates.compose(input -> types.contains(input), EntityMemberWithEntityType.GET_ENTITY_TYPE));
    }

    @Override
    public void addMembersToEntity(EntityId entityId, Set<PersonId> personIds, Set<EntityMemberRole> memberRolesToAdd) {
        ImmediatelyFiringServerEventCollector eventCollector = new ImmediatelyFiringServerEventCollector(this._eventBus);
        MemberChangeOptions options = MemberChangeOptions.builder().disableEmailNotification().setEntityNewMembershipWorkstreamMessage(false).setMakeOldAdminCoAdmin(false).setUpdateSubscriptions(false).build();
        this.updateMemberRoles(entityId, personIds, (Set<EntityMemberRole>)EntityMemberRoles.EMPTY, memberRolesToAdd, (ServerEventCollector)eventCollector, options, (EntityMemberChangedCallback)this);
    }

    @Override
    public ImmutableSetMultimap<PersonId, EntityId> getEntityIdsByPersonIdAndMemberRoles(Set<PersonId> personIds, Set<EntityMemberRole> roles) {
        return roles.isEmpty() ? ImmutableSetMultimap.of() : this.transformToIdMultimap((Iterable<? extends EntityMember>)FluentIterable.from((Iterable)this._entityMemberReadWriteDataService.getByPersonIds(personIds).values()).filter(EntityMemberUtil.composePersonFilterPredicate(personIds)).filter(EntityMemberUtil.composeRoleFilterPredicate(roles)));
    }

    @Override
    public ImmutableSetMultimap<EntityId, PersonId> getEntityMembersByEntityTypesAndPersonIdsAndRoles(Set<EntityType> entityTypes, Set<PersonId> personIds, Set<EntityMemberRole> roles) {
        return this._entityMemberReadWriteDataService.getEntityMembersByEntityTypesAndPersonIdsAndRoles(entityTypes, personIds, roles);
    }

    @Override
    public ImmutableList<EntityId> getEntityMembersByEntityTypesAndPersonIdAndRoles(Set<EntityType> entityTypes, PersonId personId, Set<EntityMemberRole> roles, int offset, int limit) {
        return this._entityMemberReadWriteDataService.getEntityMembersByEntityTypesAndPersonIdAndRoles(entityTypes, personId, roles, offset, limit);
    }

    @Override
    public int getExistingCountForEntityMembersByEntityTypesAndPersonIdAndRoles(Set<EntityType> entityTypes, PersonId personId, Set<EntityMemberRole> roles) {
        return this._entityMemberReadWriteDataService.getExistingCountForEntityMembersByEntityTypesAndPersonIdAndRoles(entityTypes, personId, roles);
    }

    @Override
    public ImmutableSetMultimap<PersonId, EntityId> getPersonIdsByEntityIdAndMemberRoles(Set<EntityId> entityIds, Set<EntityMemberRole> roles) {
        return roles.isEmpty() ? ImmutableSetMultimap.of() : this.transformToIdMultimap((Iterable<? extends EntityMember>)FluentIterable.from((Iterable)this._entityMemberReadWriteDataService.getByEntityIds(entityIds).values()).filter(EntityMemberUtil.composeEntityFilterPredicate(entityIds)).filter(EntityMemberUtil.composeRoleFilterPredicate(roles)));
    }

    @Nonnull
    private ImmutableSetMultimap<PersonId, EntityId> transformToIdMultimap(Iterable<? extends EntityMember> members) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        for (EntityMember entityMember : members) {
            result.put((Object)entityMember.getPersonId(), (Object)entityMember.getEntityId());
        }
        return result.build();
    }

    @Override
    public Map<EntityId, EntityMemberWithEntityType> getMemberByPersonIdAndEntityIds(PersonId personId, Set<EntityId> entityIds) {
        ImmutableList<EntityMemberWithEntityType> unfiltered = this._entityMemberReadWriteDataService.getEntityMembersByPersonId(personId);
        ImmutableMap unfilteredMap = Maps.uniqueIndex(unfiltered, EntityMember.GET_ENTITY_ID);
        return Maps.filterKeys((Map)unfilteredMap, (Predicate)Predicates.in(entityIds));
    }

    @Override
    public Map<PersonId, EntityMemberWithPerson> getMemberByEntityIdAndPersonIds(EntityId entityId, Set<PersonId> personIds) {
        ImmutableList<EntityMemberWithPerson> unfiltered = this._entityMemberReadWriteDataService.getEntityMemberByEntityId(entityId);
        ImmutableMap unfilteredMap = Maps.uniqueIndex(unfiltered, EntityMember.GET_PERSON_ID);
        return Maps.filterKeys((Map)unfilteredMap, (Predicate)Predicates.in(personIds));
    }

    @Override
    public void insertMemberToParticipantOrWaitlist(Set<EntityId> entityIds, final PersonId personId) {
        Collection<DBEntity> entities = this._entityService.getByIds(entityIds).values();
        ImmutableSetMultimap.Builder entityMapBuilder = ImmutableSetMultimap.builder();
        for (DBEntity entity : entities) {
            entityMapBuilder.put((Object)this._entityConfig.getEntityMemberWorkflow(entity.getType()), (Object)entity.getId());
        }
        final ImmutableSetMultimap entityWorkflowMap = entityMapBuilder.build();
        final CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        final MemberChangeOptions options = MemberChangeOptions.buildDefault();
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                block4: for (EntityMemberWorkflow emw : EntityMemberWorkflow.values()) {
                    switch (emw) {
                        case EVENT: {
                            EntityMemberServiceImpl.this.updateMemberRoles((Set<EntityId>)entityWorkflowMap.get((Object)emw), personId, (Set<EntityMemberRole>)EntityMemberRoles.ALL_EVENT_STATUS, (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.EVENT_IS_ON_WAITINGLIST), (ServerEventCollector)eventCollector, options, (EntityMemberChangedCallback)EntityMemberServiceImpl.this._entityEventWorkflowService);
                            continue block4;
                        }
                        case MEMBER: {
                            EntityMemberServiceImpl.this.updateMemberRoles((Set<EntityId>)entityWorkflowMap.get((Object)emw), personId, (Set<EntityMemberRole>)EntityMemberRoles.ALL_MEMBER_STATUS, (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.MEMBER), (ServerEventCollector)eventCollector, options, EntityMemberChangedCallback.NOTHING);
                        }
                    }
                }
            }
        });
        eventCollector.fireEvents(this._eventBus);
    }

    @Override
    public ImmutableList<EntityMemberWithEntityType> getEntityMembershipsByPersonId(PersonId personId) {
        return this._entityMemberReadWriteDataService.getEntityMembersByPersonId(personId);
    }

    @Override
    public boolean isMemberOfSameEntity(PersonId personId, PersonId otherPersonId) {
        return this._entityMemberReadWriteDataService.isMemberOfSameEntity(personId, otherPersonId);
    }

    @Override
    public ImmutableSetMultimap<PersonId, PersonId> getMembersOfSameEntityOfPersons(Set<PersonId> personIds) {
        return this._entityMemberReadWriteDataService.fetchMembersOfSameEntityOfPersons(personIds);
    }

    @Nonnull
    private ImmutableList<EntityMemberWithPerson> getInheritEntityMembersWithPerson(EntityId entityId, InheritsRole inheritsRole) {
        EntityService.SearchDepth searchDepth = inheritsRole == InheritsRole.INHERIT_ADMINS ? EntityService.SearchDepth.DIRECT_AND_INDIRECT_ADMIN_PARENTS : EntityService.SearchDepth.DIRECT_AND_INDIRECT_MEMBER_PARENTS;
        ImmutableSet<EntityId> inheritParents = EntityMemberServiceImpl.objectWithDepthToEntityId(this._entityService.getAllParents(entityId, false, true, searchDepth));
        ImmutableListMultimap<EntityId, EntityMemberWithPerson> map = this._entityMemberReadWriteDataService.getByEntityIds((Set<EntityId>)inheritParents);
        ImmutableSet<EntityMemberRole> filterRoles = inheritsRole == InheritsRole.INHERIT_ADMINS ? EntityMemberRoles.ADMIN_OR_COADMIN : EntityMemberRoles.VISIBLE_MEMBER;
        ImmutableSet inheritsRoleSet = inheritsRole == InheritsRole.INHERIT_ADMINS ? ImmutableSet.of((Object)EntityMemberRole.CO_ADMIN) : ImmutableSet.of((Object)EntityMemberRole.MEMBER);
        HashSet<PersonId> alreadyExists = new HashSet<PersonId>();
        ImmutableList.Builder members = ImmutableList.builder();
        for (EntityId id : inheritParents) {
            for (EntityMemberWithPerson input : EntityMemberUtil.filterByRoles(map.get((Object)id), filterRoles)) {
                if (!alreadyExists.add(input.getPersonId())) continue;
                members.add((Object)new EntityMemberWithPerson(input.getPersonId(), input.getEntityId(), (Iterable<EntityMemberRole>)inheritsRoleSet, input.isActive(), input.isHasImage(), EntityMember.InheritanceType.INHERITED, input.getFirstName(), input.getLastName(), input.getTitle(), input.getAdditionalTitle()));
            }
        }
        return members.build();
    }

    @Override
    public ListAndCount<EntityMemberWithPerson> getInheritPersons(EntityId entityId, InheritsRole inheritsRole, String filter, boolean activeOnly, AuthorizationCheckContextWithLocale context, int offset, int limit) {
        context.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_READ_DETAILS);
        ImmutableList<EntityMemberWithPerson> inheritedMembers = this.getInheritEntityMembersWithPerson(entityId, inheritsRole);
        ImmutableList members = FluentIterable.from(inheritedMembers).filter(activeOnly ? EntityMemberWithPerson::isActive : Predicates.alwaysTrue()).filter(EntityMemberUtil.matchSearchQuery(filter)).toSortedList((Comparator)Ordering.from((Comparator)Collator.getInstance(Locale.GERMAN)).onResultOf(EntityMemberWithPerson.LASTNAME));
        return new ListAndCount<EntityMemberWithPerson>((List<EntityMemberWithPerson>)members, offset, limit);
    }

    @Override
    public void notifyRoleChangeAfterBatchUpdate(Iterable<? extends EntityMember> membersBeforeUpdate, ImmutableSet<EntityMemberRole> newRoles, MemberChangeOptions options, ServerEventCollector eventCollector) {
        for (EntityMember entityMember : membersBeforeUpdate) {
            this.handleRolesChanged((Set<EntityMemberChangedCallback>)ImmutableSet.of((Object)this), membersBeforeUpdate, (Set<EntityMemberRole>)entityMember.getRoles(), (Set<EntityMemberRole>)newRoles, eventCollector, options);
        }
    }

    @Override
    public void deleteAllRoles(PersonId personId, EntityId entityId) throws ServiceException {
        EntityMemberWithEntityType member = this.getMemberByPersonIdAndEntityId(personId, entityId);
        if (member != null) {
            if (EntityMemberUtil.isAdmin(member)) {
                throw new ServiceException("you can't remove the only admin of entity " + entityId);
            }
            this.updateMemberRoles(entityId, (Set<PersonId>)ImmutableSet.of((Object)personId), (Set<EntityMemberRole>)member.getRoles(), (Set<EntityMemberRole>)EntityMemberRoles.EMPTY, (ServerEventCollector)new ImmediatelyFiringServerEventCollector(this._eventBus), MemberChangeOptions.buildDefault(), (EntityMemberChangedCallback)this);
        }
    }

    @Override
    public boolean updateMemberRoles(EntityId entityId, Set<? extends Action> actions, Set<EntityMemberRole> rolesToRemove, Set<EntityMemberRole> rolesToAdd, AuthorizationCheckContextWithUserId authorizationContext, ServerEventCollector eventCollector, MemberChangeOptions options, EntityMemberChangedCallback memberChangedCallback) {
        boolean mayUpdateMemberRoles;
        ImmutableSet<Action> allowedActions = authorizationContext.may((ItemId)entityId, (ImmutableSet<? extends Action>)ImmutableSet.copyOf(actions));
        boolean bl = mayUpdateMemberRoles = actions.isEmpty() || !allowedActions.isEmpty();
        if (!mayUpdateMemberRoles) {
            return false;
        }
        this.updateMemberRoles((Set<EntityId>)ImmutableSet.of((Object)entityId), authorizationContext.getUserId(), rolesToRemove, rolesToAdd, eventCollector, options, memberChangedCallback);
        return true;
    }

    @Override
    public void updateMemberRoles(Set<EntityId> entityIds, PersonId personId, Set<EntityMemberRole> rolesToRemove, Set<EntityMemberRole> rolesToAdd, ServerEventCollector eventCollector, MemberChangeOptions options, @Nullable EntityMemberChangedCallback memberChangedCallback) {
        if (entityIds.isEmpty() || rolesToRemove.isEmpty() && rolesToAdd.isEmpty()) {
            return;
        }
        ImmutableMap<EntityId, EntityMemberWithEntityType> currentMembership = this.getEntityMembersMappedByPersonId(personId);
        ArrayList updatedMemberships = Lists.newArrayList();
        for (EntityId entityId : entityIds) {
            EntityMember existing = (EntityMember)currentMembership.get((Object)entityId);
            if (existing == null) {
                updatedMemberships.add(new EntityMemberService.NonExistingEntityMember(personId, entityId));
                continue;
            }
            updatedMemberships.add(existing);
        }
        if (updatedMemberships.size() > 0) {
            this._entityMemberReadWriteDataService.mergeMemberRoles(entityIds, (Set<PersonId>)ImmutableSet.of((Object)personId), rolesToRemove, rolesToAdd);
            ImmutableSet callbacks = memberChangedCallback == null ? ImmutableSet.of((Object)this) : ImmutableSet.of((Object)this, (Object)memberChangedCallback);
            this.handleRolesChanged((Set<EntityMemberChangedCallback>)callbacks, updatedMemberships, rolesToRemove, rolesToAdd, eventCollector, options);
        }
    }

    @Override
    public void updateMemberRoles(EntityId entityId, Set<PersonId> personIds, Set<EntityMemberRole> rolesToRemove, Set<EntityMemberRole> rolesToAdd, ServerEventCollector eventCollector, MemberChangeOptions options, @Nullable EntityMemberChangedCallback memberChangedCallback) {
        if (personIds.isEmpty() || rolesToRemove.isEmpty() && rolesToAdd.isEmpty()) {
            return;
        }
        ImmutableMap<PersonId, EntityMemberWithPerson> currentMembership = this.getEntityMembersMappedByEntityId(entityId);
        ArrayList updatedMemberships = Lists.newArrayList();
        for (PersonId personId : personIds) {
            EntityMember existing = (EntityMember)currentMembership.get(personId);
            if (existing == null) {
                updatedMemberships.add(new EntityMemberService.NonExistingEntityMember(personId, entityId));
                continue;
            }
            updatedMemberships.add(existing);
        }
        if (updatedMemberships.size() > 0) {
            this._entityMemberReadWriteDataService.mergeMemberRoles((Set<EntityId>)ImmutableSet.of((Object)entityId), personIds, rolesToRemove, rolesToAdd);
            ImmutableSet callbacks = memberChangedCallback == null ? ImmutableSet.of((Object)this) : ImmutableSet.of((Object)this, (Object)memberChangedCallback);
            this.handleRolesChanged((Set<EntityMemberChangedCallback>)callbacks, updatedMemberships, rolesToRemove, rolesToAdd, eventCollector, options);
        }
    }

    private void handleRolesChanged(Set<EntityMemberChangedCallback> callbacks, Iterable<? extends EntityMember> membersBeforeUpdate, Set<EntityMemberRole> rolesRemoved, Set<EntityMemberRole> rolesAdded, ServerEventCollector eventCollector, MemberChangeOptions options) {
        for (EntityMember entityMember : membersBeforeUpdate) {
            for (EntityMemberChangedCallback callback : callbacks) {
                ImmutableSet<EntityMemberRole> newRoles = EntityMemberRoles.replaceRoles(entityMember.getRoles(), rolesRemoved, rolesAdded);
                if (entityMember.getRoles().equals(newRoles)) continue;
                callback.onMemberRolesChanged(entityMember.getEntityId(), entityMember.getPersonId(), newRoles, entityMember.getRoles(), options, eventCollector);
            }
        }
    }

    @Override
    public void onMemberRolesChanged(EntityId entityId, PersonId personId, ImmutableSet<EntityMemberRole> newRoles, ImmutableSet<EntityMemberRole> oldRoles, MemberChangeOptions options, ServerEventCollector eventCollector) {
        boolean wasParticipant;
        boolean isParticipant;
        boolean wasCoAdmin;
        for (EntityMembershipUpdateHandler handler : this._entityMembershipUpdateHandlers) {
            handler.onEntityMembershipChange(entityId, personId, newRoles);
        }
        if (!newRoles.equals(oldRoles)) {
            eventCollector.add(new EntityMemberRolesChangedEvent(personId, entityId, newRoles, oldRoles));
        }
        boolean isAdmin = EntityMemberRoles.isAdmin(newRoles);
        boolean wasAdmin = EntityMemberRoles.isAdmin(oldRoles);
        boolean isCoAdmin = EntityMemberRoles.isCoAdmin(newRoles);
        if (isCoAdmin != (wasCoAdmin = EntityMemberRoles.isCoAdmin(oldRoles)) || isAdmin != wasAdmin) {
            eventCollector.add(new EntityAdminChangedEvent(entityId, personId, newRoles, oldRoles));
        }
        if ((isParticipant = EntityMemberRoles.isShownAsMember(newRoles)) != (wasParticipant = EntityMemberRoles.isShownAsMember(oldRoles))) {
            eventCollector.add(new EntityMembershipChangedEvent(entityId, (ImmutableSetMultimap<PersonId, EntityMemberRole>)ImmutableSetMultimap.builder().putAll((Object)personId, newRoles).build(), (ImmutableSetMultimap<PersonId, EntityMemberRole>)ImmutableSetMultimap.builder().putAll((Object)personId, oldRoles).build(), options.isBulk()));
            if (isParticipant) {
                eventCollector.add(new NewMembershipEvent(entityId, personId, options));
            }
        }
        this.checkJoinRequests(entityId, personId, newRoles, oldRoles, options, eventCollector);
        this.checkInvitations(entityId, personId, newRoles, oldRoles, eventCollector);
        eventCollector.add(new PersonUpdatedEvent(personId));
    }

    private void checkJoinRequests(EntityId entityId, PersonId personId, ImmutableSet<EntityMemberRole> newRoles, ImmutableSet<EntityMemberRole> oldRoles, MemberChangeOptions options, ServerEventCollector eventCollector) {
        boolean hadSentJoinRequest = EntityMemberRoles.hasSentJoinRequest(oldRoles);
        boolean newSentJoinRequest = EntityMemberRoles.hasSentJoinRequest(newRoles);
        if (hadSentJoinRequest && !newSentJoinRequest) {
            eventCollector.add(new EntityJoinRequestProcessedEvent(entityId, options.getActor(personId), personId, EntityMemberRoles.isMember(newRoles), options.isSendMailNotification()));
        }
        if (!hadSentJoinRequest && newSentJoinRequest) {
            eventCollector.add(new NewEntityJoinRequestEvent(personId, entityId));
        }
    }

    private void checkInvitations(EntityId entityId, PersonId personId, ImmutableSet<EntityMemberRole> newRoles, ImmutableSet<EntityMemberRole> oldRoles, ServerEventCollector eventCollector) {
        boolean isInvited = EntityMemberRoles.isInvited(newRoles);
        boolean wasInvited = EntityMemberRoles.isInvited(oldRoles);
        if (wasInvited && !isInvited) {
            if (EntityMemberRoles.hasRejected(newRoles) || EntityMemberRoles.hasRejectedEventInvitation(newRoles)) {
                eventCollector.add(new EntityInternalInvitationRejectedEvent(personId, entityId));
            } else {
                eventCollector.add(new EntityInvitationWithdrawnEvent(personId, entityId));
            }
        }
    }
}

