/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.freiheit.toro.cache.CacheClient;
import com.freiheit.toro.cache.ehcache.EhCacheName;
import com.freiheit.toro.cache.ehcache.EhcacheClient;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.justsoftware.onx.common.cache.AbstractBiDirectionalCacheAccessor;
import de.justsoftware.onx.common.cache.AbstractListMultiMapCacheAccessor;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.business.EntityMemberReadWriteDataService;
import de.justsoftware.onx.container.integration.persistence.EntityMemberDAO;
import de.justsoftware.onx.container.integration.persistence.EntityMemberRoleDAO;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberWithEntityType;
import de.justsoftware.onx.container.shared.model.EntityMemberWithPerson;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.util.EntityMemberUtil;
import de.justsoftware.onx.person.integration.persistence.DBPersonRelation;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class EntityMemberReadWriteDataServiceImpl
implements EntityMemberReadWriteDataService {
    private final EhcacheClient _ehcacheClient;
    private final EntityMemberDAO _dao;
    private final MemberOfSameEntityCacheAccessor _memberOfSameEntityCache;
    private final EntityMemberByPersonIdCacheAccessor _byPersonCache;
    private final EntityMemberByEntityIdCacheAccessor _byEntityCache;
    private final EntityMemberRoleDAO _roleDao;

    @Autowired
    @ParametersAreNonnullByDefault
    public EntityMemberReadWriteDataServiceImpl(EhcacheClient ehcacheClient, EntityMemberDAO dao, EntityMemberRoleDAO roleDao) {
        this._ehcacheClient = ehcacheClient;
        this._dao = dao;
        this._byPersonCache = new EntityMemberByPersonIdCacheAccessor(this._ehcacheClient, this._dao);
        this._byEntityCache = new EntityMemberByEntityIdCacheAccessor(this._ehcacheClient, this._dao);
        this._memberOfSameEntityCache = new MemberOfSameEntityCacheAccessor(this._ehcacheClient, this._dao);
        this._roleDao = roleDao;
    }

    @Override
    public void invalidateCache(Set<PersonId> personIds, Set<EntityId> entityIds) {
        this._byEntityCache.invalidateKeysAndWait(Sets.union(entityIds, EntityMemberUtil.transformToEntityIdSet(this._dao.getByPersonIds(personIds))));
        this._byPersonCache.invalidateKeysAndWait(personIds);
        this._memberOfSameEntityCache.invalidateKeysAndWait(Sets.union(personIds, EntityMemberUtil.transformToPersonIdSet(this._dao.getByEntityIds(entityIds))));
    }

    @Override
    public void invalidateCacheForDeletedEntities(Set<EntityId> entityIds) {
        Set personsToInvalidate = ((ImmutableListMultimap)this._byEntityCache.getMultiMap(entityIds)).values().stream().map(EntityMemberWithPerson::getPersonId).collect(Collectors.toSet());
        this._byEntityCache.invalidateKeysAndWait(entityIds);
        this._byPersonCache.invalidateKeysAndWait(personsToInvalidate);
        this._memberOfSameEntityCache.invalidateKeysAndWait(personsToInvalidate);
    }

    @Override
    public ImmutableSetMultimap<PersonId, PersonId> fetchMembersOfSameEntityOfPersons(Set<PersonId> personIds) {
        return (ImmutableSetMultimap)this._memberOfSameEntityCache.getMultiMap(personIds);
    }

    @Override
    public boolean isMemberOfSameEntity(PersonId personId, PersonId otherPersonId) {
        return this._memberOfSameEntityCache.isInRelation(personId, otherPersonId);
    }

    @Nonnull
    private ImmutableList<EntityMemberWithEntityType> transformEntityIdsToEntityMemberForPerson(PersonId personId, Iterable<EntityId> entityIds) {
        Function f = Functions.forMap((Map)Maps.uniqueIndex(this.getEntityMembersByPersonId(personId), EntityMember.GET_ENTITY_ID), null);
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform(entityIds, (Function)f), (Predicate)Predicates.notNull()));
    }

    @Override
    public ImmutableList<EntityMemberWithPerson> getJoinRequests(PersonId personId, Iterable<EntityType> types) {
        final ImmutableSetMultimap<EntityId, PersonId> joinRequests = this._roleDao.getJoinRequests(personId, types);
        ImmutableListMultimap<EntityId, EntityMemberWithPerson> byEntityIds = this.getByEntityIds((Set<EntityId>)joinRequests.keySet());
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)byEntityIds.values(), (Predicate)new Predicate<EntityMemberWithPerson>(){

            public boolean apply(@Nullable EntityMemberWithPerson input) {
                return input != null && joinRequests.get((Object)input.getEntityId()).contains((Object)input.getPersonId());
            }
        }));
    }

    @Override
    public ImmutableSet<PersonId> getMemberIdsWithProfileImage(EntityId id) {
        return this._roleDao.getPersonIdsWithProfileImage(id);
    }

    @Override
    public ImmutableSet<PersonId> getMemberIdsWithoutProfileImage(EntityId id) {
        return this._roleDao.getPersonIdsWithoutProfileImage(id);
    }

    @Override
    public ImmutableList<EntityMemberWithEntityType> getEntityMembersByPersonId(PersonId personId) {
        return (ImmutableList)this._byPersonCache.getSingle(personId);
    }

    @Override
    public ImmutableSetMultimap<EntityId, PersonId> getEntityMembersByEntityTypesAndPersonIdsAndRoles(Iterable<EntityType> entityTypes, Set<PersonId> personIds, Set<EntityMemberRole> roles) {
        return this._roleDao.getEntityMembersByEntityTypesAndPersonIdsAndRoles(entityTypes, personIds, roles);
    }

    @Override
    public ImmutableList<EntityId> getEntityMembersByEntityTypesAndPersonIdAndRoles(Iterable<EntityType> entityTypes, PersonId personId, Set<EntityMemberRole> roles, int offset, int limit) {
        return this._roleDao.getEntityMembersByEntityTypesAndPersonIdAndRoles(entityTypes, personId, roles, offset, limit);
    }

    @Override
    public int getExistingCountForEntityMembersByEntityTypesAndPersonIdAndRoles(Iterable<EntityType> entityTypes, PersonId personId, Set<EntityMemberRole> roles) {
        return this._roleDao.getExistingCountForEntityMembersByEntityTypesAndPersonIdAndRoles(entityTypes, personId, roles);
    }

    @Override
    public ImmutableSetMultimap<EntityId, PersonId> getMembersByEntityTypesAndRoles(Set<EntityType> entityTypes, Set<EntityMemberRole> roles) {
        return this._roleDao.getMembersByEntityTypesAndRoles(entityTypes, roles);
    }

    @Override
    public ImmutableList<EntityMemberWithPerson> getEntityMemberByEntityId(EntityId entityId) {
        return (ImmutableList)this._byEntityCache.getSingle(entityId);
    }

    @Override
    public ImmutableListMultimap<EntityId, EntityMemberWithPerson> getByEntityIds(Set<EntityId> entityIds) {
        return (ImmutableListMultimap)this._byEntityCache.getMultiMap(entityIds);
    }

    @Override
    public ImmutableListMultimap<PersonId, EntityMemberWithEntityType> getByPersonIds(Set<PersonId> personIds) {
        return (ImmutableListMultimap)this._byPersonCache.getMultiMap(personIds);
    }

    @Override
    public void persistMemberRoles(Set<EntityId> entityIds, Set<PersonId> personIds, Set<EntityMemberRole> roles) {
        this._roleDao.persistRoles(entityIds, personIds, roles);
        this.invalidateCache(personIds, entityIds);
    }

    @Override
    public void mergeMemberRoles(Set<EntityId> entityIds, Set<PersonId> personIds, Set<EntityMemberRole> rolesToRemove, Set<EntityMemberRole> rolesToAdd) {
        this._roleDao.mergeRoles(entityIds, personIds, rolesToRemove, rolesToAdd);
        this.invalidateCache(personIds, entityIds);
    }

    @Override
    public ImmutableSetMultimap<EntityId, PersonId> getEntityMembersByEntityTypesAndEntityIdsAndRoles(Set<EntityType> entityTypes, Set<EntityId> entityIds, Set<EntityMemberRole> roles) {
        return this._roleDao.getEntityMembersByEntityTypesAndEntityIdsAndRoles(entityTypes, entityIds, roles);
    }

    @ParametersAreNonnullByDefault
    private static class MemberOfSameEntityCacheAccessor
    extends AbstractBiDirectionalCacheAccessor<EntityMemberEhCacheName, PersonId, DBPersonRelation> {
        private final EntityMemberDAO _entityMemberDAO;

        MemberOfSameEntityCacheAccessor(CacheClient<? super EntityMemberEhCacheName> cache, EntityMemberDAO entityMemberDAO) {
            super(cache, EntityMemberEhCacheName.MEMBER_OF_SAME_ENTITY);
            this._entityMemberDAO = entityMemberDAO;
        }

        @Override
        protected PersonId objectToValue(DBPersonRelation dbResult) {
            return dbResult.getTo();
        }

        @Override
        protected PersonId objectToKey(DBPersonRelation dbResult) {
            return dbResult.getFrom();
        }

        @Override
        protected Iterable<? extends DBPersonRelation> getListFromDatabase(Set<? extends PersonId> inputs) {
            return this._entityMemberDAO.getMembersOfSameEntityOfPersons(inputs);
        }

        @Override
        protected String keyToString(PersonId key) {
            return key.toString();
        }
    }

    @ParametersAreNonnullByDefault
    private static class EntityMemberByPersonIdCacheAccessor
    extends AbstractListMultiMapCacheAccessor<EntityMemberEhCacheName, PersonId, EntityMemberWithEntityType> {
        private final EntityMemberDAO _dao;

        protected EntityMemberByPersonIdCacheAccessor(CacheClient<? super EntityMemberEhCacheName> cache, EntityMemberDAO dao) {
            super(cache, EntityMemberEhCacheName.MEMBER_BY_PERSON_ID);
            this._dao = dao;
        }

        @Override
        protected PersonId objectToKey(EntityMemberWithEntityType dbResult) {
            return dbResult.getPersonId();
        }

        @Override
        protected Iterable<EntityMemberWithEntityType> getListFromDatabase(Set<? extends PersonId> inputs) {
            return this._dao.getByPersonIds(inputs);
        }

        @Override
        protected String keyToString(PersonId key) {
            return Long.toString(key.getId());
        }
    }

    @ParametersAreNonnullByDefault
    private static class EntityMemberByEntityIdCacheAccessor
    extends AbstractListMultiMapCacheAccessor<EntityMemberEhCacheName, EntityId, EntityMemberWithPerson> {
        private final EntityMemberDAO _dao;

        protected EntityMemberByEntityIdCacheAccessor(CacheClient<? super EntityMemberEhCacheName> cache, EntityMemberDAO dao) {
            super(cache, EntityMemberEhCacheName.MEMBER_BY_ENTITY_ID);
            this._dao = dao;
        }

        @Override
        protected EntityId objectToKey(EntityMemberWithPerson dbResult) {
            return dbResult.getEntityId();
        }

        @Override
        protected Iterable<EntityMemberWithPerson> getListFromDatabase(Set<? extends EntityId> inputs) {
            return this._dao.getByEntityIds(inputs);
        }

        @Override
        protected String keyToString(EntityId key) {
            return Long.toString(key.getId());
        }
    }

    public static enum EntityMemberEhCacheName implements EhCacheName
    {
        MEMBER_BY_ENTITY_ID("EntityMember.entityId"),
        MEMBER_BY_PERSON_ID("EntityMember.personId"),
        MEMBER_OF_SAME_ENTITY("EntityMember.memberOfSameEntity");

        private final String _prefix;

        private EntityMemberEhCacheName(String prefix) {
            this._prefix = prefix;
        }

        @Override
        public String getCacheName() {
            return this._prefix;
        }
    }
}

