/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.base.Function;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.kafka.client.KafkaCleaningProducerState;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.business.EntityAdministrationWorkflowService;
import de.justsoftware.onx.container.business.EntityItemPublishService;
import de.justsoftware.onx.container.business.EntityVersionService;
import de.justsoftware.onx.container.business.ItemPublishService;
import de.justsoftware.onx.container.business.events.EntityCreatedEvent;
import de.justsoftware.onx.container.business.events.EntityNameUpdatedEvent;
import de.justsoftware.onx.container.integration.persistence.EntityDAO;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.ItemType;
import de.justsoftware.onx.server.business.JucoServerVersionUpdateProcessor;
import de.justsoftware.onx.server.business.UpdateBehaviour;
import de.justsoftware.onx.server.model.JucoVersionUpdateProcess;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class EntityItemPublishServiceImpl
implements ServerEventHandler,
JucoServerVersionUpdateProcessor,
EntityItemPublishService {
    private final ItemPublishService _itemPublishService;
    private final EntityVersionService _entityVersionService;
    private final EntityDAO _entityDAO;
    private volatile boolean _running = false;
    private final EntityAdministrationWorkflowService _entityAdministrationWorkflowService;

    @Autowired
    public EntityItemPublishServiceImpl(ItemPublishService itemPublishService, EntityVersionService entityVersionService, EntityDAO entityDAO, EntityAdministrationWorkflowService entityAdministrationWorkflowService) {
        this._itemPublishService = itemPublishService;
        this._entityVersionService = entityVersionService;
        this._entityDAO = entityDAO;
        this._entityAdministrationWorkflowService = entityAdministrationWorkflowService;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityCreated(EntityCreatedEvent event) {
        this.publish(event.getEntityId(), event.getName(), event.getEntityType(), (Function<EntityType, EntityStatus>)((Function)this::draftStatus), event.getPersonId());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityNameUpdated(EntityNameUpdatedEvent event) {
        EntityMember adminMembership = this._entityAdministrationWorkflowService.getAdmin(event.getEntityId());
        this.publish(event.getEntityId(), event.getEntityName(), event.getEntityType(), (Function<EntityType, EntityStatus>)((Function)this::draftStatus), adminMembership != null ? adminMembership.getPersonId() : null);
    }

    private void publish(EntityId entityId, String name, EntityType entityType, Function<EntityType, EntityStatus> draftStatusFunction, @Nullable PersonId admin) {
        this._itemPublishService.publishItem(entityId, name, ((EntityStatus)draftStatusFunction.apply((Object)entityType)).isPublished(), admin);
    }

    @Nonnull
    private EntityStatus draftStatus(EntityType entityType) {
        return this._entityVersionService.draftStatus(entityType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publishAllEntities() {
        if (this._running) {
            throw new ServiceException("a entity publish process is already running!");
        }
        if (!this._itemPublishService.isReady()) {
            throw new ServiceException("producer is not ready!");
        }
        this._running = true;
        try (KafkaCleaningProducerState<String> state = this._itemPublishService.beginRefill();){
            HashMap cache = new HashMap();
            Function typeToStatus = entityType -> cache.computeIfAbsent(entityType, this::draftStatus);
            this._entityDAO.forAllEntities((entityId, name, entityType, admin) -> this.publish(entityId, name, entityType, (Function<EntityType, EntityStatus>)typeToStatus, admin));
            state.finishRefill(key -> this._itemPublishService.keyHasType((String)key, ItemType.ENTITY));
        }
        finally {
            this._running = false;
        }
    }

    @Override
    public JucoVersionUpdateProcess getProcessType() {
        return JucoVersionUpdateProcess.PUBLISH_ENTITY_ITEMS;
    }

    @Override
    public UpdateBehaviour getUpdateBehaviour() {
        return UpdateBehaviour.onceOnMasterForVersion(this, "10.0.0");
    }

    @Override
    public boolean preconditionsMet() {
        return !this._running && this._itemPublishService.isReady();
    }

    @Override
    public void process() {
        this.publishAllEntities();
    }
}

