/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.freiheit.toro.common.shared.server.storage.StorageServerHelper;
import com.freiheit.toro.common.shared.util.ImageType;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.business.EntityImageService;
import de.justsoftware.onx.container.business.EntityReadWriteDataService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

@Service
@ParametersAreNonnullByDefault
public class EntityImageServiceImpl
implements EntityImageService {
    private final EntityService _entityService;
    private final EntityReadWriteDataService _entityReadWriteDataService;
    private final TransactionHelper _transactionHelper;
    private final StorageServerHelper _storageServerHelper;

    @Autowired
    public EntityImageServiceImpl(EntityService entityService, EntityReadWriteDataService entityReadWriteDataService, TransactionHelper transactionHelper, StorageServerHelper storageServerHelper) {
        this._entityService = entityService;
        this._entityReadWriteDataService = entityReadWriteDataService;
        this._transactionHelper = transactionHelper;
        this._storageServerHelper = storageServerHelper;
    }

    @Override
    public void saveEntityImage(final EntityId entityId, final EntityImageService.EntityImageType imageType, final String filename, AuthorizationCheckContext authCtx) {
        authCtx.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_MODIFY);
        String oldFilename = this._transactionHelper.doInTransaction(new TransactionCallback<String>(){

            public String doInTransaction(TransactionStatus status) {
                String oldFileName;
                DBEntity entity = EntityImageServiceImpl.this._entityService.getById(entityId);
                switch (imageType) {
                    case ICON: {
                        oldFileName = entity.getIcon();
                        entity.setIcon(filename);
                        break;
                    }
                    case LOGO: {
                        oldFileName = entity.getLogo();
                        entity.setLogo(filename);
                        break;
                    }
                    case SLIDESHOW: {
                        oldFileName = entity.getSlideshowImage();
                        entity.setSlideshowImage(filename);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("no such image type: " + imageType);
                    }
                }
                EntityImageServiceImpl.this._entityReadWriteDataService.updateEntity(entity);
                return oldFileName;
            }
        });
        if (oldFilename != null) {
            this._storageServerHelper.deleteFileOnStorageServer(ImageType.ENTITY_IMAGE.getPath(), oldFilename);
        }
    }
}

