/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import de.justsoftware.onx.album.business.AlbumService;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.shared.model.EntityVersionClientModel;
import de.justsoftware.onx.common.shared.model.OptionsItem;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.Actions;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.model.action.VisibleActionSet;
import de.justsoftware.onx.common.shared.model.component.ComponentTypes;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.container.business.EntityChildrenService;
import de.justsoftware.onx.container.business.EntityDetailsService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.EntityVersionService;
import de.justsoftware.onx.container.business.model.EntityVersion;
import de.justsoftware.onx.container.shared.model.EntityDetails;
import de.justsoftware.onx.container.shared.model.EntityDetailsNotVisibleException;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.MyMemberStatus;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.DBEntityLink;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.like.business.LikeService;
import de.justsoftware.onx.like.shared.model.SubscriptionStatus;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import de.justsoftware.onx.searchnew.shared.model.ArchiveSubFilter;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeCountType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypes;
import de.justsoftware.onx.searchnew.shared.model.StaticFilterType;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import de.justsoftware.onx.survey.business.SurveyService;
import de.justsoftware.onx.videolink.business.VideolinkService;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EntityDetailsServiceImpl
implements EntityDetailsService {
    @Autowired
    private EntityService _entityService;
    @Autowired
    private EntityChildrenService _entityChildrenService;
    @Autowired
    private LikeService _likeService;
    @Autowired
    private EntityConfigService _entityConfig;
    @Autowired
    private EntityVersionService _entityVersionService;
    @Autowired
    private ProfileTeaserService _profileTeaserService;
    @Autowired
    private AlbumService _albumService;
    @Autowired
    private VideolinkService _videolinkService;
    @Autowired
    private SurveyService _surveyService;

    @Override
    public EntityDetails getDetailsById(EntityId id, AuthorizationContext authCtx) throws EntityDetailsNotVisibleException {
        EntityItem item = new EntityItem(this._entityService.getByIdNotNull(id));
        return this.createDetails(authCtx, item);
    }

    @Nonnull
    protected final EntityDetails createDetails(@Nonnull AuthorizationContext authorizationContext, @Nonnull EntityItem item) throws EntityDetailsNotVisibleException {
        DBEntity entity = item.getEntity();
        SubscriptionStatus subscriptionStatus = this.getSubscriptionStatus(entity, authorizationContext);
        EntityId entityId = entity.getId();
        ImmutableSet permissions = this._entityService.getAllowedEntityActions((Set<EntityId>)ImmutableSet.of((Object)entityId), VisibleActionSet.OPTIONS_MODULE, (Map<? extends ItemId, SubscriptionStatus>)ImmutableMap.of((Object)entityId, (Object)subscriptionStatus), authorizationContext).get((Object)entityId);
        MyMemberStatus myMembership = (MyMemberStatus)Preconditions.checkNotNull((Object)((MyMemberStatus)this._entityService.getMyMemberStatus(authorizationContext, (Map<EntityId, DBEntity>)ImmutableMap.of((Object)entityId, (Object)entity)).get((Object)entityId)));
        if (!permissions.contains((Object)StaticEntityAction.ENTITY_READ_DETAILS)) {
            PersonId userId = authorizationContext.getUserId();
            this._likeService.removeUnallowedSubscriptions((SetMultimap<? extends ItemId, PersonId>)ImmutableSetMultimap.of((Object)entityId, (Object)userId), authorizationContext.getPersonIndependentAuthorizationContext());
            throw new EntityDetailsNotVisibleException(this._entityService.createPlaceholder(entity, authorizationContext), (Set<Action>)permissions, subscriptionStatus, myMembership);
        }
        ImmutableMap<FilterType, ImmutableMultiset<FilterTypeCountType>> visibleChildrenCount = this.getVisibleChildrenCount(authorizationContext, entityId);
        int visibleHierarchyChildrenCount = this._entityChildrenService.findVisibleDirectChildren(entity.getId(), this._entityConfig.getHierarchyFilterTypes(entity.getType()), (Iterable<? extends SubFilter>)ImmutableList.of((Object)ArchiveSubFilter.NON_ARCHIVED), null, 0, 0, authorizationContext).getNumberOfResults();
        EntityDetails entityDetails = new EntityDetails(entity, myMembership, this.getOptionsItems(authorizationContext, visibleChildrenCount, item), this.getProfileCount(visibleChildrenCount), visibleHierarchyChildrenCount);
        this.copyDBToDetails(authorizationContext, item, entityDetails);
        entityDetails.setMay((ImmutableSet<? extends Action>)permissions);
        entityDetails.setSubscriptionStatus(subscriptionStatus);
        entityDetails.setApp(this._entityService.getAppForEntityType(entity.getType()));
        return entityDetails;
    }

    @ParametersAreNonnullByDefault
    private int getProfileCount(ImmutableMap<FilterType, ImmutableMultiset<FilterTypeCountType>> childrenCount) {
        return ((ImmutableMultiset)childrenCount.getOrDefault((Object)StaticFilterType.PROFILES, (Object)ImmutableMultiset.of())).count((Object)FilterTypeCountType.STANDARD);
    }

    @Nonnull
    private SubscriptionStatus getSubscriptionStatus(@Nonnull DBEntity entity, @Nonnull AuthorizationCheckContextWithUserId authorizationContext) {
        return (SubscriptionStatus)this._likeService.getExplicitSubscriptionStatus((Iterable<? extends ItemId>)ImmutableSet.of((Object)entity.getId()), authorizationContext).get((Object)entity.getId());
    }

    private void copyDBToDetails(@Nonnull SearchAuthorizationCheckContext authorizationContext, @Nonnull EntityItem entityItem, @Nonnull EntityDetails m) {
        DBEntity db = entityItem.getEntity();
        this._entityService.copyDBToInfo(db, m);
        m.setLinkedEntities(this._entityService.getInfosByIdsOrdered(db.getLinkedEntityIds(), authorizationContext));
        Set<EntityId> entityIDs = db.getLinkedEntityIds();
        ImmutableMap<EntityId, EntityInfo> parentMap = this._entityService.getInfoMapByIds(entityIDs, authorizationContext);
        EntityType childType = db.getType();
        for (DBEntityLink link : db.getLinkedEntities()) {
            EntityInfo parentInfo = (EntityInfo)parentMap.get(link.getLinkedEntityId());
            if (parentInfo == null) continue;
            EntityType parentType = (EntityType)parentInfo.getType();
            if (link.isInheritsAdmins() && this._entityConfig.inheritsAdminEnabled(parentType, childType)) {
                m.setShowInheritedAdmins(true);
            }
            if (!link.isInheritsMembers() || !this._entityConfig.inheritsMemberEnabled(parentType, childType)) continue;
            m.setShowInheritedMembers(true);
        }
        m.setComponents(this._entityService.getVisibleComponentsByEntity(entityItem, authorizationContext));
        EntityVersion currentVersion = this._entityVersionService.getCurrentEntityVersionForUser(db.getId(), authorizationContext);
        if (currentVersion == null) {
            throw new PermissionDeniedException("Failed to load entity version");
        }
        EntityVersionClientModel currentVersionClientModel = new EntityVersionClientModel(currentVersion);
        EntityVersionClientModel lastPublicVersion = currentVersion.getStatus().isPublished() ? currentVersionClientModel : this.getLastPublicVersionClientModel(m.getId(), authorizationContext);
        m.setVersion(currentVersionClientModel);
        m.setLastPublicVersion(lastPublicVersion);
        PersonId assignee = db.getAssignee();
        if (assignee != null) {
            m.setAssignee(this._profileTeaserService.getPersonTeaserById(assignee, authorizationContext));
        }
    }

    @CheckForNull
    private EntityVersionClientModel getLastPublicVersionClientModel(@Nonnull EntityId entityId, @Nonnull AuthorizationCheckContext auth) {
        EntityVersion lastPublicVersion = (EntityVersion)this._entityVersionService.getPublicVersions((ImmutableSet<EntityId>)ImmutableSet.of((Object)entityId), auth).get((Object)entityId);
        return lastPublicVersion == null ? null : new EntityVersionClientModel(lastPublicVersion);
    }

    @Nonnull
    private ImmutableList<OptionsItem> getOptionsItems(@Nonnull SearchAuthorizationCheckContext authorizationContext, @Nonnull ImmutableMap<FilterType, ImmutableMultiset<FilterTypeCountType>> visibleChildrenCount, @Nonnull EntityItem entity) {
        ImmutableList.Builder result = ImmutableList.builder();
        ImmutableSet<Action> mayCreateSet = authorizationContext.may(entity, (ImmutableSet<? extends Action>)ImmutableSet.of((Object)StaticAction.VIDEOLINK_CREATE, (Object)StaticAction.ALBUM_CREATE, (Object)StaticAction.DOCUMENT_CREATE, (Object)StaticAction.SURVEY_CREATE));
        result.add((Object)this.createAlbumOptionsItem(mayCreateSet, entity.getId()));
        result.add((Object)this.createVideoLinkOptionsItem(mayCreateSet, entity.getId()));
        result.add((Object)this.createSurveyOptionsItem(mayCreateSet, entity.getId()));
        result.add((Object)this.createDocumentOptionsItem(mayCreateSet, visibleChildrenCount));
        ImmutableSet<EntityType> entityTypes = this._entityConfig.getOrderedActivatedEntityTypes();
        ImmutableSet<EntityType> createAllowed = this.calculateCreateAndAssignAllowed(authorizationContext, entity.getId(), entityTypes);
        for (EntityType entityType : entityTypes) {
            result.add((Object)this.createEntityOptionsItem(visibleChildrenCount, entityType, createAllowed.contains((Object)entityType)));
        }
        return result.build();
    }

    @Nonnull
    private ImmutableMap<FilterType, ImmutableMultiset<FilterTypeCountType>> getVisibleChildrenCount(@Nonnull SearchAuthorizationCheckContext authorizationContext, @Nonnull EntityId entityId) {
        return this._entityChildrenService.getVisibleChildrenCounts(authorizationContext, (Iterable<EntityId>)ImmutableSet.of((Object)entityId));
    }

    @Nonnull
    private ImmutableSet<EntityType> calculateCreateAndAssignAllowed(@Nonnull AuthorizationCheckContextWithUserId authorizationContext, @Nonnull EntityId entityId, @Nonnull ImmutableSet<EntityType> entityTypes) {
        ImmutableMap createActions = Maps.uniqueIndex(entityTypes, Actions::entityCreate);
        ImmutableSet<Action> createAllowedAction = authorizationContext.may((ImmutableSet<? extends Action>)createActions.keySet());
        ImmutableSet createAllowedEntityTypes = ImmutableSet.copyOf(Maps.filterKeys((Map)createActions, (Predicate)Predicates.in(createAllowedAction)).values());
        return this._entityService.filterAllowedChildEntityTypes((Set<EntityType>)createAllowedEntityTypes, (Set<EntityId>)ImmutableSet.of((Object)entityId), authorizationContext).get((Object)entityId);
    }

    @Nonnull
    private OptionsItem createAlbumOptionsItem(@Nonnull ImmutableSet<Action> mayCreateSet, @Nonnull EntityId entityId) {
        int count = this._albumService.imageCountByParentId(entityId);
        boolean mayCreate = mayCreateSet.contains((Object)StaticAction.ALBUM_CREATE);
        return new OptionsItem(StaticComponentType.ALBUMS, mayCreate, this.getFilterTypeCount(count));
    }

    @Nonnull
    private OptionsItem createVideoLinkOptionsItem(@Nonnull ImmutableSet<Action> mayCreateSet, @Nonnull EntityId entityId) {
        int count = this._videolinkService.getVideoLinkCount(entityId);
        boolean mayCreate = mayCreateSet.contains((Object)StaticAction.VIDEOLINK_CREATE);
        return new OptionsItem(StaticComponentType.VIDEOLINK, mayCreate, this.getFilterTypeCount(count));
    }

    @Nonnull
    private OptionsItem createDocumentOptionsItem(@Nonnull ImmutableSet<Action> mayCreateSet, @Nonnull ImmutableMap<FilterType, ImmutableMultiset<FilterTypeCountType>> counts) {
        boolean mayCreate = mayCreateSet.contains((Object)StaticAction.DOCUMENT_CREATE);
        return new OptionsItem(StaticComponentType.DOCUMENT, mayCreate, (ImmutableMultiset<FilterTypeCountType>)((ImmutableMultiset)counts.getOrDefault((Object)StaticFilterType.DOCUMENTS, (Object)ImmutableMultiset.of())));
    }

    @Nonnull
    private OptionsItem createEntityOptionsItem(@Nonnull ImmutableMap<FilterType, ImmutableMultiset<FilterTypeCountType>> counts, @Nonnull EntityType entityType, boolean creatingAllowed) {
        return new OptionsItem(ComponentTypes.childEntities(entityType), creatingAllowed, (ImmutableMultiset<FilterTypeCountType>)((ImmutableMultiset)counts.getOrDefault((Object)FilterTypes.getByEntityType(entityType), (Object)ImmutableMultiset.of())));
    }

    @Nonnull
    private OptionsItem createSurveyOptionsItem(@Nonnull ImmutableSet<Action> mayCreateSet, @Nonnull EntityId id) {
        return new OptionsItem(StaticComponentType.SURVEY, mayCreateSet.contains((Object)StaticAction.SURVEY_CREATE), this.getFilterTypeCount(this._surveyService.getSurveyIdsByParentId(id).size()));
    }

    @Nonnull
    private ImmutableMultiset<FilterTypeCountType> getFilterTypeCount(int count) {
        return ImmutableMultiset.builder().setCount((Object)FilterTypeCountType.STANDARD, count).build();
    }
}

