/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.google.common.collect.Iterables;
import de.justsoftware.onx.common.deletion.CascadeDeleteService;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.container.business.EntityDeletionHandler;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.TenantId;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class EntityDeletionHandlerImpl
implements EntityDeletionHandler {
    @Autowired
    private EntityService _entityService;
    @Autowired
    private CascadeDeleteService _cascadeDeleteService;

    @Override
    public void handleCascadeDelete(@Nonnull Set<? extends ItemId> parentIds, @Nonnull DeletionContext deletionContext) {
        Iterables.filter(parentIds, TenantId.class).forEach(tenantId -> {
            Set<EntityId> entitiesToDelete = this._entityService.getAllForTenant((TenantId)tenantId);
            this._cascadeDeleteService.cascadeDelete(entitiesToDelete, deletionContext);
            deletionContext.addDeletedItems(entitiesToDelete);
            this._entityService.deleteEntitiesAndDependants(entitiesToDelete, deletionContext);
        });
    }
}

