/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.container.business.EntityAnchorPublisher;
import de.justsoftware.onx.container.business.events.EntityCreatedEvent;
import de.justsoftware.onx.container.business.events.EntityDescriptionUpdatedEvent;
import de.justsoftware.onx.container.business.events.EntityVersionPublishedEvent;
import de.justsoftware.onx.container.integration.persistence.EntityDAO;
import de.justsoftware.onx.container.shared.model.EntityAnchorComponent;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.events.RawEditorVersionCreatedEvent;
import de.justsoftware.onx.multiwiki.business.events.MultiWikiVersionCreatedEvent;
import de.justsoftware.onx.server.business.JucoServerVersionUpdateProcessor;
import de.justsoftware.onx.server.business.UpdateBehaviour;
import de.justsoftware.onx.server.model.JucoVersionUpdateProcess;
import de.justsoftware.onx.wikieditor.business.events.NewWikiVersionEvent;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
@Lazy(value=false)
public class EntityAnchorPublisherImpl
implements EntityAnchorPublisher,
ServerEventHandler,
JucoServerVersionUpdateProcessor {
    static final String TOPIC = "just.entity.anchor";
    private final Producer<String, String> _producer;
    private final EntityDAO _entityDAO;

    @Autowired
    public EntityAnchorPublisherImpl(@Nullable @Qualifier(value="KAFKA_STRING_PRODUCER") Producer<String, String> producer, EntityDAO entityDAO) {
        this._producer = producer;
        this._entityDAO = entityDAO;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityDescriptionUpdated(EntityDescriptionUpdatedEvent e) {
        this.produce(e.getEntity().getId(), EntityAnchorComponent.DESCRIPTION);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityCreated(EntityCreatedEvent e) {
        this.produce(e.getEntityId(), EntityAnchorComponent.values());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onRawEditorVersionCreated(RawEditorVersionCreatedEvent e) {
        this.produce((EntityId)e.getParentId(), (EntityAnchorComponent)((Object)EntityAnchorComponent.fromComponentType(e.getEditorType()).get()));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onNewWikiVersion(NewWikiVersionEvent e) {
        this.produce(e.getParentEntityId(), EntityAnchorComponent.WIKI_EDITOR);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onMultiWikiVersionCreated(MultiWikiVersionCreatedEvent e) {
        this.produce(e.getEntityId(), EntityAnchorComponent.MULTI_WIKI);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityVersionPublished(EntityVersionPublishedEvent e) {
        this.produce(e.getVersion().getEntityId(), EntityAnchorComponent.MULTI_WIKI);
    }

    @VisibleForTesting
    void produce(EntityId entityId, EntityAnchorComponent ... components) {
        if (this._producer != null) {
            for (EntityAnchorComponent component : components) {
                String key = entityId.getId() + " " + component.name();
                this._producer.send(new ProducerRecord(TOPIC, (Object)key, (Object)"N/A"));
            }
        }
    }

    @Override
    public JucoVersionUpdateProcess getProcessType() {
        return JucoVersionUpdateProcess.PUBLISH_ENTITY_ANCHORS;
    }

    @Override
    public UpdateBehaviour getUpdateBehaviour() {
        return UpdateBehaviour.onceOnMasterForVersion(this, "9.5.0");
    }

    @Override
    public boolean preconditionsMet() {
        return this._producer != null;
    }

    @Override
    public void publishAllEntities() {
        this._entityDAO.forAllEntityIds(entityId -> this.produce((EntityId)entityId, EntityAnchorComponent.values()));
    }

    @Override
    public void process() {
        this.publishAllEntities();
    }
}

