/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.business.EntityAnchorService;
import de.justsoftware.onx.container.shared.model.EntityAnchorComponent;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.kafka.AbstractKafkaConsumer;
import de.justsoftware.onx.kafka.KafkaConfigurationProvider;
import de.justsoftware.onx.kafka.KafkaConsumerContext;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
@Lazy(value=false)
public class EntityAnchorConsumer
extends AbstractKafkaConsumer<String, String> {
    static final String TOPIC = "just.entity.anchor";
    private static final Logger LOG = LoggerFactory.getLogger(EntityAnchorConsumer.class);
    private final EntityAnchorService _entityAnchorService;

    @Autowired
    public EntityAnchorConsumer(KafkaConfigurationProvider configProvider, TransactionHelper transactionHelper, EntityAnchorService entityAnchorService) {
        this(configProvider.stringConsumer("just.toro.EntityAnchorConsumer"), transactionHelper, entityAnchorService);
    }

    @VisibleForTesting
    EntityAnchorConsumer(@Nullable Consumer<String, String> consumer, TransactionHelper transactionHelper, EntityAnchorService entityAnchorService) {
        super(consumer, transactionHelper, TOPIC);
        this._entityAnchorService = entityAnchorService;
    }

    @Override
    protected Logger getLog() {
        return LOG;
    }

    @Override
    protected void process(ConsumerRecords<String, String> records, KafkaConsumerContext context) {
        ImmutableSetMultimap.Builder entitiesPerComponent = ImmutableSetMultimap.builder();
        for (ConsumerRecord record : records) {
            String s = ((String)record.key()).trim();
            int i = s.indexOf(32);
            EntityId entityId = EntityId.parse(s.substring(0, i));
            EntityAnchorComponent componentType = EntityAnchorComponent.safeValueOf(s.substring(i + 1));
            if (entityId == null || componentType == null) continue;
            entitiesPerComponent.put((Object)componentType, (Object)entityId);
        }
        this._entityAnchorService.indexComponents((SetMultimap<EntityAnchorComponent, EntityId>)entitiesPerComponent.build());
    }
}

