/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.ServerEvent;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.business.events.util.CollectingServerEventCollector;
import de.justsoftware.onx.common.business.events.util.ImmediatelyFiringServerEventCollector;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.business.EntityAdministrationWorkflowService;
import de.justsoftware.onx.container.business.EntityMemberReadWriteDataService;
import de.justsoftware.onx.container.business.EntityMemberService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.shared.model.AdminRoleForEntitiesException;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import de.justsoftware.onx.container.shared.model.EntityMemberWithEntityType;
import de.justsoftware.onx.container.shared.model.EntityMemberWithPerson;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.MakeCoAdminStatusKey;
import de.justsoftware.onx.container.shared.model.MemberChangeOptions;
import de.justsoftware.onx.container.shared.model.util.EntityMemberUtil;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Service
@ParametersAreNonnullByDefault
public class EntityAdministrationWorkflowServiceImpl
implements ServerEventHandler,
EntityAdministrationWorkflowService {
    private final EntityService _entityService;
    private final Settings _settings;
    private final TransactionHelper _transactionHelper;
    private final ProfileTeaserService _profileTeaserService;
    private final JCEventBus _eventBus;
    private final EntityConfigService _entityConfig;
    private final EntityMemberService _entityMemberService;
    private final EntityMemberReadWriteDataService _entityMemberReadWriteDataService;

    @Autowired
    public EntityAdministrationWorkflowServiceImpl(EntityService entityService, Settings settings, TransactionHelper transactionHelper, ProfileTeaserService profileTeaserService, JCEventBus eventBus, EntityConfigService entityConfig, EntityMemberService entityMemberService, EntityMemberReadWriteDataService entityMemberReadWriteDataService) {
        this._entityService = entityService;
        this._settings = settings;
        this._transactionHelper = transactionHelper;
        this._profileTeaserService = profileTeaserService;
        this._eventBus = eventBus;
        this._entityConfig = entityConfig;
        this._entityMemberService = entityMemberService;
        this._entityMemberReadWriteDataService = entityMemberReadWriteDataService;
    }

    @Override
    public ImmutableList<EntityMemberWithPerson> getJoinRequestsForUser(AuthorizationCheckContextWithUserId authorizationContext) {
        PersonId personId = authorizationContext.getUserId();
        return this._entityMemberReadWriteDataService.getJoinRequests(personId, (Iterable<EntityType>)this._entityConfig.getOrderedEntityTypes());
    }

    @Override
    public ListAndCount<PersonTeaserModel> getActiveAdminsByEntityId(EntityId entityId, int offset, int limit, AuthorizationCheckContextWithLocale authCtx) {
        PersonTeaserModel adminTeaser;
        ArrayList<PersonTeaserModel> result = new ArrayList<PersonTeaserModel>();
        EntityMember admin = this.getAdmin(entityId);
        if (admin != null && (adminTeaser = this._profileTeaserService.getPersonTeaserById(admin.getPersonId(), authCtx)) != null && adminTeaser.isActive()) {
            result.add(adminTeaser);
        }
        ImmutableSet<PersonId> coAdminIds = EntityMemberUtil.transformToPersonIdSet(FluentIterable.from(this.getDirectCoAdmins(entityId)).filter(EntityMemberWithPerson.IS_ACTIVE));
        ImmutableMap<PersonId, PersonTeaserModel> coAdminsMap = this._profileTeaserService.getPersonTeasersByIds((Set<PersonId>)coAdminIds, authCtx);
        ArrayList coAdmins = new ArrayList(coAdminsMap.values());
        Collections.sort(coAdmins, new Comparator<PersonTeaserModel>(){

            @Override
            public int compare(PersonTeaserModel o1, PersonTeaserModel o2) {
                String n1 = o1.getShortName();
                String n2 = o2.getShortName();
                return n1.compareTo(n2);
            }
        });
        result.addAll(coAdmins);
        return CollectionUtil.nullSafeListAndCount(result, offset, limit);
    }

    @Override
    public List<EntityInfo> getAdminEntities(PersonId userId, AuthorizationCheckContextWithLocale authorizationContext) {
        ImmutableSet<EntityId> entityIds = this.getAdminEntityIds(userId);
        return this._entityService.getInfosByIdsOrdered((Iterable<EntityId>)entityIds, authorizationContext);
    }

    @Override
    public Iterable<EntityMemberWithPerson> getDirectCoAdmins(EntityId entityId) {
        ImmutableList<EntityMemberWithPerson> members = this._entityMemberReadWriteDataService.getEntityMemberByEntityId(entityId);
        return EntityMemberUtil.filterByRoles(members, new EntityMemberRole[]{EntityMemberRole.CO_ADMIN});
    }

    @Override
    public ImmutableSetMultimap<EntityId, PersonId> getDirectAdminsAndCoAdmins(Set<EntityId> entityIds) {
        ImmutableListMultimap<EntityId, EntityMemberWithPerson> byEntityIds = this._entityMemberReadWriteDataService.getByEntityIds(entityIds);
        Multimap filtered = Multimaps.filterValues(byEntityIds, EntityMemberUtil.composeRoleFilterPredicate(EntityMemberRoles.ADMIN_OR_COADMIN));
        return ImmutableSetMultimap.copyOf((Multimap)Multimaps.transformValues((Multimap)filtered, EntityMember.GET_PERSON_ID));
    }

    @Override
    public EntityMember getAdmin(EntityId id) {
        ImmutableList<EntityMemberWithPerson> members = this._entityMemberReadWriteDataService.getEntityMemberByEntityId(id);
        return (EntityMember)Iterables.getFirst(EntityMemberUtil.filterByRoles(members, new EntityMemberRole[]{EntityMemberRole.ADMIN}), null);
    }

    @Override
    public void deleteCoAdmins(EntityId entityId, ImmutableSet<PersonId> persons) {
        this._entityMemberService.updateMemberRoles(entityId, (Set<PersonId>)persons, (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.CO_ADMIN), (Set<EntityMemberRole>)EntityMemberRoles.EMPTY, (ServerEventCollector)new ImmediatelyFiringServerEventCollector(this._eventBus), MemberChangeOptions.buildDefault(), null);
    }

    @Override
    public void deleteCoAdmins(Set<EntityId> entityIds, PersonId personId) {
        this.deleteCoAdmins(entityIds, personId, new ImmediatelyFiringServerEventCollector(this._eventBus), MemberChangeOptions.buildDefault());
    }

    @Override
    public void deleteCoAdmins(Set<EntityId> entityIds, PersonId personId, ServerEventCollector eventCollector, MemberChangeOptions options) {
        this._entityMemberService.updateMemberRoles(entityIds, personId, (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.CO_ADMIN), (Set<EntityMemberRole>)EntityMemberRoles.EMPTY, eventCollector, options, null);
    }

    @Override
    public void grantMemberToAdmin(EntityId id, PersonId personId, MemberChangeOptions options) {
        CollectingServerEventCollector collector = new CollectingServerEventCollector();
        this.grantMemberToAdmin(id, personId, options, collector);
        collector.fireEvents(this._eventBus);
    }

    @Override
    public void grantMemberToAdmin(final EntityId entityId, final PersonId personId, MemberChangeOptions options, ServerEventCollector eventCollector) {
        EntityMemberWithEntityType member = this._entityMemberService.getMemberByPersonIdAndEntityId(personId, entityId);
        if (member == null || !EntityMemberUtil.isAdmin(member)) {
            ImmutableSet<EntityMemberRole> currentRoles = member != null ? member.getRoles() : EntityMemberRoles.EMPTY;
            ImmutableSet<EntityMemberRole> targetRoles = EntityMemberRoles.replaceRoles(currentRoles, EntityMemberRoles.ALL_MEMBER_STATUS, (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.ADMIN));
            Sets.SetView rolesToRemove = Sets.difference(currentRoles, targetRoles);
            Sets.SetView rolesToAdd = Sets.difference(targetRoles, currentRoles);
            this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult((Set)rolesToRemove, (Set)rolesToAdd, eventCollector, options){
                final /* synthetic */ Set val$rolesToRemove;
                final /* synthetic */ Set val$rolesToAdd;
                final /* synthetic */ ServerEventCollector val$eventCollector;
                final /* synthetic */ MemberChangeOptions val$options;
                {
                    this.val$rolesToRemove = set;
                    this.val$rolesToAdd = set2;
                    this.val$eventCollector = serverEventCollector;
                    this.val$options = memberChangeOptions;
                }

                protected void doInTransactionWithoutResult(TransactionStatus transactionstatus) {
                    EntityMember oldAdmin = EntityAdministrationWorkflowServiceImpl.this.getAdmin(entityId);
                    EntityAdministrationWorkflowServiceImpl.this._entityMemberService.updateMemberRoles(entityId, (Set<PersonId>)ImmutableSet.of((Object)personId), (Set<EntityMemberRole>)this.val$rolesToRemove, (Set<EntityMemberRole>)this.val$rolesToAdd, this.val$eventCollector, this.val$options, null);
                    if (oldAdmin != null) {
                        EntityAdministrationWorkflowServiceImpl.this._entityMemberService.updateMemberRoles(entityId, (Set<PersonId>)ImmutableSet.of((Object)oldAdmin.getPersonId()), (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.ADMIN), (Set<EntityMemberRole>)(this.val$options.makeOldAdminCoAdmin() ? ImmutableSet.of((Object)EntityMemberRole.CO_ADMIN) : EntityMemberRoles.EMPTY), this.val$eventCollector, this.val$options, null);
                    }
                }
            });
        }
    }

    @Override
    public void transferAdminRightsToDefaultAdmin(EntityId entityId, PersonId personId, MemberChangeOptions options) throws AdminRoleForEntitiesException {
        EntityMemberWithEntityType member = this._entityMemberService.getMemberByPersonIdAndEntityId(personId, entityId);
        if (member != null) {
            this.transferAdminRightsToDefaultAdmin(member, options);
        }
    }

    @Override
    public void transferAdminRightsToDefaultAdmin(EntityMember member, MemberChangeOptions options) throws AdminRoleForEntitiesException {
        if (EntityMemberUtil.isAdmin(member)) {
            CollectingServerEventCollector serverEvents = new CollectingServerEventCollector();
            this.transferAdminRightsToDefaultAdmin((ImmutableSet<EntityId>)ImmutableSet.of((Object)member.getEntityId()), options, serverEvents);
            serverEvents.fireEvents(this._eventBus);
        }
    }

    @Override
    public void makeCoAdminWithMeAsAdminFallback(EntityId entityId, Set<PersonId> newCoAdmins, AuthorizationCheckContextWithUserId authCtx) {
        Sets.SetView depromoteAdmins;
        authCtx.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_MAKE_COADMIN);
        ImmutableSet admins = this._entityMemberService.getPersonIdsByEntityIdAndMemberRoles((Set<EntityId>)ImmutableSet.of((Object)entityId), (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.ADMIN)).keySet();
        HashSet<PersonId> personsToUpdate = new HashSet<PersonId>(newCoAdmins);
        boolean currentUserIsAdmin = admins.contains((Object)authCtx.getUserId());
        if (currentUserIsAdmin) {
            personsToUpdate.remove(authCtx.getUserId());
        }
        if (!(depromoteAdmins = Sets.intersection((Set)admins, personsToUpdate)).isEmpty()) {
            authCtx.check((ItemId)entityId, (Action)StaticEntityAction.ENTITY_MAKE_ADMIN);
        }
        CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        this._entityMemberService.updateMemberRoles(entityId, personsToUpdate, (Set<EntityMemberRole>)Sets.union(EntityMemberRoles.ALL_MEMBER_STATUS, EntityMemberRoles.ADMIN_OR_COADMIN), (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.CO_ADMIN), (ServerEventCollector)eventCollector, MemberChangeOptions.buildDefaultWith(authCtx), null);
        if (!depromoteAdmins.isEmpty() && !currentUserIsAdmin) {
            this.grantMemberToAdmin(entityId, authCtx.getUserId(), MemberChangeOptions.buildDefaultWith(authCtx));
        }
        eventCollector.fireEvents(this._eventBus);
    }

    @Override
    public ImmutableMap<MakeCoAdminStatusKey, Integer> grantMembersToCoAdmin(EntityId entityId, Set<PersonId> personIds, MemberChangeOptions options) {
        ImmutableSet currentAdmins = this._entityMemberService.getPersonIdsByEntityIdAndMemberRoles((Set<EntityId>)ImmutableSet.of((Object)entityId), (Set<EntityMemberRole>)EntityMemberRoles.ADMIN_OR_COADMIN).keySet();
        Sets.SetView nonAdmins = Sets.difference(personIds, (Set)currentAdmins);
        CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        this._entityMemberService.updateMemberRoles(entityId, (Set<PersonId>)nonAdmins, (Set<EntityMemberRole>)EntityMemberRoles.ALL_MEMBER_STATUS, (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.CO_ADMIN), (ServerEventCollector)eventCollector, options, null);
        eventCollector.fireEvents(this._eventBus);
        return ImmutableMap.of((Object)((Object)MakeCoAdminStatusKey.STATUS_CHANGED), (Object)nonAdmins.size(), (Object)((Object)MakeCoAdminStatusKey.WAS_ADMIN_OR_COADMIN), (Object)Sets.intersection((Set)currentAdmins, personIds).size());
    }

    @Override
    public PersonTeaserModel getPersonForAdminRightsTransfer(AuthorizationCheckContextWithLocale authCtx) {
        PersonId personId = this._settings.getPersonIdForAdminTransfer();
        if (personId != null) {
            return this._profileTeaserService.getPersonTeaserById(personId, authCtx);
        }
        return null;
    }

    @Nonnull
    private ImmutableSet<EntityId> getAdminEntityIds(PersonId memberId) {
        return EntityMemberUtil.transformToEntityIdSet(EntityMemberUtil.filterByRoles(this._entityMemberReadWriteDataService.getEntityMembersByPersonId(memberId), new EntityMemberRole[]{EntityMemberRole.ADMIN}));
    }

    @Override
    public void transferAdminRightsToDefaultAdmin(PersonId personId, MemberChangeOptions options) throws AdminRoleForEntitiesException {
        CollectingServerEventCollector serverEvents = new CollectingServerEventCollector();
        this.transferAdminRightsToDefaultAdmin(EntityMemberUtil.transformToEntityIdSet(EntityMemberUtil.filterByRoles(this._entityMemberService.getEntityMembershipsByPersonId(personId), new EntityMemberRole[]{EntityMemberRole.ADMIN})), options, serverEvents);
        serverEvents.fireEvents(this._eventBus);
    }

    @Override
    public void transferAdminRightsToDefaultAdmin(final ImmutableSet<EntityId> entityIds, final MemberChangeOptions options, ServerEventCollector serverEvents) throws AdminRoleForEntitiesException {
        if (!entityIds.isEmpty()) {
            final PersonId personForAdminRights = this._settings.getPersonIdForAdminTransfer();
            if (personForAdminRights == null) {
                throw new AdminRoleForEntitiesException(entityIds);
            }
            final CollectingServerEventCollector internalEventCollector = new CollectingServerEventCollector();
            this._transactionHelper.doInTransaction(new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus ts) {
                    ImmutableSetMultimap<PersonId, EntityId> currentAdmins = EntityAdministrationWorkflowServiceImpl.this._entityMemberService.getPersonIdsByEntityIdAndMemberRoles((Set<EntityId>)entityIds, (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.ADMIN));
                    for (Map.Entry entry : currentAdmins.asMap().entrySet()) {
                        EntityAdministrationWorkflowServiceImpl.this._entityMemberService.updateMemberRoles((Set<EntityId>)ImmutableSet.copyOf((Collection)((Collection)entry.getValue())), (PersonId)entry.getKey(), (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.ADMIN), (Set<EntityMemberRole>)EntityMemberRoles.EMPTY, (ServerEventCollector)internalEventCollector, options, null);
                    }
                    EntityAdministrationWorkflowServiceImpl.this._entityMemberService.updateMemberRoles((Set<EntityId>)entityIds, personForAdminRights, EntityMemberRoles.ALL_ADMINISTRATION_STATUS, (Set<EntityMemberRole>)ImmutableSet.of((Object)EntityMemberRole.ADMIN), (ServerEventCollector)internalEventCollector, options, null);
                }
            });
            for (ServerEvent event : internalEventCollector.getEvents()) {
                serverEvents.add(event);
            }
        }
    }
}

