/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.justsoftware.onx.container.business.EntityChildrenService;
import de.justsoftware.onx.container.business.EntityPrivacyMigrationService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.tenant.business.TenantService;
import de.justsoftware.onx.tenant.integration.persistence.TenantDAO;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class CloudPrivacyMigrationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudPrivacyMigrationService.class);
    private final TenantService _tenantService;
    private final EntityPrivacyMigrationService _entityPrivacyMigrationService;
    private final EntityChildrenService _entityChildrenService;
    private final TenantDAO _tenantDao;

    public CloudPrivacyMigrationService(TenantService tenantService, EntityPrivacyMigrationService entityPrivacyMigrationService, EntityChildrenService entityChildrenService, TenantDAO tenantDao) {
        this._tenantService = tenantService;
        this._entityPrivacyMigrationService = entityPrivacyMigrationService;
        this._entityChildrenService = entityChildrenService;
        this._tenantDao = tenantDao;
    }

    public int migratePrivacyForMultiTenant() {
        LOGGER.info("Migration of privacy settings of entity tenants triggered.");
        return this._tenantDao.forAllTenants(this::migrateTenant);
    }

    private void migrateTenant(TenantId tenantId) {
        this._tenantService.getEntityIdForTenantId(tenantId).ifPresent(rootEntityId -> {
            LOGGER.info("update visibilities for tenant: {} entity: {} ", (Object)tenantId, rootEntityId);
            ImmutableSet childEntitiesWithInheretedMembers = this._entityChildrenService.getMemberInheritedEntityChildrenByParentIds((ImmutableSet<EntityId>)ImmutableSet.of((Object)rootEntityId)).get(rootEntityId);
            Sets.SetView entitiesToUpdate = Sets.union((Set)childEntitiesWithInheretedMembers, Set.of(rootEntityId));
            LOGGER.info("will add LOGGED_IN for entity read to: {}", (Object)entitiesToUpdate);
            this._entityPrivacyMigrationService.allowEntityReadForTenantReaders((Set<EntityId>)entitiesToUpdate, "LOGGED_IN");
            LOGGER.info("will add LOGGED_IN for entity edit to: {}", (Object)entitiesToUpdate);
            this._entityPrivacyMigrationService.allowEntityEditForRoleIfMemberMayEdit((Set<EntityId>)entitiesToUpdate, "LOGGED_IN");
        });
    }
}

