/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.events;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.business.events.EntityParentsChangedEvent;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityParentsChangedByUserEvent
extends EntityParentsChangedEvent {
    private final PersonId _authorId;
    private final boolean _sendNotifications;
    private final DBEntity _entity;
    private final ImmutableSet<EntityId> _newParents;

    public EntityParentsChangedByUserEvent(PersonId authorId, DBEntity entity, boolean parentsChanged, boolean adminInheritanceChanged, boolean memberInheritanceChanged, ImmutableSet<EntityId> newParents, boolean sendNotifications) {
        super(entity.getId(), parentsChanged, adminInheritanceChanged, memberInheritanceChanged);
        this._authorId = authorId;
        this._entity = entity;
        this._newParents = newParents;
        this._sendNotifications = sendNotifications;
    }

    @Nonnull
    public DBEntity getEntity() {
        return this._entity;
    }

    @Nonnull
    public PersonId getAuthorId() {
        return this._authorId;
    }

    public boolean isSendNotifications() {
        return this._sendNotifications;
    }

    @Nonnull
    public ImmutableSet<EntityId> getNewParents() {
        return this._newParents;
    }
}

