/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.events;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.business.events.ServerEvent;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.AbstractImmutableEqualsObject;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityMemberRolesChangedEvent
extends AbstractImmutableEqualsObject
implements ServerEvent {
    private final EntityId _entityId;
    private final PersonId _personId;
    private final ImmutableSet<EntityMemberRole> _newRoles;
    private final ImmutableSet<EntityMemberRole> _oldRoles;

    public EntityMemberRolesChangedEvent(PersonId personId, EntityId entityId, ImmutableSet<EntityMemberRole> newRoles, ImmutableSet<EntityMemberRole> oldRoles) {
        super(personId, entityId, newRoles, oldRoles);
        this._personId = personId;
        this._entityId = entityId;
        this._newRoles = newRoles;
        this._oldRoles = oldRoles;
    }

    @Nonnull
    public EntityId getEntityId() {
        return this._entityId;
    }

    @Nonnull
    public PersonId getPersonId() {
        return this._personId;
    }

    @Nonnull
    public ImmutableSet<EntityMemberRole> getNewRoles() {
        return this._newRoles;
    }

    @Nonnull
    public ImmutableSet<EntityMemberRole> getOldRoles() {
        return this._oldRoles;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("entityId", (Object)this._entityId).add("personId", (Object)this._personId).add("oldRoles", this._oldRoles).add("newRoles", this._newRoles).toString();
    }
}

