/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business.csvexport;

import com.freiheit.toro.account.shared.model.settings.Birthday;
import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.AuthorityUtil;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.authorization.business.ProfileReadRole;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.ServerLocalizedMessages;
import de.justsoftware.onx.common.business.configfile.ConfigFileService;
import de.justsoftware.onx.common.shared.i18n.DateFormatter;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.common.shared.model.TimeZone;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.DynamicActionCreator;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.business.EntityMemberService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.csvexport.EntityDataExportService;
import de.justsoftware.onx.container.integration.persistence.EntityDataExportDAO;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.EntityMemberRoles;
import de.justsoftware.onx.container.shared.model.EntityMemberWithPerson;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.server.model.export.EntityExportData;
import de.justsoftware.onx.migration.integration.persistence.PersonImportMappingDAO;
import de.justsoftware.onx.person.business.PersonRoleService;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.i18n.ProfileConstants;
import de.justsoftware.onx.person.shared.model.PersonRolesClientTranslation;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.profile.business.ProfileAttributeTranslationService;
import de.justsoftware.onx.profile.business.ProfileService;
import de.justsoftware.onx.profile.model.ProfileAttribute;
import de.justsoftware.onx.profile.model.ProfileAttributeBlock;
import de.justsoftware.onx.profile.model.ProfileAttributePeriod;
import de.justsoftware.onx.profile.model.ProfileSection;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class EntityDataExportServiceImpl
implements EntityDataExportService {
    private static final Joiner COMMA_JOINER = Joiner.on((char)',').skipNulls();
    private static final Joiner SEMIKOLON_JOINER = Joiner.on((char)';').skipNulls();
    private static final String FIELD_BIRTHDAY = "birthday";
    private static final String FIELD_LOCALE_TIME = "localeTime";
    private static final String FIELD_ROLE_TITLE_SINGULAR = "roleTitleSingular";
    private static final String FIELD_ROLE_TITLE_PLURAL = "roleTitlePlural";
    private static final Function<String, String> ESCAPE_WITH_CURLY_BRACKET = new NullPermeableFunction<String, String>(){

        @Override
        protected String applySafe(String input) {
            return "{" + input + "}";
        }
    };
    private static final Function<String, String> ESCAPE_WITH_SQUARE_BRACKET = new NullPermeableFunction<String, String>(){

        @Override
        protected String applySafe(String input) {
            return "[" + input + "]";
        }
    };
    private static final Predicate<String> NON_BLANK = input -> !StringUtil.isBlank(input);
    @Autowired
    private EntityDataExportDAO _entityDataExportDAO;
    @Autowired
    private EntityMemberService _entityMemberService;
    @Autowired
    private EntityService _entityService;
    @Autowired(required=false)
    private PersonImportMappingDAO _personImportMappingDAO;
    @Autowired
    private PersonService _personService;
    @Autowired
    private PersonRoleService _personRoleService;
    @Autowired
    private I18nService _i18nService;
    @Autowired
    private ProfileService _profileService;
    @Autowired
    private ProfileAttributeTranslationService _profileAttributeTranslationService;
    @Autowired
    private Settings _settings;
    @Autowired
    private ConfigFileService _configFileService;

    @Override
    public List<EntityExportData> getEntityExportData(Date startCreateDate, Date endCreateDate) {
        return this._entityDataExportDAO.getEntityExportData(startCreateDate, endCreateDate);
    }

    @Nonnull
    private ImmutableSet<ImmutableMap<String, String>> getMemberExportData(@Nullable DBEntity entity, ImmutableMultimap<PersonId, EntityMemberWithPerson> allMembers, ImmutableSet<PersonId> allPersonIds, AuthorizationCheckContextWithUserId authorizationContext) {
        String locale = authorizationContext.getLocale();
        ServerLocalizedMessages localizedMessages = this._i18nService.getLocalizedMessages(locale);
        ImmutableSet<PersonId> visiblePersonIds = this.getVisiblePersonIds(allPersonIds, authorizationContext);
        ImmutableMap<PersonId, DBPerson> allPersons = this._personService.getPersonsByIds((Set<PersonId>)allPersonIds);
        ImmutableMap<PersonId, String> externalPersonIds = this._personImportMappingDAO != null ? this._personImportMappingDAO.getExternalIds((Set<PersonId>)allPersonIds) : ImmutableMap.of();
        PersonRolesClientTranslation personRolesTranslation = this._personService.getRolesTranslation(locale);
        DateFormatter dateFormatter = this._i18nService.dateFormatter(locale);
        ImmutableSet.Builder result = ImmutableSet.builder();
        Map visiblePersons = Maps.filterKeys(allPersons, (Predicate)Predicates.in(visiblePersonIds));
        ImmutableMap<PersonId, ProfileItem> visibleProfileMap = this._personService.getProfileItemsForPersons(visiblePersons);
        ImmutableSet<PersonRole> allPersonRoles = this._configFileService.getConfigFile().getAllPersonRoles();
        ImmutableSet<PersonRole> hiddenRoles = this._configFileService.getConfigFile().getHiddenPersonRoles();
        ImmutableSetMultimap<Optional<ProfileId>, Action> allowedActions = this.getAllowedActions(authorizationContext, visibleProfileMap, allPersonRoles);
        ImmutableListMultimap<ProfileId, ProfileSection> reactProfileAttributes = this.getVisibleProfileSections(visiblePersonIds, authorizationContext);
        ImmutableMap<String, String> reactProfileTranslations = this._profileAttributeTranslationService.getProfileAttributeTranslations(authorizationContext.getLocale());
        ImmutableSetMultimap<PersonId, PersonRole> personRoles = this._personRoleService.getPersonRoles((Set<PersonId>)visiblePersonIds);
        for (PersonId personId : allPersonIds) {
            ImmutableMap.Builder rowBuilder = ImmutableMap.builder();
            DBPerson dbPerson = (DBPerson)allPersons.get(personId);
            if (visiblePersonIds.contains((Object)personId)) {
                this.addProfileData((Iterable<ProfileSection>)reactProfileAttributes.get((Object)personId.asProfileId()), (Map<String, String>)reactProfileTranslations, dateFormatter, (ImmutableMap.Builder<String, String>)rowBuilder);
                this.addPersonVisibleData(dbPerson, localizedMessages, dateFormatter, (ImmutableMap.Builder<String, String>)rowBuilder);
                this.addPersonRoles(personId, personRoles, personRolesTranslation, (ImmutableSet<Action>)allowedActions.get((Object)Optional.of((Object)personId.asProfileId())), hiddenRoles, (ImmutableMap.Builder<String, String>)rowBuilder);
            }
            this.addPersonData(personId, dbPerson, visiblePersonIds, (Map<PersonId, String>)externalPersonIds, localizedMessages, (ImmutableMap.Builder<String, String>)rowBuilder);
            this.addEntityData(entity, personId, allMembers, localizedMessages, dateFormatter, (ImmutableMap.Builder<String, String>)rowBuilder);
            result.add((Object)rowBuilder.build());
        }
        return result.build();
    }

    @Nonnull
    private ImmutableSetMultimap<Optional<ProfileId>, Action> getAllowedActions(AuthorizationCheckContext authorizationContext, ImmutableMap<PersonId, ProfileItem> profiles, ImmutableSet<PersonRole> allPersonRoles) {
        ImmutableSet actions = FluentIterable.from(allPersonRoles).transform(Role.TO_NAME).transform(DynamicActionCreator.PROFILE_MODIFY_ROLES.createFunction()).filter(Action.class).append((Object[])new Action[]{StaticAction.SEE_HIDDEN_ROLES}).toSet();
        return authorizationContext.may(profiles.values(), actions);
    }

    @Nonnull
    private ImmutableListMultimap<ProfileId, ProfileSection> getVisibleProfileSections(ImmutableSet<PersonId> visiblePersonIds, AuthorizationCheckContext authorizationContext) {
        return this._profileService.getVisibleSections((Set<ProfileId>)FluentIterable.from(visiblePersonIds).transform(PersonId.AS_PROFILE_ID).toSet(), authorizationContext);
    }

    @Override
    public ImmutableSet<ImmutableMap<String, String>> getPlatformMembersExportData(AuthorizationCheckContextWithUserId authorizationContext) {
        return this.getMemberExportData(null, (ImmutableMultimap<PersonId, EntityMemberWithPerson>)ImmutableMultimap.of(), (ImmutableSet<PersonId>)ImmutableSet.copyOf(this._personService.getAllPersonIds(false, 0, Integer.MAX_VALUE)), authorizationContext);
    }

    @Override
    public ImmutableSet<ImmutableMap<String, String>> getEntityMemberExportData(EntityId primaryEntityId, AuthorizationContext authorizationContext) {
        authorizationContext.check((ItemId)primaryEntityId, (Action)StaticEntityAction.ENTITY_EXPORT_MEMBERS);
        ImmutableListMultimap<PersonId, EntityMemberWithPerson> allMembers = this._entityMemberService.getEntityAndInheritedMembersByEntityId(primaryEntityId);
        return this.getMemberExportData(this._entityService.getByIdNotNull(primaryEntityId), (ImmutableMultimap<PersonId, EntityMemberWithPerson>)allMembers, (ImmutableSet<PersonId>)allMembers.keySet(), authorizationContext);
    }

    private void addPersonData(PersonId personId, @Nullable DBPerson dbPerson, ImmutableSet<PersonId> visiblePersonIds, Map<PersonId, String> externalPersonIds, ServerLocalizedMessages localizedMessages, ImmutableMap.Builder<String, String> result) {
        this.addOptionalColumnValue(result, EntityDataExportService.ExportColumnKeys.PERSON_ID, personId.toString());
        if (visiblePersonIds.contains((Object)personId)) {
            this.addOptionalColumnValue(result, EntityDataExportService.ExportColumnKeys.PERSON_EXTERNAL_ID, externalPersonIds.get(personId));
            if (dbPerson != null) {
                this.addOptionalColumnValue(result, EntityDataExportService.ExportColumnKeys.PERSON_EMAIL, dbPerson.getEmail());
            }
        } else {
            String secretItem = localizedMessages.basicConstants().secretItem();
            this.addOptionalColumnValue(result, EntityDataExportService.ExportColumnKeys.PERSON_EXTERNAL_ID, secretItem);
            this.addOptionalColumnValue(result, EntityDataExportService.ExportColumnKeys.PERSON_EMAIL, secretItem);
        }
        if (dbPerson != null) {
            this.addOptionalColumnValue(result, EntityDataExportService.ExportColumnKeys.PERSON_FULL_NAME, dbPerson.getFullName());
            this.addOptionalColumnValue(result, EntityDataExportService.ExportColumnKeys.PERSON_ADDITIONAL_TITLE, dbPerson.getAdditionalTitle());
            this.addOptionalColumnValue(result, EntityDataExportService.ExportColumnKeys.PERSON_FIRST_NAME, dbPerson.getFirstName());
            this.addOptionalColumnValue(result, EntityDataExportService.ExportColumnKeys.PERSON_LAST_NAME, dbPerson.getLastName());
            this.addOptionalColumnValue(result, EntityDataExportService.ExportColumnKeys.PERSON_TITLE, dbPerson.getTitle());
            this.addOptionalColumnValue(result, EntityDataExportService.ExportColumnKeys.PERSON_IS_ACTIVE, dbPerson.isActive() ? localizedMessages.csvExportConstants().profileActiveYes() : localizedMessages.csvExportConstants().profileActiveNo());
        }
    }

    private void addEntityData(@Nullable DBEntity entity, PersonId personId, ImmutableMultimap<PersonId, EntityMemberWithPerson> allMembers, ServerLocalizedMessages localizedMessages, DateFormatter dateFormatter, ImmutableMap.Builder<String, String> result) {
        this.addOptionalColumnValues(result, entity, dateFormatter);
        if (entity != null) {
            this.addMembershipData(result, (Iterable<EntityMemberWithPerson>)allMembers.get((Object)personId), localizedMessages.entityConstants(entity.getType()));
        }
    }

    private void addProfileData(Iterable<ProfileSection> sections, Map<String, String> translations, DateFormatter dateFormatter, ImmutableMap.Builder<String, String> result) {
        ImmutableSetMultimap.Builder resultCollector = ImmutableSetMultimap.builder();
        ImmutableSetMultimap.Builder sectionCollector = ImmutableSetMultimap.builder();
        for (ProfileSection section : sections) {
            for (ProfileAttributeBlock block : section.getAttributeBlocks()) {
                ImmutableSetMultimap<String, String> blockColumns = this.collectBlockValues(block, translations, dateFormatter);
                resultCollector.putAll(blockColumns);
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Iterable values : blockColumns.asMap().values()) {
                    String joined = SEMIKOLON_JOINER.join(values);
                    if (!NON_BLANK.apply((Object)joined)) continue;
                    builder.add((Object)joined);
                }
                String joinedBlockAttributes = SEMIKOLON_JOINER.join((Iterable)builder.build());
                if (!NON_BLANK.apply((Object)joinedBlockAttributes)) continue;
                sectionCollector.put((Object)section.getName(), (Object)joinedBlockAttributes);
            }
        }
        for (Map.Entry entry : sectionCollector.build().asMap().entrySet()) {
            String escapedColumn = (String)ESCAPE_WITH_SQUARE_BRACKET.apply((Object)FluentIterable.from((Iterable)((Iterable)entry.getValue())).transform(ESCAPE_WITH_CURLY_BRACKET).join(COMMA_JOINER));
            if (!NON_BLANK.apply((Object)escapedColumn)) continue;
            result.put((Object)((String)entry.getKey()), (Object)escapedColumn);
        }
        for (Map.Entry entry : resultCollector.build().asMap().entrySet()) {
            String joined = SEMIKOLON_JOINER.join((Iterable)entry.getValue());
            if (!NON_BLANK.apply((Object)joined)) continue;
            result.put((Object)((String)entry.getKey()), (Object)joined);
        }
    }

    @Nonnull
    private ImmutableSetMultimap<String, String> collectBlockValues(ProfileAttributeBlock block, Map<String, String> translations, DateFormatter dateFormatter) {
        ImmutableSetMultimap.Builder collector = ImmutableSetMultimap.builder();
        for (ProfileAttribute attribute : block.getAttributes()) {
            for (String value : attribute.getValues()) {
                this.collectBlockValues(attribute, value, translations, dateFormatter, (ImmutableSetMultimap.Builder<String, String>)collector);
            }
        }
        return collector.build();
    }

    private void collectBlockValues(ProfileAttribute attribute, String value, Map<String, String> translations, DateFormatter dateFormatter, ImmutableSetMultimap.Builder<String, String> collector) {
        switch (attribute.getType()) {
            case CHECKRADIO: 
            case SELECT: 
            case DESCRIPTION: {
                this.addOptionalColumnValue(collector, attribute.getName(), (String)MoreObjects.firstNonNull((Object)translations.get(value), (Object)value));
                break;
            }
            case MONTH_YEAR_PERIOD: {
                ProfileAttributePeriod period = ProfileAttributePeriod.fromMonthYearPeriodString(value);
                this.addOptionalColumnValue(collector, attribute.getName(), period, dateFormatter);
                break;
            }
            case TEXT: 
            case TEXT_PHONE: 
            case TEXTAREA: {
                this.addOptionalColumnValue(collector, attribute.getName(), value);
                break;
            }
        }
    }

    private void addOptionalColumnValue(ImmutableSetMultimap.Builder<String, String> collector, String key, @Nullable ProfileAttributePeriod period, DateFormatter dateFormatter) {
        if (period != null) {
            this.addOptionalColumnValue(collector, key, this.formatAsDayMonthYear(period.getFrom(), dateFormatter));
            this.addOptionalColumnValue(collector, key, this.formatAsDayMonthYear(period.getTo(), dateFormatter));
        }
    }

    private void addOptionalColumnValue(ImmutableSetMultimap.Builder<String, String> collector, String key, @Nullable String value) {
        if (value != null) {
            collector.put((Object)key, (Object)value);
        }
    }

    @CheckForNull
    private String formatAsDayMonthYear(@Nullable DateTime dateTime, DateFormatter dateFormatter) {
        return dateTime != null ? dateFormatter.formatDate(dateTime.toDate()) : null;
    }

    @Nonnull
    private ImmutableMap.Builder<String, String> addOptionalColumnValues(ImmutableMap.Builder<String, String> result, @Nullable DBEntity entity, DateFormatter formatter) {
        if (entity != null) {
            DateWithoutTimezone startAt = entity.getStartAt();
            DateWithoutTimezone endAt = entity.getEndAt();
            this.addOptionalColumnValue(result, EntityDataExportService.ExportColumnKeys.ENTITY_NAME, entity.getName());
            this.addOptionalColumnValue(result, EntityDataExportService.ExportColumnKeys.ENTITY_START_TIME, startAt == null ? null : formatter.formatDateTime(startAt));
            this.addOptionalColumnValue(result, EntityDataExportService.ExportColumnKeys.ENTITY_END_TIME, endAt == null ? null : formatter.formatDateTime(endAt));
            this.addOptionalColumnValue(result, EntityDataExportService.ExportColumnKeys.ENTITY_TIMEZONE, entity.getTimeZone());
        }
        return result;
    }

    @Nonnull
    private ImmutableMap.Builder<String, String> addOptionalColumnValue(ImmutableMap.Builder<String, String> result, EntityDataExportService.ExportColumnKeys key, @Nullable TimeZone value) {
        return value != null ? this.addOptionalColumnValue(result, key, value.getDisplayString()) : result;
    }

    @Nonnull
    private ImmutableMap.Builder<String, String> addOptionalColumnValue(ImmutableMap.Builder<String, String> result, EntityDataExportService.ExportColumnKeys key, @Nullable String value) {
        return !StringUtil.isBlank(value) ? result.put((Object)key.name(), (Object)value) : result;
    }

    private void addMembershipData(ImmutableMap.Builder<String, String> result, @Nullable Iterable<EntityMemberWithPerson> memberData, EntityConstants entityConstants) {
        if (memberData != null) {
            EntityMemberRoleTranslator entityMemberRoleTranslator = new EntityMemberRoleTranslator(entityConstants);
            Joiner toListStringJoiner = Joiner.on((String)",");
            this.addOptionalColumnValue(result, EntityDataExportService.ExportColumnKeys.MEMBER_STATUS, FluentIterable.from((Iterable)FluentIterable.from(memberData).filter(EntityMember.DIRECT_MEMBER).transformAndConcat(EntityMember.GET_ROLES).filter(Predicates.in((Collection)Sets.union(EntityMemberRoles.ALL_MEMBER_STATUS, EntityMemberRoles.ALL_EVENT_STATUS))).transform((Function)entityMemberRoleTranslator).toSortedList((Comparator)Ordering.natural())).join(toListStringJoiner));
            this.addOptionalColumnValue(result, EntityDataExportService.ExportColumnKeys.MEMBER_ROLES, FluentIterable.from((Iterable)FluentIterable.from(memberData).filter(EntityMember.DIRECT_MEMBER).transformAndConcat(EntityMember.GET_ROLES).transform((Function)entityMemberRoleTranslator).toSortedList((Comparator)Ordering.natural())).append((Iterable)FluentIterable.from(memberData).filter(EntityMember.INHERITED_MEMBER).transformAndConcat(EntityMember.GET_ROLES).transform((Function)new InheritedEntityMemberRoleTranslator(entityConstants)).toSortedList((Comparator)Ordering.natural())).join(toListStringJoiner));
        }
    }

    private void addPersonVisibleData(@Nullable DBPerson person, ServerLocalizedMessages localizedMessages, DateFormatter dateFormatter, ImmutableMap.Builder<String, String> result) {
        if (person == null) {
            return;
        }
        String prefix = "BASIC.";
        ProfileConstants profileConstants = localizedMessages.profileConstants();
        Birthday birthday = Birthday.create(person.getBirthday(), person.getBirthdayVisibility());
        if (birthday != null) {
            result.put((Object)"BASIC.birthday", (Object)birthday.format(dateFormatter));
        }
        TimeZone timeZone = (TimeZone)((Object)MoreObjects.firstNonNull((Object)((Object)person.getTimeZone()), (Object)((Object)this._settings.getDefaultTimeZone())));
        result.put((Object)"BASIC.localeTime", (Object)timeZone.getDisplayString());
    }

    private void addPersonRoles(PersonId personId, ImmutableSetMultimap<PersonId, PersonRole> personRoles, PersonRolesClientTranslation personRolesTranslation, ImmutableSet<Action> allowedActions, ImmutableSet<PersonRole> hiddenRoles, ImmutableMap.Builder<String, String> result) {
        ImmutableSet<PersonRole> displayRoles = this.getRoles(personId, personRoles, hiddenRoles, allowedActions.contains((Object)StaticAction.SEE_HIDDEN_ROLES));
        if (displayRoles.isEmpty()) {
            return;
        }
        String prefix = "BASIC.";
        String roleLabel = displayRoles.size() == 1 ? FIELD_ROLE_TITLE_SINGULAR : FIELD_ROLE_TITLE_PLURAL;
        ImmutableList roles = AuthorityUtil.names(displayRoles).asList();
        String translatedJoinedRoles = FluentIterable.from((Iterable)roles).transform(personRolesTranslation.translate()).join(Joiner.on((String)","));
        result.put((Object)("BASIC." + roleLabel), (Object)translatedJoinedRoles);
    }

    @Nonnull
    private ImmutableSet<PersonRole> getRoles(PersonId personId, ImmutableSetMultimap<PersonId, PersonRole> personRoles, ImmutableSet<PersonRole> hiddenRoles, boolean returnHidden) {
        ImmutableSet result = personRoles.get((Object)personId);
        if (returnHidden) {
            return result;
        }
        return (ImmutableSet)result.stream().filter(role -> !hiddenRoles.contains(role)).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    private ImmutableSet<PersonId> getVisiblePersonIds(ImmutableSet<PersonId> exportedUserIds, AuthorizationCheckContextWithUserId authCtx) {
        return FluentIterable.from(authCtx.filterRoles((ImmutableCollection<ProfileReadRole>)((ImmutableCollection)exportedUserIds.stream().map(ProfileReadRole::of).collect(ImmutableSet.toImmutableSet())))).transform(ProfileId.TO_PERSON_ID).toSet();
    }

    public class InheritedEntityMemberRoleTranslator
    extends EntityMemberRole.DefaultVisitor<String> {
        private final EntityConstants _entityConstants;

        public InheritedEntityMemberRoleTranslator(EntityConstants entityConstants) {
            this._entityConstants = entityConstants;
        }

        @Override
        public String visitAdmin() {
            return this._entityConstants.inheritedAdmin();
        }

        @Override
        public String visitCoAdmin() {
            return this._entityConstants.inheritedCoAdmin();
        }

        @Override
        public String visitMember() {
            return this._entityConstants.inheritedMember();
        }

        @Override
        protected String getDefault() {
            return "";
        }
    }

    public class EntityMemberRoleTranslator
    extends EntityMemberRole.DefaultVisitor<String> {
        private final EntityConstants _entityConstants;

        public EntityMemberRoleTranslator(EntityConstants entityConstants) {
            this._entityConstants = entityConstants;
        }

        @Override
        public String visitAdmin() {
            return this._entityConstants.admin();
        }

        @Override
        public String visitCoAdmin() {
            return this._entityConstants.coAdmin();
        }

        @Override
        public String visitMember() {
            return this._entityConstants.member();
        }

        @Override
        public String visitDynamicRole(EntityMemberRole role) {
            return role.getName();
        }

        @Override
        public String visitIsAttendingTheEvent() {
            return this._entityConstants.attendEvent();
        }

        @Override
        public String visitIsNotAttendingTheEvent() {
            return this._entityConstants.dontAttendEvent();
        }

        @Override
        public String visitIsMaybeAttendingTheEvent() {
            return this._entityConstants.maybeAttendEvent();
        }

        @Override
        public String visitIsOnWaitinglistForEvent() {
            return this._entityConstants.onWaitinglistOfEvent();
        }

        @Override
        public String visitRejected() {
            return this._entityConstants.rejection();
        }

        @Override
        public String visitHasSentJoinRequest() {
            return this._entityConstants.sendJoinRequest();
        }

        @Override
        public String visitHasInvitation() {
            return this._entityConstants.invited();
        }

        @Override
        public String visitIsUndecided() {
            return this._entityConstants.undecided();
        }

        @Override
        public String visitIsInvitedToEvent() {
            return this._entityConstants.invitedToEvent();
        }

        @Override
        public String visitHasRejectedTheEventInvitation() {
            return this._entityConstants.rejectedEventInvitation();
        }

        @Override
        protected String getDefault() {
            return "";
        }
    }
}

