/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.authorization.business.PersonRole;
import de.justsoftware.onx.common.business.configfile.ConfFilePosition;
import de.justsoftware.onx.common.business.configfile.ConfJsonNode;
import de.justsoftware.onx.common.business.configfile.LoadConfigFileException;
import de.justsoftware.onx.common.business.configfile.model.EntityVersionReviewerConfigModel;
import de.justsoftware.onx.common.business.configfile.model.ExternalAppConfigModel;
import de.justsoftware.onx.common.business.configfile.model.InitialVisibility;
import de.justsoftware.onx.common.business.configfile.nodes.ListNode;
import de.justsoftware.onx.common.business.configfile.nodes.MapNode;
import de.justsoftware.onx.common.business.configfile.nodes.NullNode;
import de.justsoftware.onx.common.business.configfile.nodes.StringNode;
import de.justsoftware.onx.common.shared.model.attributes.AbstractTextInput;
import de.justsoftware.onx.common.shared.model.attributes.ArithmeticOperationInput;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.common.shared.model.attributes.Input;
import de.justsoftware.onx.common.shared.model.attributes.InputType;
import de.justsoftware.onx.common.shared.model.attributes.NumberInput;
import de.justsoftware.onx.common.shared.model.attributes.PersonSuggestInput;
import de.justsoftware.onx.common.shared.model.attributes.Range;
import de.justsoftware.onx.common.shared.model.attributes.SearchConfiguration;
import de.justsoftware.onx.common.shared.model.attributes.SelectionInput;
import de.justsoftware.onx.common.shared.model.attributes.TextAreaInput;
import de.justsoftware.onx.common.shared.model.attributes.TextInput;
import de.justsoftware.onx.common.shared.util.Numbers;
import de.justsoftware.onx.container.business.DynamicAttributeConfigValidator;
import de.justsoftware.onx.container.business.EntityVersionReviewerConfigValidator;
import de.justsoftware.onx.container.business.OptionTeaserType;
import de.justsoftware.onx.container.business.OptionValidator;
import de.justsoftware.onx.container.shared.model.ChildEntityTeaserSortType;
import de.justsoftware.onx.container.shared.model.ComponentPosition;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityTab;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.EntityVersionReleaseDataOption;
import de.justsoftware.onx.container.shared.model.teasers.TeaserType;
import de.justsoftware.onx.container.shared.model.util.EntityTabUtils;
import de.justsoftware.onx.person.shared.model.startpage.EntityTeaserStartpageComponentConf;
import de.justsoftware.onx.person.shared.model.startpage.StartpageComponentConf;
import de.justsoftware.onx.person.shared.model.startpage.StartpageComponentType;
import de.justsoftware.onx.person.shared.model.startpage.StaticStartpageComponentConf;
import de.justsoftware.onx.searchnew.business.AllowedFieldSearchVisitor;
import de.justsoftware.onx.searchnew.business.SearchField;
import de.justsoftware.onx.searchnew.business.SearchFieldUtil;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypes;
import de.justsoftware.onx.searchnew.shared.model.SearchContext;
import de.justsoftware.onx.searchnew.shared.model.SearchProviderId;
import de.justsoftware.onx.searchnew.shared.model.SearchTextBoxFilterId;
import de.justsoftware.onx.searchnew.shared.model.SearchTextBoxFilterListModel;
import de.justsoftware.onx.searchnew.shared.model.SearchTextBoxFilterModel;
import de.justsoftware.onx.searchnew.shared.model.StaticFilterType;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterContext;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterListModel;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterMessageType;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterModel;
import de.justsoftware.onx.workstream.shared.util.WorkstreamFilterMessageTypes;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.math.NumberRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OptionType<T> {
    public static final OptionType<Boolean> BOOL_TYPE = new OptionType<Boolean>(){

        @Override
        public Boolean convertInternal(ConfJsonNode o) {
            return o.assertBoolean().getValue();
        }
    };
    public static final OptionType<Long> LONG_TYPE = new OptionType<Long>(){

        @Override
        public Long convertInternal(ConfJsonNode o) {
            return o.assertNumber().getValue().longValue();
        }
    };
    public static final OptionType<Integer> INT_TYPE = new OptionType<Integer>(){

        @Override
        public Integer convertInternal(ConfJsonNode o) {
            return o.assertNumber().getValue().intValue();
        }
    };
    public static final OptionType<Double> DOUBLE_TYPE = new OptionType<Double>(){

        @Override
        public Double convertInternal(ConfJsonNode o) {
            return o.assertNumber().getValue().doubleValue();
        }
    };
    public static final OptionType<BigDecimal> BIG_DECIMAL_TYPE = new OptionType<BigDecimal>(){

        @Override
        public BigDecimal convertInternal(ConfJsonNode o) {
            return o.assertNumber().getValue();
        }
    };
    public static final OptionType<String> STRING_TYPE = new OptionType<String>(){

        @Override
        public String convertInternal(ConfJsonNode o) {
            return o.assertString().getValue();
        }
    };
    public static final OptionType<ConfJsonNode> OBJECT_TYPE = new OptionType<ConfJsonNode>(){

        @Override
        public ConfJsonNode convertInternal(ConfJsonNode o) {
            return o;
        }
    };
    public static final OptionType<EntityId> ENTITY_ID_TYPE = new OptionType<EntityId>(){

        @Override
        public EntityId convertInternal(ConfJsonNode o) throws OptionTypeException {
            return new EntityId((Long)LONG_TYPE.convert(o));
        }
    };
    public static final OptionType<DynamicAttributeId> DYNAMIC_ATTRIBUTE_ID_TYPE = new OptionType<DynamicAttributeId>(){

        @Override
        public DynamicAttributeId convertInternal(ConfJsonNode o) throws OptionTypeException {
            return new DynamicAttributeId((String)STRING_TYPE.convert(o));
        }
    };
    public static final OptionType<EntityType> ENTITY_TYPE_TYPE = new OptionType<EntityType>(){

        @Override
        public EntityType convertInternal(ConfJsonNode o) throws OptionTypeException {
            return EntityType.valueOf((String)STRING_TYPE.convert(o));
        }
    };
    public static final OptionType<Range> RANGE_TYPE = new OptionType<Range>(){

        @Override
        public Range convertInternal(ConfJsonNode o) throws OptionTypeException {
            MapNode m = o.assertMap();
            return new Range((Long)11.readRequiredFromMap("MIN", LONG_TYPE, m), (Long)11.readOptionalFromMap("MAX", LONG_TYPE, m));
        }
    };
    public static final OptionType<NumberRange> NUMBER_RANGE_TYPE = new OptionType<NumberRange>(){

        @Override
        public NumberRange convertInternal(ConfJsonNode o) throws OptionTypeException {
            MapNode m = o.assertMap();
            return new NumberRange((Number)12.readRequiredFromMap("MIN", BIG_DECIMAL_TYPE, m), (Number)12.readOptionalFromMap("MAX", BIG_DECIMAL_TYPE, m));
        }
    };
    public static final OptionType<SearchConfiguration> SEARCH_CONFIG_TYPE = new OptionType<SearchConfiguration>(){

        @Override
        public SearchConfiguration convertInternal(ConfJsonNode o) throws OptionTypeException {
            MapNode m = o.assertMap();
            return new SearchConfiguration(13.readFromMapWithDefault("SEARCHABLE", BOOL_TYPE, m, Boolean.FALSE), 13.readFromMapWithDefault("ALWAYS_SHOW_IN_RESULT", BOOL_TYPE, m, Boolean.FALSE), 13.readFromMapWithDefault("FACETTING_ENABLED", BOOL_TYPE, m, Boolean.FALSE));
        }
    };
    public static final OptionType<Input> INPUT_TYPE = new OptionType<Input>(){

        @Override
        public Input convertInternal(ConfJsonNode o) throws OptionTypeException {
            MapNode m = o.assertMap();
            InputType type = (InputType)((Object)14.readRequiredFromMap("TYPE", INPUT_TYPE_TYPE, m));
            switch (type) {
                case DROP_DOWN: {
                    return new SelectionInput(14.readRequiredFromMap("VALUES", 14.listType(STRING_TYPE), m));
                }
                case PERSON_SUGGEST: {
                    return new PersonSuggestInput();
                }
                case TEXT_AREA: {
                    return new TextAreaInput(14.readFromMapWithDefault("RANGE", RANGE_TYPE, m, AbstractTextInput.DEFAULT_RANGE));
                }
                case TEXT_INPUT: {
                    return new TextInput(14.readFromMapWithDefault("RANGE", RANGE_TYPE, m, AbstractTextInput.DEFAULT_RANGE));
                }
                case NUMBER: {
                    NumberRange range = 14.readFromMapWithDefault("RANGE", NUMBER_RANGE_TYPE, m, new NumberRange((Number)NumberInput.DEFAULT_MIN, (Number)NumberInput.DEFAULT_MAX));
                    return new NumberInput(Numbers.toBigDecimal(range.getMinimumNumber()), Numbers.toBigDecimal(range.getMaximumNumber()), 14.readFromMapWithDefault("DECIMALS", LONG_TYPE, m, 0L).intValue());
                }
                case SUM: {
                    return ArithmeticOperationInput.createFromFieldNames(ArithmeticOperationInput.Operator.PLUS, 14.readRequiredFromMap("FIELDS", 14.setType(STRING_TYPE), m));
                }
            }
            throw new UnsupportedOperationException("no case for InputType " + type);
        }
    };
    public static final OptionType<ChildEntityTeaserSortType> TEASER_SORT_ORDER_TYPE = OptionType.enumType(ChildEntityTeaserSortType.class);
    public static final OptionType<OptionTeaserType> OPTION_TEASER_TYPE = OptionType.enumType(OptionTeaserType.class);
    public static final OptionType<TeaserType> TEASER_TYPE_TYPE = new OptionType<TeaserType>(){

        @Override
        public TeaserType convertInternal(ConfJsonNode o) throws OptionTypeException {
            if (o instanceof MapNode) {
                MapNode m = (MapNode)o;
                return ((OptionTeaserType)((Object)15.readRequiredFromMap("TYPE", OPTION_TEASER_TYPE, m))).createTeaserType(o.getPos(), m);
            }
            if (o instanceof StringNode) {
                return ((OptionTeaserType)((Object)OPTION_TEASER_TYPE.convert(o))).createTeaserType(o.getPos(), null);
            }
            throw new OptionTypeException(o.getPos(), "Expected a map or a string, but got: " + o);
        }
    };
    public static final OptionType<InputType> INPUT_TYPE_TYPE = OptionType.enumType(InputType.class);
    public static final OptionType<DynamicAttributeConfig> DYNAMIC_ATTRIBUTE_CONFIG_TYPE = new OptionType<DynamicAttributeConfig>((OptionValidator)DynamicAttributeConfigValidator.INSTANCE){

        @Override
        public DynamicAttributeConfig convertInternal(ConfJsonNode o) throws OptionTypeException {
            MapNode m = o.assertMap();
            return new DynamicAttributeConfig((DynamicAttributeId)16.readRequiredFromMap(OptionType.ID, DYNAMIC_ATTRIBUTE_ID_TYPE, m), 16.readFromMapWithDefault("MULTIPLICITY", RANGE_TYPE, m, Range.DEFAULT), 16.readFromMapWithDefault("INPUT", INPUT_TYPE, m, TextInput.DEFAULT_TEXT_INPUT), 16.readFromMapWithDefault("SEARCH", SEARCH_CONFIG_TYPE, m, SearchConfiguration.NOT_SEARCHABLE));
        }
    };
    public static final OptionType<EntityVersionReviewerConfigModel> ENTITY_VERSION_REVIEWER_CONFIG_TYPE = new OptionType<EntityVersionReviewerConfigModel>((OptionValidator)EntityVersionReviewerConfigValidator.INSTANCE){

        @Override
        public EntityVersionReviewerConfigModel convertInternal(ConfJsonNode o) throws OptionTypeException {
            MapNode m = o.assertMap();
            OptionType<ImmutableList<ImmutableSet<String>>> reviewerOptionType = 17.listType(17.setType(STRING_TYPE));
            return new EntityVersionReviewerConfigModel(17.readFromMapWithDefault("REVIEWER_RANGE", RANGE_TYPE, m, Range.UNRESTRICTED_NON_ZERO), (ImmutableList<ImmutableSet<String>>)17.readFromMapWithDefault("REVIEWERS_FOR_STAGES", reviewerOptionType, m, ImmutableList.of()));
        }
    };
    public static final OptionType<WorkstreamFilterId> WORKSTREAM_FILTER_ID = new OptionType<WorkstreamFilterId>(){

        @Override
        public WorkstreamFilterId convertInternal(ConfJsonNode o) throws OptionTypeException {
            return new WorkstreamFilterId((String)STRING_TYPE.convert(o));
        }
    };
    public static final OptionType<WorkstreamFilterContext> WORKSTREAM_FILTER_CONTEXT_TYPE = OptionType.enumType(WorkstreamFilterContext.class);
    public static final OptionType<ImmutableSet<String>> WORKSTREAM_FILTER_ORIGIN = OptionType.setType(STRING_TYPE);
    public static final OptionType<WorkstreamFilterMessageType> WORKSTREAM_FILTER_MESSAGE_TYPE = new OptionType<WorkstreamFilterMessageType>(){

        @Override
        public WorkstreamFilterMessageType convertInternal(ConfJsonNode o) {
            String value = (String)STRING_TYPE.convert(o);
            WorkstreamFilterMessageType result = WorkstreamFilterMessageTypes.valueOf(value);
            if (result == null) {
                throw new OptionTypeException(o.getPos(), "No WorkstreamFilterMessageType with name \"" + value + "\"");
            }
            return result;
        }
    };
    public static final OptionType<WorkstreamFilterListModel> WORKSTREAM_FILTER_TYPE = new OptionType<WorkstreamFilterListModel>(){

        @Override
        public WorkstreamFilterListModel convertInternal(ConfJsonNode o) throws OptionTypeException {
            ImmutableMap.Builder result = ImmutableMap.builder();
            WorkstreamFilterId firstFilter = null;
            WorkstreamFilterId defaultFilter = null;
            ListNode l = o.assertList();
            for (ConfJsonNode i : l) {
                MapNode m = i.assertMap();
                WorkstreamFilterId id = (WorkstreamFilterId)20.readRequiredFromMap(OptionType.ID, WORKSTREAM_FILTER_ID, m);
                WorkstreamFilterContext context = (WorkstreamFilterContext)((Object)20.readRequiredFromMap("CONTEXT", WORKSTREAM_FILTER_CONTEXT_TYPE, m));
                ImmutableSet origins = 20.readFromMapWithDefault("ORIGINS", WORKSTREAM_FILTER_ORIGIN, m, ImmutableSet.of());
                ImmutableSet messageType = 20.readFromMapWithDefault("MESSAGE_TYPE", OptionType.setType(WORKSTREAM_FILTER_MESSAGE_TYPE), m, ImmutableSet.of());
                Boolean isDefault = 20.readFromMapWithDefault("DEFAULT", BOOL_TYPE, m, Boolean.FALSE);
                int maxCount = 20.readFromMapWithDefault("MAX_COUNT", LONG_TYPE, m, 30L).intValue();
                firstFilter = (WorkstreamFilterId)MoreObjects.firstNonNull(firstFilter, (Object)id);
                if (BooleanUtils.isTrue((Boolean)isDefault)) {
                    defaultFilter = (WorkstreamFilterId)MoreObjects.firstNonNull(defaultFilter, (Object)id);
                }
                result.put((Object)id, (Object)new WorkstreamFilterModel(id, context, (ImmutableSet<String>)origins, (ImmutableSet<? extends WorkstreamFilterMessageType>)messageType, maxCount));
            }
            if (firstFilter == null) {
                throw new OptionTypeException(l.getPos(), "The list of workstream filters may not be empty!");
            }
            return new WorkstreamFilterListModel((WorkstreamFilterId)MoreObjects.firstNonNull(defaultFilter, firstFilter), (ImmutableMap<WorkstreamFilterId, WorkstreamFilterModel>)result.build());
        }
    };
    public static final OptionType<SearchTextBoxFilterId> SEARCH_TEXTBOX_FILTER_ID = new OptionType<SearchTextBoxFilterId>(){

        @Override
        public SearchTextBoxFilterId convertInternal(ConfJsonNode o) throws OptionTypeException {
            return new SearchTextBoxFilterId((String)STRING_TYPE.convert(o));
        }
    };
    public static final OptionType<FilterType> SEARCH_TEXTBOX_TYPE_FILTER = new OptionType<FilterType>(){

        @Override
        public FilterType convertInternal(ConfJsonNode o) throws OptionTypeException {
            String strType = (String)STRING_TYPE.convert(o);
            FilterType type = FilterTypes.getByTypeName(strType);
            if (type == null) {
                throw new OptionTypeException(o.getPos(), "Invalid Filter Type: " + strType);
            }
            return type;
        }
    };
    public static final OptionType<PersonRole> PERSON_ROLE = new OptionType<PersonRole>(){

        @Override
        protected PersonRole convertInternal(ConfJsonNode o) {
            String s = (String)STRING_TYPE.convert(o);
            PersonRole result = PersonRole.getPersonRoleByName(s);
            if (result == null) {
                throw new OptionTypeException(o.getPos(), "Invalid person role: " + s);
            }
            return result;
        }
    };
    public static final OptionType<SearchContext> SEARCH_TEXTBOX_FILTER_SEARCH_CONTEXT = OptionType.enumType(SearchContext.class);
    public static final OptionType<SearchProviderId> SEARCH_TEXTBOX_FILTER_PROVIDER = new OptionType<SearchProviderId>(){

        @Override
        public SearchProviderId convertInternal(ConfJsonNode o) {
            return new SearchProviderId((String)STRING_TYPE.convert(o));
        }
    };
    public static final OptionType<SearchTextBoxFilterListModel> SEARCH_TEXTBOX_FILTER = new OptionType<SearchTextBoxFilterListModel>(){

        @Override
        public SearchTextBoxFilterListModel convertInternal(ConfJsonNode o) throws OptionTypeException {
            ImmutableMap.Builder result = ImmutableMap.builder();
            SearchTextBoxFilterId firstFilter = null;
            SearchTextBoxFilterId defaultFilter = null;
            ListNode l = o.assertList();
            for (ConfJsonNode i : l) {
                MapNode m = i.assertMap();
                SearchTextBoxFilterId id = (SearchTextBoxFilterId)25.readRequiredFromMap(OptionType.ID, SEARCH_TEXTBOX_FILTER_ID, m);
                SearchProviderId searchProviderId = 25.readFromMapWithDefault("PROVIDER", SEARCH_TEXTBOX_FILTER_PROVIDER, m, SearchProviderId.JUCO_ID);
                SearchContext context = 25.readFromMapWithDefault("SEARCH_CONTEXT", SEARCH_TEXTBOX_FILTER_SEARCH_CONTEXT, m, SearchContext.ENTIRE_PLATFORM);
                FilterType filterType = 25.readFromMapWithDefault("TYPE_FILTER", SEARCH_TEXTBOX_TYPE_FILTER, m, StaticFilterType.ALL);
                SearchField searchField = 25.readOptionalFromMap("SEARCH_FIELD", 25.searchTextboxSearchFieldType(filterType), m);
                Boolean isDefault = 25.readFromMapWithDefault("DEFAULT", BOOL_TYPE, m, Boolean.FALSE);
                Boolean isWildcardSearch = 25.readFromMapWithDefault("WILDCARD_SEARCH", BOOL_TYPE, m, Boolean.FALSE);
                firstFilter = (SearchTextBoxFilterId)MoreObjects.firstNonNull(firstFilter, (Object)id);
                if (BooleanUtils.isTrue((Boolean)isDefault)) {
                    defaultFilter = (SearchTextBoxFilterId)MoreObjects.firstNonNull(defaultFilter, (Object)id);
                }
                result.put((Object)id, (Object)new SearchTextBoxFilterModel(id, context, searchProviderId, filterType, searchField != null ? searchField.getFieldName() : null, isWildcardSearch));
            }
            if (firstFilter == null) {
                throw new OptionTypeException(l.getPos(), "The list of search text box filters may not be empty!");
            }
            return new SearchTextBoxFilterListModel((SearchTextBoxFilterId)MoreObjects.firstNonNull(defaultFilter, firstFilter), (ImmutableMap<SearchTextBoxFilterId, SearchTextBoxFilterModel>)result.build());
        }
    };
    public static final OptionType<EntityVersionReleaseDataOption> ENTITY_VERSION_RELEASE_OPTION_CONFIG_TYPE = OptionType.enumType(EntityVersionReleaseDataOption.class);
    public static final OptionType<StartpageComponentType> STARTPAGE_COMPONENT_TYPE = OptionType.enumType(StartpageComponentType.class);
    public static final Set<String> DEPRECATED_STARTPAGE_COMPONENTS = Set.of("GREETINGS");
    public static final OptionType<ImmutableList<StartpageComponentConf>> STARTPAGE_COMPONENT_LIST = new OptionType<ImmutableList<StartpageComponentConf>>(){

        @Override
        protected ImmutableList<StartpageComponentConf> convertInternal(ConfJsonNode o) {
            ImmutableList.Builder result = ImmutableList.builder();
            MapNode m = o.assertMap();
            for (Map.Entry<StringNode, ConfJsonNode> e : m.entryList()) {
                if (DEPRECATED_STARTPAGE_COMPONENTS.contains(e.getKey().getValue())) {
                    LOG.warn("StartPageCompnent contains deprecated option {}", (Object)e.getKey().getValue());
                    continue;
                }
                result.add((Object)OptionType.getStartpageComponentConf(e.getKey(), e.getValue()));
            }
            return result.build();
        }
    };
    public static final OptionType<ImmutableListMultimap<ComponentPosition, StartpageComponentConf>> STARTPAGE_COMPONENTS = new OptionType<ImmutableListMultimap<ComponentPosition, StartpageComponentConf>>(){

        @Override
        protected ImmutableListMultimap<ComponentPosition, StartpageComponentConf> convertInternal(ConfJsonNode o) {
            ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
            MapNode m = o.assertMap();
            result.putAll((Object)ComponentPosition.TOP_LEFT, (Iterable)27.readFromMapWithDefault("topLeft", STARTPAGE_COMPONENT_LIST, m, ImmutableList.of()));
            result.putAll((Object)ComponentPosition.TOP_RIGHT, (Iterable)27.readFromMapWithDefault("topRight", STARTPAGE_COMPONENT_LIST, m, ImmutableList.of()));
            result.putAll((Object)ComponentPosition.CENTER, (Iterable)27.readFromMapWithDefault("center", STARTPAGE_COMPONENT_LIST, m, ImmutableList.of()));
            result.putAll((Object)ComponentPosition.BOTTOM_LEFT, (Iterable)27.readFromMapWithDefault("bottomLeft", STARTPAGE_COMPONENT_LIST, m, ImmutableList.of()));
            result.putAll((Object)ComponentPosition.BOTTOM_RIGHT, (Iterable)27.readFromMapWithDefault("bottomRight", STARTPAGE_COMPONENT_LIST, m, ImmutableList.of()));
            return result.build();
        }
    };
    public static final OptionType<EntityTab> ENTITY_TAB_TYPE = new OptionType<EntityTab>(){

        @Override
        public EntityTab convertInternal(ConfJsonNode o) throws OptionTypeException {
            StringNode stringNode = o.assertString();
            return EntityTabUtils.fromName(stringNode.getValue());
        }
    };
    public static final OptionType<ExternalAppConfigModel> EXTERNAL_APP_TYPE = new OptionType<ExternalAppConfigModel>(){

        @Override
        public ExternalAppConfigModel convertInternal(ConfJsonNode o) throws OptionTypeException {
            MapNode m = o.assertMap();
            return new ExternalAppConfigModel(29.readRequiredFromMap("url", STRING_TYPE, m), 29.readFromMapWithDefault("appColor", STRING_TYPE, m, "#000"), 29.readOptionalFromMap("iconUrl", STRING_TYPE, m), 29.readFromMapWithDefault("iFrameApp", BOOL_TYPE, m, Boolean.TRUE), 29.readFromMapWithDefault("initialVisibility", OptionType.enumType(InitialVisibility.class), m, InitialVisibility.FORCED));
        }
    };
    private static final Logger LOG = LoggerFactory.getLogger(OptionType.class);
    private static final String ID = "ID";
    @CheckForNull
    private final OptionValidator<T> _validator;

    public OptionType() {
        this._validator = null;
    }

    public OptionType(@Nullable OptionValidator<T> validator) {
        this._validator = validator;
    }

    @Nonnull
    private static StartpageComponentConf getStartpageComponentConf(@Nonnull StringNode key, final @Nonnull ConfJsonNode value) {
        StartpageComponentType type = STARTPAGE_COMPONENT_TYPE.convert(key);
        return type.accept(new StartpageComponentType.Visitor<StartpageComponentConf>(){

            @Override
            public StartpageComponentConf visitEntityTeaser(StartpageComponentType startpageComponentType) {
                MapNode m = value.assertMap();
                return new EntityTeaserStartpageComponentConf(OptionType.readRequiredFromMap(OptionType.ID, ENTITY_ID_TYPE, m), OptionType.readRequiredFromMap("CHILD_TYPE", ENTITY_TYPE_TYPE, m), OptionType.readRequiredFromMap("ORDER", TEASER_SORT_ORDER_TYPE, m), OptionType.readRequiredFromMap("TEASER_TYPE", TEASER_TYPE_TYPE, m), OptionType.readRequiredFromMap("PAGE_SIZE", LONG_TYPE, m).intValue(), OptionType.readFromMapWithDefault("SUBSCRIPTION_REQUIRED", BOOL_TYPE, m, Boolean.TRUE));
            }

            @Override
            public StartpageComponentConf visitWorkstream(StartpageComponentType startpageComponentType) {
                return StaticStartpageComponentConf.WORKSTREAM;
            }

            @Override
            public StartpageComponentConf visitBirthdays(StartpageComponentType startpageComponentType) {
                return StaticStartpageComponentConf.BIRTHDAYS;
            }

            @Override
            public StartpageComponentConf visitTopNews(StartpageComponentType startpageComponentType) {
                return StaticStartpageComponentConf.TOP_NEWS;
            }
        });
    }

    @CheckForNull
    public static <T> T readOptionalFromMap(@Nonnull String key, @Nonnull OptionType<T> type, @Nonnull MapNode mapNode) throws OptionTypeException {
        List<ConfJsonNode> l = mapNode.get(StringNode.create(key));
        ConfJsonNode v = (ConfJsonNode)Iterables.getLast(l, null);
        return v != null ? (T)type.convert(v) : null;
    }

    @Nonnull
    public static <T> T readFromMapWithDefault(@Nonnull String key, @Nonnull OptionType<T> type, @Nonnull MapNode mapNode, @Nonnull T defaultValue) throws OptionTypeException {
        T v = OptionType.readOptionalFromMap(key, type, mapNode);
        return (T)MoreObjects.firstNonNull(v, defaultValue);
    }

    @Nonnull
    public static <T> T readRequiredFromMap(@Nonnull String key, @Nonnull OptionType<T> type, @Nonnull MapNode mapNode) throws OptionTypeException {
        T value = OptionType.readOptionalFromMap(key, type, mapNode);
        if (value == null) {
            throw new OptionTypeException(mapNode.getPos(), "didn't find required key " + key + " in map: " + mapNode);
        }
        return value;
    }

    @Nonnull
    public static <E extends Enum<E>> OptionType<E> enumType(final @Nonnull Class<E> enumClass) {
        return new OptionType<E>(){

            @Override
            public E convertInternal(ConfJsonNode o) throws OptionTypeException {
                String s = (String)STRING_TYPE.convert(o);
                try {
                    return Enum.valueOf(enumClass, s);
                }
                catch (IllegalArgumentException e) {
                    throw new OptionTypeException(o.getPos(), "The value \"" + s + "\" is not allowed here");
                }
            }
        };
    }

    @Nonnull
    public static <E extends Enum<E>> OptionType<Optional<E>> optionalEnumType(final @Nonnull Class<E> enumClass, final Set<String> deprecatedOptions) {
        return new OptionType<Optional<E>>(){

            @Override
            public Optional<E> convertInternal(ConfJsonNode o) throws OptionTypeException {
                String s = (String)STRING_TYPE.convert(o);
                try {
                    return Optional.of(Enum.valueOf(enumClass, s));
                }
                catch (IllegalArgumentException e) {
                    if (deprecatedOptions.contains(s)) {
                        LOG.info("The value \"" + s + "\" is deprecated and ignored. Please remove this value from configuration.");
                        return Optional.absent();
                    }
                    throw new OptionTypeException(o.getPos(), "The value \"" + s + "\" is not allowed here");
                }
            }
        };
    }

    @Nonnull
    public static <E extends Enum<E>> OptionType<ImmutableSet<E>> presentEnumSetType(final @Nonnull Class<E> enumClass, final Set<String> ignoreOptions) {
        return new OptionType<ImmutableSet<E>>(){

            @Override
            public ImmutableSet<E> convertInternal(ConfJsonNode o) throws OptionTypeException {
                ListNode l = o.assertList();
                ImmutableSet.Builder result = ImmutableSet.builder();
                for (ConfJsonNode i : l) {
                    Optional convertedEnum = 33.optionalEnumType(enumClass, ignoreOptions).convert(i);
                    if (!convertedEnum.isPresent()) continue;
                    result.add((Object)((Enum)convertedEnum.get()));
                }
                return result.build();
            }
        };
    }

    @Nonnull
    public static <T> OptionType<ImmutableList<T>> listType(@Nonnull OptionType<T> elementType) {
        return OptionType.listType(elementType, null);
    }

    @Nonnull
    public static <T> OptionType<ImmutableList<T>> listType(@Nonnull OptionType<T> elementType, @Nullable OptionValidator<ImmutableList<T>> validator) {
        return new AbstractImmutableCollectionOptionType<T, ImmutableList<T>>(elementType, validator){

            @Override
            protected ImmutableList<T> convertInternalList(ListNode l) throws OptionTypeException {
                return this.fill(l, ImmutableList.builder()).build();
            }
        };
    }

    @Nonnull
    public static <T> OptionType<ImmutableSet<T>> setType(@Nonnull OptionType<T> elementType) {
        return OptionType.setType(elementType, null);
    }

    @Nonnull
    public static <T> OptionType<ImmutableSet<T>> setType(@Nonnull OptionType<T> elementType, @Nullable OptionValidator<ImmutableSet<T>> validator) {
        return new AbstractImmutableCollectionOptionType<T, ImmutableSet<T>>(elementType, validator){

            @Override
            protected ImmutableSet<T> convertInternalList(ListNode l) throws OptionTypeException {
                return this.fill(l, ImmutableSet.builder()).build();
            }
        };
    }

    @Nonnull
    public static <K, V> OptionType<ImmutableMap<K, V>> mapType(final @Nonnull OptionType<K> keyType, final @Nonnull OptionType<V> valueType) {
        return new OptionType<ImmutableMap<K, V>>(){

            @Override
            public ImmutableMap<K, V> convertInternal(ConfJsonNode o) throws OptionTypeException {
                ImmutableMap.Builder result = ImmutableMap.builder();
                for (Map.Entry<StringNode, ConfJsonNode> e : o.assertMap().entryList()) {
                    result.put(keyType.convert(e.getKey()), valueType.convert(e.getValue()));
                }
                return result.build();
            }
        };
    }

    @Nonnull
    public static <T> OptionType<Optional<T>> optionalType(final @Nonnull OptionType<T> elementType) {
        return new OptionType<Optional<T>>(){

            @Override
            protected Optional<T> convertInternal(ConfJsonNode o) throws OptionTypeException {
                if (o instanceof NullNode) {
                    return Optional.absent();
                }
                return Optional.of(elementType.convert(o));
            }
        };
    }

    @Nonnull
    public static final OptionType<SearchField> searchTextboxSearchFieldType(final @Nonnull FilterType filterType) {
        return new OptionType<SearchField>(){

            @Override
            public SearchField convertInternal(ConfJsonNode o) throws OptionTypeException {
                String strSearchField = (String)STRING_TYPE.convert(o);
                SearchField searchField = SearchFieldUtil.getSearchFieldByName(strSearchField, filterType);
                if (searchField == null) {
                    throw new OptionTypeException(o.getPos(), "Invalid Search Field: " + strSearchField);
                }
                if (!searchField.accept(AllowedFieldSearchVisitor.INSTANCE).booleanValue()) {
                    throw new OptionTypeException(o.getPos(), "Search Field: '" + strSearchField + "' is not allowed here! Field is not searchable!");
                }
                return searchField;
            }
        };
    }

    @Nonnull
    public final T convert(@Nonnull ConfJsonNode o) throws OptionTypeException {
        try {
            T converted = this.convertInternal(o);
            OptionValidator<T> validator = this._validator;
            if (validator != null) {
                validator.validate(o.getPos(), converted);
            }
            return converted;
        }
        catch (LoadConfigFileException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new OptionTypeException(o.getPos(), "Failed to convert option type: " + e.getMessage());
        }
    }

    @Nonnull
    protected abstract T convertInternal(@Nonnull ConfJsonNode var1) throws OptionTypeException;

    public static class OptionTypeException
    extends LoadConfigFileException {
        private static final long serialVersionUID = 3669392981517366702L;

        public OptionTypeException(@Nullable ConfFilePosition pos, @Nonnull String message) {
            super(pos, message);
        }

        public OptionTypeException(@Nullable ConfFilePosition pos, @Nonnull Throwable cause) {
            super(pos, cause);
        }
    }

    private static abstract class AbstractImmutableCollectionOptionType<T, C extends ImmutableCollection<T>>
    extends OptionType<C> {
        private final OptionType<T> _elementType;

        private AbstractImmutableCollectionOptionType(@Nonnull OptionType<T> listType, @Nullable OptionValidator<C> validator) {
            super(validator);
            this._elementType = listType;
        }

        @Override
        public final C convertInternal(ConfJsonNode o) throws OptionTypeException {
            ListNode l = o.assertList();
            return this.convertInternalList(l);
        }

        @Nonnull
        protected abstract C convertInternalList(@Nonnull ListNode var1) throws OptionTypeException;

        @Nonnull
        protected final <B extends ImmutableCollection.Builder<T>> B fill(@Nonnull ListNode l, @Nonnull B result) throws OptionTypeException {
            for (ConfJsonNode i : l) {
                result.add(this._elementType.convert(i));
            }
            return result;
        }
    }
}

