/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business;

import com.google.common.base.Function;
import de.justsoftware.onx.container.shared.model.EntityId;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ObjectWithDepth<T> {
    private final T _object;
    private final int _depth;
    private final EntityId _childEntityId;

    public ObjectWithDepth(@Nonnull T object, int depth, @Nullable EntityId childEntityId) {
        this._object = object;
        this._depth = depth;
        this._childEntityId = childEntityId;
    }

    @Nonnull
    public T getObject() {
        return this._object;
    }

    public int getDepth() {
        return this._depth;
    }

    @CheckForNull
    public EntityId getChildEntityId() {
        return this._childEntityId;
    }

    @Nonnull
    public static <T> Function<ObjectWithDepth<T>, T> getObjectFunction() {
        return new Function<ObjectWithDepth<T>, T>(){

            public T apply(ObjectWithDepth<T> input) {
                return input != null ? (Object)input.getObject() : null;
            }
        };
    }
}

