/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.common.business.events.ServerEvent;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.container.business.events.DriveChangesConnectedEvent;
import de.justsoftware.onx.container.business.model.EntityVersion;
import de.justsoftware.onx.container.business.model.NewDriveChangeEntityVersionModel;
import de.justsoftware.onx.container.shared.model.EntityBadge;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityStatus;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.EntityVersionReleaseClientModel;
import de.justsoftware.onx.container.shared.model.EntityVersionReviewData;
import de.justsoftware.onx.container.shared.model.ReleaseProcessStatus;
import de.justsoftware.onx.container.shared.model.db.DBEntityVersionReview;
import de.justsoftware.onx.multiwiki.shared.model.MultiWikiVersionId;
import de.justsoftware.onx.validation.shared.model.JucoConstraintViolation;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface EntityVersionService {
    @Nonnull
    public EntityVersion createInitialEntityVersion(EntityId var1, PersonId var2, EntityStatus var3, ServerEventCollector var4);

    @Nonnull
    @VisibleForTesting
    public EntityVersion createNewDraftVersionForTest(EntityVersionId var1, AuthorizationCheckContextWithUserId var2);

    @CheckForNull
    public EntityVersion getNewestVersionWithStatus(EntityId var1, Set<EntityStatus> var2);

    @Nonnull
    public ImmutableMap<EntityId, EntityVersion> getNewestVersionsWithStatus(Set<EntityId> var1, Set<EntityStatus> var2);

    @Nonnull
    public ImmutableMultimap<EntityId, EntityVersion> getNewestVersionByStatus(Set<EntityId> var1);

    @CheckForNull
    public EntityVersion getCurrentEntityVersionForUser(EntityId var1, AuthorizationCheckContext var2);

    @Nonnull
    public ImmutableMap<EntityId, EntityVersion> getCurrentEntityVersions(Set<EntityId> var1, AuthorizationCheckContext var2);

    @Nonnull
    public ImmutableMap<EntityId, EntityVersion> getNewestVersion(Set<EntityId> var1);

    @Nonnull
    public EntityVersion stageVersionForReview(EntityVersionReleaseClientModel var1, AuthorizationCheckContextWithUserId var2);

    @CheckForNull
    public DBEntityVersionReview getReviewFromPerson(EntityVersionId var1, PersonId var2);

    public boolean isReviewerForVersion(EntityVersionId var1, PersonId var2);

    @Nonnull
    public EntityVersion acceptVersion(EntityVersionId var1, @Nullable DateWithoutTimezone var2, @Nullable DateWithoutTimezone var3, AuthorizationCheckContextWithUserId var4);

    @Nonnull
    public EntityVersion declineVersion(EntityVersionId var1, @Nullable String var2, AuthorizationCheckContextWithUserId var3);

    @Nonnull
    public ImmutableMap<EntityId, EntityVersion> getVersionsCurrentlyInReview(Set<EntityId> var1);

    @Nonnull
    public ImmutableSet<JucoConstraintViolation> validateReleaseData(EntityVersionReleaseClientModel var1, AuthorizationCheckContextWithUserId var2);

    @CheckForNull
    public EntityVersion getVersionById(EntityVersionId var1);

    @Nonnull
    public ImmutableMap<EntityVersionId, EntityVersion> getVersionsByIds(Set<EntityVersionId> var1);

    @Nonnull
    public EntityVersion getVersionByIdNonNull(EntityVersionId var1);

    @Nonnull
    public ListAndCount<EntityVersionReviewData> getInReviewForPerson(int var1, int var2, AuthorizationCheckContextWithUserId var3);

    @Nonnull
    public ImmutableMap<EntityVersionId, EntityVersionReviewData> getInReviewForPersonByVersionId(AuthorizationCheckContextWithUserId var1);

    public void updateReadDateByEntityVersionId(EntityVersionId var1, DateWithoutTimezone var2);

    @CheckForNull
    public EntityVersionReviewData getReviewForPerson(AuthorizationCheckContextWithUserId var1, EntityVersionId var2);

    @Nonnull
    public ImmutableSetMultimap<EntityVersionId, PersonId> getReviewersForVersions(Set<EntityVersionId> var1);

    @Nonnull
    public ImmutableMap<EntityVersionId, MultiWikiVersionId> getMultiWikiVersionsForEntityVersions(Set<EntityVersionId> var1);

    @Nonnull
    public ImmutableSetMultimap<MultiWikiVersionId, EntityVersionId> getEntityVersionsForMultiWikiVersions(Set<MultiWikiVersionId> var1);

    @Nonnull
    public ListAndCount<EntityVersion> getEntityVersions(EntityId var1, int var2, int var3, AuthorizationCheckContext var4);

    @Nonnull
    public EntityId deleteVersion(EntityVersionId var1, AuthorizationCheckContextWithUserId var2);

    @Nonnull
    public EntityVersion restoreVersion(EntityVersionId var1, AuthorizationCheckContextWithUserId var2);

    public void deleteDependentVersions(ImmutableSet<EntityVersionId> var1);

    public void markAsArchived(EntityVersionId var1, EntityStatus var2);

    public void publishVersion(EntityVersionId var1);

    @CheckForNull
    public EntityVersion getLastPublicVersionBefore(EntityVersionId var1);

    @Nonnull
    public ListAndCount<EntityBadge> listDraftsForAuthor(int var1, int var2, AuthorizationCheckContextWithUserId var3);

    public int getDraftCountForAuthor(AuthorizationCheckContextWithUserId var1);

    @Nonnull
    public ImmutableSet<JucoConstraintViolation> validateReviewDataForDefaultGroup(EntityVersionReviewData var1, AuthorizationContext var2);

    public void createNewDraftVersionForMultiWikiVersion(EntityId var1, MultiWikiVersionId var2, MultiWikiVersionId var3, AuthorizationCheckContextWithUserId var4, Consumer<? super DriveChangesConnectedEvent> var5);

    public void createEntityVersionComponents(MultiWikiVersionId var1, EntityVersionId var2, Consumer<? super DriveChangesConnectedEvent> var3);

    public void createEntityVersionComponents(MultiWikiVersionId var1, EntityId var2, Consumer<? super DriveChangesConnectedEvent> var3);

    @Nonnull
    public ImmutableMap<EntityVersionId, EntityVersionReviewData> getDeclinedForPersonById(AuthorizationCheckContextWithUserId var1);

    @Nonnull
    public ImmutableListMultimap<EntityVersionId, DBEntityVersionReview> getDBReviewForVersion(ImmutableSet<EntityVersionId> var1);

    @Nonnull
    public EntityVersion archiveEntity(EntityId var1, EntityVersionId var2, AuthorizationContext var3);

    @Nonnull
    public ImmutableSet<EntityId> mayArchiveEntities(Set<EntityId> var1, AuthorizationCheckContext var2);

    @Nonnull
    public ImmutableMap<EntityId, DateWithoutTimezone> getPublicationDates(Set<EntityId> var1);

    @Nonnull
    public ImmutableMap<EntityId, EntityVersion> getPublicVersions(ImmutableSet<EntityId> var1, AuthorizationCheckContext var2);

    @Nonnull
    public ImmutableMap<EntityStatus, EntityVersion> getLatestVersionForStatus(EntityId var1, Set<EntityStatus> var2);

    public void updateStatus(EntityVersionId var1, EntityStatus var2, ImmutableSet<PersonId> var3, AuthorizationCheckContextWithUserId var4);

    @Nonnull
    public EntityStatus getStatusForStaticStatus(EntityType var1, ReleaseProcessStatus var2);

    @Nonnull
    default public EntityStatus draftStatus(EntityType entityType) {
        return this.getStatusForStaticStatus(entityType, ReleaseProcessStatus.DRAFT);
    }

    @Nonnull
    public ImmutableSetMultimap<EntityVersionId, Action> getActionsForVersions(EntityId var1, Iterable<EntityVersionId> var2, AuthorizationCheckContext var3);

    public void createEntityVersionsForDriveChanges(Iterable<NewDriveChangeEntityVersionModel> var1, Consumer<ServerEvent> var2);

    @Nonnull
    public ImmutableSetMultimap<EntityId, PersonId> getEntityVersionReviewer(Set<EntityId> var1);

    @Nonnull
    public ImmutableSetMultimap<EntityId, PersonId> getAllPossibleReviewers(Set<EntityId> var1);

    public int forAllReviewers(BiConsumer<EntityId, PersonId> var1);

    public ImmutableSet<ComponentType> getChangedComponents(EntityVersionId var1, EntityVersionId var2);

    @CheckForNull
    public EntityVersionId getFirstVersionForEntity(EntityId var1);
}

