/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business;

import de.justsoftware.onx.searchnew.shared.model.SortType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public enum EntitySortField {
    NAME,
    START_AT;

    private static final List<EntitySorting> FLY_WEIGHTS;

    public EntitySorting asc() {
        int listIdx = this.ordinal() * 2;
        return FLY_WEIGHTS.get(listIdx);
    }

    public EntitySorting desc() {
        int listIdx = this.ordinal() * 2 + 1;
        return FLY_WEIGHTS.get(listIdx);
    }

    static {
        FLY_WEIGHTS = new ArrayList<EntitySorting>(EntitySortField.values().length * 2);
        for (EntitySortField field : EntitySortField.values()) {
            FLY_WEIGHTS.add(new EntitySortingImpl(field, true));
            FLY_WEIGHTS.add(new EntitySortingImpl(field, false));
        }
    }

    private static class EntitySortingImpl
    implements EntitySorting {
        public final EntitySortField _sortField;
        public final boolean _asc;

        EntitySortingImpl(EntitySortField sortField, boolean asc) {
            this._sortField = sortField;
            this._asc = asc;
        }

        @Override
        public EntitySortField getSortField() {
            return this._sortField;
        }

        @Override
        public boolean isAsc() {
            return this._asc;
        }

        @Override
        public SortType toSortType() {
            switch (this._sortField) {
                case NAME: {
                    return SortType.ALPHABETICAL;
                }
                case START_AT: {
                    return this._asc ? SortType.TIME_ASCENDING : SortType.TIME_DESCENDING;
                }
            }
            return SortType.ALPHABETICAL;
        }
    }

    public static interface EntitySorting {
        @Nonnull
        public SortType toSortType();

        public EntitySortField getSortField();

        public boolean isAsc();
    }
}

