/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business;

import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationContextWithUserId;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.shared.model.ComponentModel;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.VisibleActionSet;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeEditModel;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.container.business.ObjectWithDepth;
import de.justsoftware.onx.container.server.model.DBPrivacySelection;
import de.justsoftware.onx.container.shared.model.ComponentPositionConfig;
import de.justsoftware.onx.container.shared.model.DefaultEntityBaseData;
import de.justsoftware.onx.container.shared.model.EditEntityHistoryTokenTabName;
import de.justsoftware.onx.container.shared.model.EntityBadge;
import de.justsoftware.onx.container.shared.model.EntityBadgeWithRole;
import de.justsoftware.onx.container.shared.model.EntityBaseData;
import de.justsoftware.onx.container.shared.model.EntityExtendedData;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityInfoSetters;
import de.justsoftware.onx.container.shared.model.EntityInfoTabPrivacySettings;
import de.justsoftware.onx.container.shared.model.EntityStatistics;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.LinkedEntityNoPermission;
import de.justsoftware.onx.container.shared.model.MenuCreateEntityInfo;
import de.justsoftware.onx.container.shared.model.MyMemberStatus;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.container.shared.model.UpdateEntityResponse;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.model.db.DBEntityComponent;
import de.justsoftware.onx.container.shared.model.db.DBEntityLink;
import de.justsoftware.onx.container.shared.model.db.DBEntityLinkedEntityPrivacy;
import de.justsoftware.onx.container.shared.model.db.DBPrivacyType;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.like.shared.model.SubscriptionStatus;
import de.justsoftware.onx.validation.shared.model.JucoConstraintViolation;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface EntityService {
    @CheckForNull
    public DBEntity getById(@Nullable EntityId var1);

    @Nonnull
    public DBEntity getByIdNotNull(EntityId var1);

    public Map<EntityId, DBEntity> getByIds(Set<EntityId> var1);

    public EntityId createInheritingEntity(EntityBaseData var1, @Nullable EntityId var2, AuthorizationCheckContextWithUserId var3);

    @Nonnull
    public EntityId createEntity(DBEntity var1, @Nullable ImmutableList<DBPrivacySelection> var2, @Nullable ImmutableList<DBEntityLinkedEntityPrivacy> var3, ImmutableList<DynamicAttributeEditModel> var4, AuthorizationCheckContextWithUserId var5, boolean var6);

    @Nonnull
    public EntityId createEntityForDifferentUser(DBEntity var1, PersonId var2, @Nullable ImmutableList<DBPrivacySelection> var3, @Nullable ImmutableList<DBEntityLinkedEntityPrivacy> var4, ImmutableList<DynamicAttributeEditModel> var5, AuthorizationCheckContextWithUserId var6, boolean var7);

    @CheckForNull
    public EntityInfo getInfoById(EntityId var1, AuthorizationCheckContextWithLocale var2);

    @CheckForNull
    public EntityBadge getBadgeById(EntityId var1, AuthorizationCheckContextWithUserId var2);

    @Nonnull
    public EntityStatistics getStatisticsById(EntityId var1, AuthorizationCheckContextWithUserId var2);

    public void deleteEntity(EntityId var1, AuthorizationCheckContextWithUserId var2);

    public void deleteEntitiesAndDependants(Set<EntityId> var1, DeletionContext var2);

    @Nonnull
    public UpdateEntityResponse updateEntity(AuthorizationCheckContextWithUserId var1, DBEntity var2);

    @Nonnull
    public ImmutableMap<ComponentType, ComponentModel> getVisibleComponentsByEntity(EntityItem var1, SearchAuthorizationCheckContext var2);

    @Nonnull
    public Map<ComponentType, ComponentPositionConfig> getAllowedComponentsByEntity(EntityItem var1, AuthorizationCheckContext var2);

    public Iterator<DBEntity> searchParents(EntityId var1, SearchPredicates var2);

    public Iterator<DBEntity> searchParents(Collection<EntityId> var1, SearchPredicates var2);

    @CheckForNull
    public List<EntityId> searchPathFromEntityToEntity(EntityId var1, EntityId var2);

    public List<EntityId> searchShortesPathToRootEntity(EntityId var1);

    public Iterator<DBEntity> searchParents(Collection<EntityId> var1, SearchPredicates var2, boolean var3);

    public Iterator<ObjectWithDepth<DBEntity>> searchParentsWithDepth(EntityId var1, SearchPredicates var2);

    public Iterator<ObjectWithDepth<DBEntity>> searchParentsWithDepth(EntityId var1, SearchPredicates var2, boolean var3);

    public Iterator<ObjectWithDepth<DBEntity>> searchParentsWithDepth(Collection<EntityId> var1, SearchPredicates var2);

    public Iterator<ObjectWithDepth<DBEntity>> searchParentsWithDepth(Collection<EntityId> var1, SearchPredicates var2, boolean var3);

    public ImmutableMap<EntityId, EntityBadge> getBadgesByIds(Set<EntityId> var1, AuthorizationCheckContextWithUserId var2);

    @Nonnull
    public ImmutableList<EntityInfo> getInfosByIdsOrdered(Iterable<EntityId> var1, AuthorizationCheckContextWithLocale var2);

    @Nonnull
    public ImmutableMap<EntityId, EntityInfo> getInfoMapByIds(Set<EntityId> var1, AuthorizationCheckContextWithLocale var2);

    public boolean isEntityComponentVisible(EntityId var1, ComponentType var2);

    @Nonnull
    public Map<ComponentType, DBEntityComponent> getComponentsByEntity(DBEntity var1);

    @Nonnull
    public ImmutableTable<EntityId, ComponentType, DBEntityComponent> getComponentsByEntities(Map<EntityId, DBEntity> var1);

    public Iterator<ObjectWithDepth<DBEntity>> getAllParents(EntityId var1, boolean var2, boolean var3, SearchDepth var4);

    @Nonnull
    public ImmutableListMultimap<EntityId, DBEntityLinkedEntityPrivacy> getEntityLinkedEntityPrivacies(Map<EntityId, DBEntity> var1);

    @Nonnull
    public ImmutableSet<EntityId> getEntityIdsByType(EntityType var1);

    public boolean isEntityInThePast(DBEntity var1);

    public boolean isEntityClosed(DBEntity var1);

    public ImmutableSet<EntityId> getDirectChildEntityIds(EntityId var1);

    @Nonnull
    public ImmutableListMultimap<EntityId, DBEntityLink> getDirectChildEntities(Set<EntityId> var1);

    public void checkParentEntityAssignmentAllowed(@Nullable EntityId var1, EntityType var2, ImmutableSet<EntityId> var3, AuthorizationCheckContextWithUserId var4) throws LinkedEntityNoPermission;

    @Nonnull
    public ImmutableSetMultimap<EntityId, EntityType> filterAllowedChildEntityTypes(Set<EntityType> var1, Set<EntityId> var2, AuthorizationCheckContextWithUserId var3);

    @CheckForNull
    public EntityId getIdByNameAndType(String var1, EntityType var2);

    public void setEntityComponentPositions(@Nullable EntityId var1, Iterable<ComponentPositionConfig> var2, AuthorizationCheckContext var3);

    public ListAndCount<EntityInfo> getEntityInfoForTypes(ImmutableSet<EntityType> var1, int var2, int var3, SearchAuthorizationCheckContext var4);

    @Nonnull
    public ListAndCount<EntityBadgeWithRole> getBadgesWithRoleByEntityTypeAndPerson(EntityType var1, PersonId var2, int var3, int var4, AuthorizationCheckContextWithUserId var5) throws ServiceException;

    @Nonnull
    public UpdateEntityResponse updateEntityDescription(AuthorizationCheckContextWithUserId var1, EntityId var2, @Nullable String var3, boolean var4) throws InvalidIDException;

    @Nonnull
    public ImmutableSet<String> getPrivacySelectedAuthorityNames(EntityItem var1, DBPrivacyType var2);

    @Nonnull
    public ImmutableSetMultimap<DBPrivacyType, String> getPrivacySelectedAuthorityNames(EntityItem var1, Set<DBPrivacyType> var2);

    @Nonnull
    public ImmutableListMultimap<EntityId, DBPrivacySelection> getPrivacySelectedAuthoritiesFromDB(Set<EntityId> var1);

    @Nonnull
    public List<DBPrivacySelection> createPrivacySelection(ImmutableSet<String> var1, DBPrivacyType var2);

    @Nonnull
    public UpdateEntityResponse updateEntityBaseData(AuthorizationCheckContextWithUserId var1, EntityBaseData var2, boolean var3);

    public void saveEntityExtendedData(EntityExtendedData var1);

    @Nonnull
    public DefaultEntityBaseData defaultNewEntity(@Nullable EntityId var1, EntityType var2, @Nullable String var3, @Nullable Date var4, AuthorizationCheckContextWithUserId var5);

    @Nonnull
    public ImmutableMap<EntityId, EntityInfo> createInfos(Iterable<DBEntity> var1, AuthorizationCheckContextWithLocale var2);

    @Nonnull
    public ImmutableSet<JucoConstraintViolation> validateEntityBaseData(EntityBaseData var1, AuthorizationCheckContextWithUserId var2);

    public ImmutableList<EntityInfo> getParentsEntityInfosSortedByName(EntityId var1, boolean var2, boolean var3, SearchDepth var4, AuthorizationCheckContextWithLocale var5);

    public void modifyPrivacyForImport(DBEntity var1, DBPrivacyType var2, ImmutableSet<String> var3);

    @Nonnull
    public MenuCreateEntityInfo getPageMenuCreateEntityInfo(AuthorizationCheckContext var1);

    @Nonnull
    public MenuCreateEntityInfo getNewsMenuCreateEntityInfo(AuthorizationCheckContext var1);

    @Nonnull
    public ImmutableSetMultimap<EntityId, Action> getAllowedEntityActions(Set<EntityId> var1, VisibleActionSet var2, AuthorizationCheckContextWithUserId var3);

    @Nonnull
    public ImmutableSetMultimap<EntityId, Action> getAllowedEntityActions(Set<EntityId> var1, VisibleActionSet var2, Map<? extends ItemId, SubscriptionStatus> var3, AuthorizationCheckContextWithUserId var4);

    public ImmutableMap<EntityId, MyMemberStatus> getMyMemberStatus(AuthorizationContextWithUserId var1, Map<EntityId, DBEntity> var2);

    @CheckForNull
    public String getLocalizedDurationString(DBEntity var1, @Nullable String var2);

    public void updateTitle(EntityId var1, String var2, AuthorizationCheckContextWithUserId var3);

    @Nonnull
    public EntityBadge createPlaceholder(DBEntity var1, AuthorizationContextWithLocale var2);

    public void copyDBToInfo(DBEntity var1, EntityInfoSetters var2);

    @Nonnull
    public EntityInfoTabPrivacySettings getEntityInfoTabPrivacySettings(EntityId var1, AuthorizationCheckContext var2);

    @Nonnull
    public ImmutableSet<String> getPrivacySettings(EntityId var1, DBPrivacyType var2, AuthorizationCheckContext var3);

    public void updateLastDriveChangeVersion(EntityId var1, int var2);

    public boolean areLinkedEntitiesEqual(DBEntity var1, DBEntity var2);

    public ImmutableSet<EditEntityHistoryTokenTabName> getVisibleEntityEditTabs(EntityType var1, ImmutableSet<Action> var2, ImmutableMap<EntityType, DBEntityLinkedEntityPrivacy> var3);

    @Nonnull
    public CoreApp getAppForGlobalId(GlobalId var1);

    @Nonnull
    public CoreApp getAppForEntityType(EntityType var1);

    @Nonnull
    public Set<EntityId> getAllForTenant(TenantId var1);

    @CheckForNull
    public String getTenantName(@Nullable TenantId var1);

    public boolean visibleForAllPersons(@Nonnull DBEntity var1);

    @ParametersAreNonnullByDefault
    public static interface SearchPredicates {
        public boolean expand(DBEntity var1, int var2, @Nullable EntityId var3);

        public boolean isResult(DBEntity var1, int var2, @Nullable EntityId var3);
    }

    public static enum SearchDepth {
        DIRECT_AND_INDIRECT_ADMIN_PARENTS,
        DIRECT_AND_INDIRECT_MEMBER_PARENTS;

    }
}

