/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.AddMemberResultKey;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMemberRole;
import de.justsoftware.onx.container.shared.model.FailedAndSuccessfulActions;
import de.justsoftware.onx.container.shared.model.MemberChangeOptions;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface EntityMemberWorkflowService {
    @Nonnull
    public FailedAndSuccessfulActions<EntityId> joinEntities(ImmutableSet<EntityId> var1, AuthorizationCheckContextWithUserId var2);

    public void joinEntity(EntityId var1, AuthorizationCheckContextWithUserId var2);

    @Nonnull
    public FailedAndSuccessfulActions<EntityId> leaveEntities(Set<EntityId> var1, PersonId var2, AuthorizationCheckContextWithUserId var3);

    @Nonnull
    public FailedAndSuccessfulActions<EntityId> leaveEntities(Set<EntityId> var1, PersonId var2, MemberChangeOptions var3, AuthorizationCheckContextWithUserId var4);

    public void leaveEntity(EntityId var1, PersonId var2, AuthorizationCheckContextWithUserId var3);

    public void acceptJoinRequest(EntityId var1, PersonId var2, AuthorizationCheckContextWithUserId var3);

    public void acceptJoinRequests(EntityId var1, Set<PersonId> var2, AuthorizationCheckContextWithUserId var3);

    public void declineJoinRequest(ImmutableSet<EntityId> var1, PersonId var2, AuthorizationCheckContextWithUserId var3);

    public void withdrawJoinRequest(EntityId var1, AuthorizationCheckContextWithUserId var2);

    public void rejectInvitationToEntity(EntityId var1, AuthorizationCheckContextWithUserId var2);

    public void rejectInvitationToEntity(EntityId var1, ServerEventCollector var2, AuthorizationCheckContextWithUserId var3);

    @Nonnull
    public ImmutableMultiset<AddMemberResultKey> managerAssignRoleToPerson(EntityId var1, Set<PersonId> var2, EntityMemberRole var3, MemberChangeOptions var4, AuthorizationCheckContext var5);

    public void moveToMemberList(EntityId var1, Set<PersonId> var2, MemberChangeOptions var3, AuthorizationCheckContextWithUserId var4);

    public void addUnallowedUsersToMemberList(EntityId var1, Set<PersonId> var2, AuthorizationContext var3);

    public void acceptInvitation(EntityId var1, AuthorizationCheckContextWithUserId var2);

    public void removeMembersFromEntity(EntityId var1, ImmutableSet<PersonId> var2, AuthorizationContext var3);
}

