/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.justsoftware.onx.common.business.configfile.ConfFilePosition;
import de.justsoftware.onx.common.business.configfile.LoadConfigFileException;
import de.justsoftware.onx.common.shared.model.attributes.ArithmeticOperationInput;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.common.shared.model.attributes.Input;
import de.justsoftware.onx.common.shared.model.attributes.NumberInput;
import de.justsoftware.onx.common.shared.model.attributes.PersonSuggestInput;
import de.justsoftware.onx.common.shared.model.attributes.SelectionInput;
import de.justsoftware.onx.common.shared.model.attributes.TextAreaInput;
import de.justsoftware.onx.common.shared.model.attributes.TextInput;
import de.justsoftware.onx.container.business.OptionValidator;
import de.justsoftware.onx.container.shared.model.Identifiables;
import javax.annotation.Nonnull;

public enum EntityDynamicAttributeConfigValidator implements OptionValidator<ImmutableList<DynamicAttributeConfig>>
{
    INSTANCE;


    @Override
    public void validate(ConfFilePosition pos, ImmutableList<DynamicAttributeConfig> value) {
        ImmutableMap<DynamicAttributeId, DynamicAttributeConfig> attributesById = this.convertToAttributeByIdMap(value);
        ImmutableList.Builder errorMessages = ImmutableList.builder();
        for (DynamicAttributeConfig config : attributesById.values()) {
            Optional<ImmutableList<String>> result = this.validateSingleConfig(config, attributesById);
            if (!result.isPresent()) continue;
            errorMessages.addAll((Iterable)result.get());
        }
        ImmutableList allErrorMessages = errorMessages.build();
        if (!allErrorMessages.isEmpty()) {
            throw new LoadConfigFileException(pos, Joiner.on((char)'\n').skipNulls().join((Iterable)allErrorMessages));
        }
    }

    @Nonnull
    private ImmutableMap<DynamicAttributeId, DynamicAttributeConfig> convertToAttributeByIdMap(@Nonnull ImmutableList<DynamicAttributeConfig> optionValue) {
        try {
            return Maps.uniqueIndex(optionValue, Identifiables.toId());
        }
        catch (IllegalArgumentException e) {
            throw new LoadConfigFileException("Entity dynamic attribute configuration contains duplicate attribute id :" + e.getMessage(), (Throwable)e);
        }
    }

    @Nonnull
    private Optional<ImmutableList<String>> validateSingleConfig(final @Nonnull DynamicAttributeConfig config, final @Nonnull ImmutableMap<DynamicAttributeId, DynamicAttributeConfig> attributesById) {
        Optional<ImmutableList<String>> result = config.getInput().accept(new Input.InputVisitor<Optional<ImmutableList<String>>>(){

            @Override
            public Optional<ImmutableList<String>> visit(SelectionInput input) {
                return Optional.absent();
            }

            @Override
            public Optional<ImmutableList<String>> visit(TextInput input) {
                return Optional.absent();
            }

            @Override
            public Optional<ImmutableList<String>> visit(TextAreaInput input) {
                return Optional.absent();
            }

            @Override
            public Optional<ImmutableList<String>> visit(PersonSuggestInput suggestInput) {
                return Optional.absent();
            }

            @Override
            public Optional<ImmutableList<String>> visit(NumberInput numberInput) {
                return Optional.absent();
            }

            @Override
            public Optional<ImmutableList<String>> visit(ArithmeticOperationInput input) {
                ImmutableList.Builder errorMessages = ImmutableList.builder();
                for (DynamicAttributeId referencedField : input.getFields()) {
                    DynamicAttributeConfig referencedConfig = (DynamicAttributeConfig)attributesById.get((Object)referencedField);
                    if (referencedConfig == null) {
                        errorMessages.add((Object)String.format("Invalid config for dynamic attribute '%s': referenced field '%s' is not configured.", config.getId().getId(), referencedField.getId()));
                        continue;
                    }
                    if (referencedConfig.getInput().accept(ArithmeticOperationInput.IsSourceForArithmeticOperationInputVisitor.VISITOR_INSTANCE).booleanValue()) continue;
                    errorMessages.add((Object)String.format("Invalid config for dynamic attribute '%s': referenced field '%s' is not a number field.", config.getId().getId(), referencedField.getId()));
                }
                return Optional.of((Object)errorMessages.build());
            }
        });
        return result;
    }
}

