/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.business.configfile.ConfFilePosition;
import de.justsoftware.onx.common.business.configfile.LoadConfigFileException;
import de.justsoftware.onx.common.shared.model.attributes.ArithmeticOperationInput;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.common.shared.model.attributes.Input;
import de.justsoftware.onx.common.shared.model.attributes.NumberInput;
import de.justsoftware.onx.common.shared.model.attributes.PersonSuggestInput;
import de.justsoftware.onx.common.shared.model.attributes.Range;
import de.justsoftware.onx.common.shared.model.attributes.SelectionInput;
import de.justsoftware.onx.common.shared.model.attributes.TextAreaInput;
import de.justsoftware.onx.common.shared.model.attributes.TextInput;
import de.justsoftware.onx.container.business.OptionType;
import de.justsoftware.onx.container.business.OptionValidator;

public enum DynamicAttributeConfigValidator implements OptionValidator<DynamicAttributeConfig>
{
    INSTANCE;

    private static final Range ARITHMETIC_OPERATION_REQUIRED_RANGE;

    @Override
    public void validate(ConfFilePosition pos, final DynamicAttributeConfig config) throws LoadConfigFileException {
        Optional<ImmutableList<String>> result = config.getInput().accept(new Input.InputVisitor<Optional<ImmutableList<String>>>(){

            @Override
            public Optional<ImmutableList<String>> visit(SelectionInput input) {
                return Optional.absent();
            }

            @Override
            public Optional<ImmutableList<String>> visit(TextInput input) {
                return Optional.absent();
            }

            @Override
            public Optional<ImmutableList<String>> visit(TextAreaInput input) {
                return Optional.absent();
            }

            @Override
            public Optional<ImmutableList<String>> visit(PersonSuggestInput suggestInput) {
                return Optional.absent();
            }

            @Override
            public Optional<ImmutableList<String>> visit(NumberInput numberInput) {
                return Optional.absent();
            }

            @Override
            public Optional<ImmutableList<String>> visit(ArithmeticOperationInput input) {
                if (!config.getMultiplicity().isEqual(ARITHMETIC_OPERATION_REQUIRED_RANGE)) {
                    return Optional.of((Object)ImmutableList.of((Object)"Multiplicity of 0 to 1 required"));
                }
                return Optional.absent();
            }
        });
        if (result.isPresent()) {
            throw new OptionType.OptionTypeException(pos, "Invalid dynamic attribute config with id '" + config.getId() + "': " + Joiner.on((char)'\n').skipNulls().join((Iterable)result.get()));
        }
    }

    static {
        ARITHMETIC_OPERATION_REQUIRED_RANGE = new Range(0L, 1L);
    }
}

