/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.business;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.server.util.DOMUtil;
import de.justsoftware.onx.common.shared.server.util.HtmlParserUtil;
import de.justsoftware.onx.common.shared.util.StringUtil;
import java.io.IOException;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@ParametersAreNonnullByDefault
public class AnchorExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(AnchorExtractor.class);

    @Nonnull
    public static ImmutableSet<String> extractAnchors(@Nullable String html) {
        return AnchorExtractor.extractAnchors(Collections.singletonList(html));
    }

    @Nonnull
    public static ImmutableSet<String> extractAnchors(Iterable<String> contents) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (String html : contents) {
            if (StringUtil.isBlank(html)) continue;
            try {
                Document doc = HtmlParserUtil.parseHtml(html);
                AnchorExtractor.extractAnchors((ImmutableSet.Builder<String>)result, doc);
            }
            catch (IOException | SAXException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return result.build();
    }

    static void extractAnchors(ImmutableSet.Builder<String> result, Document doc) {
        NodeList nodes = doc.getElementsByTagName("a");
        for (Node node : DOMUtil.nodeListIterable(nodes)) {
            Node attrNode = node.getAttributes().getNamedItem("name");
            if (attrNode == null) continue;
            String attr = attrNode.getNodeValue();
            result.add((Object)attr);
        }
    }

    @Nonnull
    @VisibleForTesting
    static ImmutableSet<String> extractAnchors(Document doc) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        AnchorExtractor.extractAnchors((ImmutableSet.Builder<String>)result, doc);
        return result.build();
    }
}

