/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.util;

import com.freiheit.toro.common.shared.util.ObjectUtil;
import de.justsoftware.onx.common.shared.util.HistoryToken;
import de.justsoftware.onx.common.shared.util.HistoryTokenParser;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface TokenUtil {
    @Nonnull
    public HistoryTokenParser parse(String var1) throws TokenParseException;

    @ParametersAreNonnullByDefault
    public static class TokenIdAndParams {
        private final HistoryToken _tokenId;
        private final List<?> _params;
        private final String _hash;

        public TokenIdAndParams(HistoryToken tokenId, List<?> params, @Nullable String hash) {
            this._tokenId = tokenId;
            this._params = params;
            this._hash = hash;
        }

        @Nonnull
        public HistoryToken getTokenId() {
            return this._tokenId;
        }

        @Nonnull
        public List<?> getParams() {
            return this._params;
        }

        @CheckForNull
        public String getHash() {
            return this._hash;
        }

        @CheckForNull
        private <T> T param(int i) {
            return i < this._params.size() ? (T)this._params.get(i) : null;
        }

        public long longParam(int i) {
            return ObjectUtil.checkNotNull(this.getLong(i));
        }

        @CheckForNull
        public Long getLong(int i) {
            return (Long)this.param(i);
        }

        @Nonnull
        public String stringParam(int i) {
            return ObjectUtil.checkNotNull(this.getString(i));
        }

        @CheckForNull
        public Boolean getBoolean(int i) {
            return (Boolean)this.param(i);
        }

        public boolean booleanParam(int i) {
            return Boolean.TRUE.equals(this.getBoolean(i));
        }

        public int intParam(int i) {
            return ObjectUtil.checkNotNull(this.getLong(i)).intValue();
        }

        @CheckForNull
        public String getString(int i) {
            return (String)this.param(i);
        }
    }

    public static class TokenParseException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public TokenParseException(String message) {
            super(message);
        }
    }
}

