/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.util;

import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PasswordCheck {
    private static final int PASSWD_MIN_LEN = 8;
    private static final String ALPHA_REGEX = ".*[a-zA-Z].*";
    private static final String ADDITIONAL_CHAR_REGEX = ".*[^a-zA-Z].*";
    private static final String HTML_LINE_BREAK = "<br />";

    public static boolean checkLength(@Nullable String passwd) {
        return passwd != null && passwd.length() >= 8;
    }

    public static boolean checkAlpha(@Nullable String passwd) {
        if (passwd == null) {
            return false;
        }
        return passwd.matches(ALPHA_REGEX);
    }

    public static boolean checkAdditionalChar(@Nullable String passwd) {
        if (passwd == null) {
            return false;
        }
        return passwd.matches(ADDITIONAL_CHAR_REGEX);
    }

    public static boolean isSecure(@Nullable String passwd) {
        return PasswordCheck.checkLength(passwd) && PasswordCheck.checkAlpha(passwd) && PasswordCheck.checkAdditionalChar(passwd);
    }

    @Nonnull
    public static String checkGetMessage(@Nullable String passwd, BasicConstants basic) {
        if (PasswordCheck.isSecure(passwd)) {
            return "";
        }
        Object res = basic.passwdInsecure();
        if (!PasswordCheck.checkLength(passwd)) {
            res = (String)res + HTML_LINE_BREAK + basic.passwdTooShort();
        }
        if (!PasswordCheck.checkAlpha(passwd)) {
            res = (String)res + HTML_LINE_BREAK + basic.passwdNoLetter();
        }
        if (!PasswordCheck.checkAdditionalChar(passwd)) {
            res = (String)res + HTML_LINE_BREAK + basic.passwdOnlyLetters();
        }
        return (String)res + HTML_LINE_BREAK;
    }
}

