/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class Multimaps2 {
    private Multimaps2() {
    }

    @Nonnull
    public static <K, V> ImmutableListMultimap<K, V> indexWithOrderedValues(Iterable<? extends V> values, Function<? super V, K> keyFunction, Comparator<V> comparator) {
        Preconditions.checkNotNull(keyFunction);
        Preconditions.checkNotNull(comparator);
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        builder.orderValuesBy(comparator);
        for (V value : values) {
            Preconditions.checkNotNull(value);
            builder.put(keyFunction.apply(value), value);
        }
        return builder.build();
    }

    @CheckForNull
    public static String joinMultimap(Multimap<String, String> multimap, Joiner entryJoiner, Joiner keyValueJoiner) {
        return Multimaps2.joinMultimap(multimap.entries(), entryJoiner, keyValueJoiner);
    }

    @CheckForNull
    public static String joinMultimap(Iterable<Map.Entry<String, String>> multimapEntries, Joiner entryJoiner, Joiner keyValueJoiner) {
        return entryJoiner.join(Streams.stream(multimapEntries).map(entry -> entry != null ? keyValueJoiner.join(entry.getKey(), entry.getValue(), new Object[0]) : null).iterator());
    }

    @Nonnull
    public static <K, V> ImmutableSetMultimap<K, V> newImmutableSetMultimap(Map<? extends K, ? extends Iterable<? extends V>> map) {
        return Multimaps2.putMap(ImmutableSetMultimap.builder(), map).build();
    }

    @Nonnull
    public static <K, V> ImmutableListMultimap<K, V> newImmutableListMultimap(Map<? extends K, ? extends Iterable<? extends V>> map) {
        return Multimaps2.putMap(ImmutableListMultimap.builder(), map).build();
    }

    @Nonnull
    public static <K, V, B extends ImmutableMultimap.Builder<K, V>> B putMap(B builder, Map<? extends K, ? extends Iterable<? extends V>> map) {
        for (Map.Entry<K, Iterable<V>> entry : map.entrySet()) {
            builder.putAll(entry.getKey(), entry.getValue());
        }
        return builder;
    }

    @Nonnull
    public static <K, V> Iterable<ImmutableSetMultimap<K, V>> partition(SetMultimap<K, V> multimap, int size) {
        return FluentIterable.from((Iterable)Iterables.partition((Iterable)multimap.entries(), (int)size)).transform(ImmutableSetMultimap::copyOf);
    }

    @Nonnull
    public static <K, V> SetMultimap<K, V> difference(SetMultimap<K, V> a, Multimap<?, ?> b) {
        return Multimaps.filterEntries(a, (Predicate)Predicates.not((Predicate)Predicates.in((Collection)b.entries())));
    }
}

