/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.util;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

public enum HistoryToken {
    SETTINGS("settings"){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitSettings(this);
        }
    }
    ,
    ALBUMS("albums"){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitAlbums(this);
        }
    }
    ,
    MDL_DOCUMENT("mdldocument"){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitMdlDocument(this);
        }
    }
    ,
    MDL_ALBUM("mdlalbum"){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitMdlAlbum(this);
        }
    }
    ,
    MDL_IMAGE("mdlimage"){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitMdlImage(this);
        }
    }
    ,
    MDL_VIDEO_LINK("mdlvideolink"){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitMdlVideoLink(this);
        }
    }
    ,
    MDL_VIDEOS("mdlvideos"){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitMdlVideos(this);
        }
    }
    ,
    CONFIG_ENTITY("config_entity"){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitConfigEntity(this);
        }
    }
    ,
    INFO("info"){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitInfo(this);
        }
    }
    ,
    FRIENDS("friends"){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitFriends(this);
        }
    }
    ,
    START("start"){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitStart(this);
        }
    }
    ,
    PROFILE("profile"){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitProfile(this);
        }
    }
    ,
    SEARCH_TEXT("searchtext"){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitSearchText(this);
        }
    }
    ,
    CONFIG_SURVEY("config_survey"){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitConfigSurvey(this);
        }
    }
    ,
    SURVEY("survey"){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitSurvey(this);
        }
    }
    ,
    ENTITY("entity"){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitEntity(this);
        }
    }
    ,
    ALL_ENTITIES("listing"){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitAllEntities(this);
        }
    }
    ,
    ENTITY_VERSION_COMPARE("entityVersionCompare"){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitEntityVersionCompare(this);
        }
    }
    ,
    WIKI_EDITOR_VERSIONS("wikiEditorVersions"){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitWikiEditorVersions(this);
        }
    }
    ,
    WORKSTREAM_ITEM("workstreamitem"){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitWorkstreamItem(this);
        }
    }
    ,
    HOME(""){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitHome(this);
        }
    }
    ,
    MODIFY_DEFAULT_ENTITY_DESIGN("modifyDefaultDesign"){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitModifyDefaultEntityDesign(this);
        }
    }
    ,
    MY_DRAFTS("myDrafts"){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitMyDraftEntities(this);
        }
    }
    ,
    DRIVE_PREVIEW("drivePreview"){

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitDrivePreview(this);
        }
    };

    public static final Function<HistoryToken, String> TOKEN_ID_FUNC;
    private static final ImmutableMap<String, HistoryToken> TRANSLATE_MAP;
    private final String _tokenId;

    private HistoryToken(String tokenId) {
        this._tokenId = tokenId;
    }

    @Nonnull
    public String getToken() {
        return this._tokenId;
    }

    @CheckForNull
    public static HistoryToken fromString(@Nullable String value) {
        if (value == null) {
            return HOME;
        }
        return (HistoryToken)((Object)TRANSLATE_MAP.get((Object)value.trim()));
    }

    @Nonnull
    public abstract <T> T accept(@Nonnull Visitor<T> var1);

    static {
        TOKEN_ID_FUNC = new Function<HistoryToken, String>(){

            public String apply(HistoryToken input) {
                return input != null ? input.getToken() : null;
            }
        };
        TRANSLATE_MAP = Maps.uniqueIndex((Iterable)ImmutableSet.copyOf((Object[])HistoryToken.values()), TOKEN_ID_FUNC);
    }

    @ParametersAreNonnullByDefault
    public static interface Visitor<T> {
        @Nonnull
        public T visitSettings(HistoryToken var1);

        @Nonnull
        public T visitMyDraftEntities(HistoryToken var1);

        @Nonnull
        public T visitHome(HistoryToken var1);

        @Nonnull
        public T visitWorkstreamItem(HistoryToken var1);

        @Nonnull
        public T visitWikiEditorVersions(HistoryToken var1);

        @Nonnull
        public T visitEntity(HistoryToken var1);

        @Nonnull
        public T visitAllEntities(HistoryToken var1);

        @Nonnull
        public T visitEntityVersionCompare(HistoryToken var1);

        @Nonnull
        public T visitSurvey(HistoryToken var1);

        @Nonnull
        public T visitConfigSurvey(HistoryToken var1);

        @Nonnull
        public T visitSearchText(HistoryToken var1);

        @Nonnull
        public T visitProfile(HistoryToken var1);

        @Nonnull
        public T visitStart(HistoryToken var1);

        @Nonnull
        public T visitFriends(HistoryToken var1);

        @Nonnull
        public T visitInfo(HistoryToken var1);

        @Nonnull
        public T visitConfigEntity(HistoryToken var1);

        @Nonnull
        public T visitMdlVideos(HistoryToken var1);

        @Nonnull
        public T visitMdlVideoLink(HistoryToken var1);

        @Nonnull
        public T visitMdlImage(HistoryToken var1);

        @Nonnull
        public T visitMdlAlbum(HistoryToken var1);

        @Nonnull
        public T visitMdlDocument(HistoryToken var1);

        @Nonnull
        public T visitAlbums(HistoryToken var1);

        @Nonnull
        public T visitModifyDefaultEntityDesign(HistoryToken var1);

        @Nonnull
        public T visitDrivePreview(HistoryToken var1);
    }
}

