/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.util;

import de.justsoftware.onx.common.shared.util.HistoryToken;
import de.justsoftware.onx.common.shared.util.HistoryTokenParser;
import de.justsoftware.onx.common.shared.util.TokenUtil;
import de.justsoftware.onx.container.shared.model.EntityId;
import javax.annotation.CheckForNull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityLinkUtil {
    private static final String OLD_ENTITY_LINK_PREFIX = "#!entity.";
    private static final String ENTITY_LINK_PREFIX = "#/entity.";

    @CheckForNull
    public static EntityId parseEntityLink(String link, TokenUtil tokenUtil) {
        if (!(link.startsWith(ENTITY_LINK_PREFIX) || link.startsWith(OLD_ENTITY_LINK_PREFIX) || link.startsWith("/toro/resource/html#/entity.") || link.startsWith("/toro/resource/html#!entity."))) {
            return null;
        }
        String strippedLink = link.startsWith("/toro/resource/html") ? link.substring("/toro/resource/html".length()) : link;
        try {
            HistoryTokenParser parsed = tokenUtil.parse(strippedLink);
            if (parsed.getToken() != HistoryToken.ENTITY) {
                return null;
            }
            Long idAsLong = parsed.getParams().get(0).asLong();
            return idAsLong == null ? null : new EntityId(idAsLong);
        }
        catch (TokenUtil.TokenParseException | NumberFormatException e) {
            return null;
        }
    }
}

