/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.util;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CollectionUtil {
    private static final Random RANDOM = new Random();

    private CollectionUtil() {
    }

    @Nonnull
    public static <T> List<T> subList(@Nullable List<T> list, int offset, int max) {
        if (list == null) {
            return new ArrayList();
        }
        int size = list.size();
        return new ArrayList<T>(list.subList(Math.min(offset, size), Math.min(max, size)));
    }

    @Nonnull
    public static <T> ListAndCount<T> nullSafeListAndCount(@Nullable List<T> list, int offset, int limit) {
        if (list == null) {
            return new ListAndCount();
        }
        int size = list.size();
        return new ListAndCount<T>(size, list.subList(Math.min(offset, size), Math.min(offset + limit, size)));
    }

    public static boolean isEmpty(@Nullable Iterable<?> iterable) {
        return iterable == null || Iterables.isEmpty(iterable);
    }

    public static boolean isEmpty(@Nullable Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    @Nonnull
    public static <T> ImmutableList<T> nonNullImmutableList(@Nullable Iterable<T> i) {
        return i == null ? ImmutableList.of() : ImmutableList.copyOf(i);
    }

    @Nonnull
    public static <T> ImmutableSet<T> nonNullImmutableSet(@Nullable Iterable<T> i) {
        return i == null ? ImmutableSet.of() : ImmutableSet.copyOf(i);
    }

    @Nonnull
    public static <K, V> List<V> mapToSortedList(@Nonnull Map<K, V> map, @Nonnull Iterable<K> keys) {
        ArrayList<V> result = new ArrayList<V>(map.size());
        for (K key : keys) {
            V value = map.get(key);
            if (value == null) continue;
            result.add(value);
        }
        return result;
    }

    @Nonnull
    public static <T> List<T> randomSublist(@Nonnull Iterable<? extends T> collection, int count) {
        LinkedList pool = Lists.newLinkedList(collection);
        int size = Math.min(pool.size(), count);
        if (size <= 0) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)size);
        for (int i = 0; i < size; ++i) {
            result.add(pool.remove(RANDOM.nextInt(pool.size())));
        }
        return result;
    }

    public static <T> void moveUp(@Nonnull List<T> list, @Nonnull T element) {
        int i = list.indexOf(element);
        if (i < 1) {
            return;
        }
        int j = i - 1;
        list.set(i, list.get(j));
        list.set(j, element);
    }

    public static <T> void moveDown(@Nonnull List<T> list, @Nonnull T element) {
        int i = list.indexOf(element);
        if (i < 0) {
            return;
        }
        int j = i + 1;
        if (j >= list.size()) {
            return;
        }
        list.set(i, list.get(j));
        list.set(j, element);
    }

    @CheckForNull
    public static <E, T extends ImmutableCollection<E>> T emptyToNull(@Nullable T collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        return collection;
    }
}

