/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.util;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import de.justsoftware.onx.common.shared.model.LongId;
import de.justsoftware.onx.common.shared.util.HistoryToken;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractTokenUtil {
    public static final char DELIMITER_CHARACTER = '.';
    public static final char HASH_DELIMITER = '#';
    static final String DEFAULT_PARAM = "00";
    static final String TRUE = "t";
    static final String FALSE = "f";

    @CheckForNull
    protected String quoteParam(@Nullable String param) {
        if (param == null) {
            return null;
        }
        return this.encodeURL(param).replaceAll("\\.", "%2E").replaceAll("#", "%23");
    }

    @Nonnull
    protected String createTokenWithDefaultParamsImpl(@Nonnull HistoryToken tokenId, @Nonnull String tokenTypes, @Nullable Object[] params, @Nullable Object[] defaultParams) {
        if (params == null) {
            return "/" + tokenId.getToken();
        }
        String encodedTokenParams = this.encodeTokenParams(tokenTypes, params, defaultParams);
        return "/" + tokenId.getToken() + (String)(encodedTokenParams.length() > 0 ? "." + encodedTokenParams : "");
    }

    @Nonnull
    public String encodeTokenParams(@Nonnull String tokenTypes, @Nullable Object[] params, @Nullable Object[] defaultParams) {
        int i;
        StringBuilder result = new StringBuilder();
        int stopIndex = params.length;
        if (defaultParams != null && defaultParams.length == params.length && defaultParams.length > 0) {
            i = defaultParams.length - 1;
            while (i >= 0 && defaultParams[i] != null && Objects.equal((Object)params[i], (Object)defaultParams[i])) {
                stopIndex = i--;
            }
        }
        block6: for (i = 0; i < params.length && i < stopIndex; ++i) {
            Object param = params[i];
            if (i > 0) {
                result.append('.');
            }
            switch (tokenTypes.charAt(i)) {
                case 'L': {
                    if (param == null) {
                        result.append(DEFAULT_PARAM);
                        continue block6;
                    }
                    if (param instanceof LongId) {
                        result.append(((LongId)param).getId());
                        continue block6;
                    }
                    result.append((Long)param);
                    continue block6;
                }
                case 'B': {
                    result.append((Boolean)param != false ? TRUE : FALSE);
                    continue block6;
                }
                case 'S': {
                    result.append(this.quoteParam(Strings.nullToEmpty((String)((String)param))));
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type identifier: " + tokenTypes.charAt(i));
                }
            }
        }
        return result.toString();
    }

    protected abstract void logWarn(@Nonnull Object var1, @Nonnull String var2);

    @Nonnull
    protected abstract String encodeURL(@Nonnull String var1);

    @Nonnull
    protected abstract String decodeURL(@Nonnull String var1);
}

