/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.server.util;

import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Queue;
import javax.annotation.Nonnull;

public final class NewlineCorrectingReader
extends Reader {
    static final String LINE_SEPERATOR = "line.separator";
    private final Queue<Integer> _next = Lists.newLinkedList();
    private final String _lineSeparator = System.getProperty("line.separator");
    private final InputStreamReader _in;

    public NewlineCorrectingReader(@Nonnull InputStream in, @Nonnull String charsetName) throws UnsupportedEncodingException {
        this._in = new InputStreamReader((InputStream)new BufferedInputStream(in), charsetName);
    }

    public NewlineCorrectingReader(@Nonnull InputStream in, @Nonnull Charset charset) {
        this._in = new InputStreamReader((InputStream)new BufferedInputStream(in), charset);
    }

    @Override
    public int read() throws IOException {
        Integer poll = this._next.poll();
        if (poll != null) {
            return poll;
        }
        int result = this._in.read();
        if (result == 10) {
            this.addLineSeperator();
        } else {
            while (result == 13) {
                this.addLineSeperator();
                result = this._in.read();
            }
            if (result != 10) {
                this._next.add(result);
            }
        }
        return this._next.poll();
    }

    private void addLineSeperator() {
        this._lineSeparator.chars().forEach(this._next::add);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            int result = this.read();
            if (result < 0) {
                return i <= 0 ? result : i;
            }
            cbuf[off + i] = (char)result;
        }
        return len;
    }

    @Override
    public void close() throws IOException {
        this._in.close();
    }
}

