/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.server.util;

import com.google.common.escape.UnicodeEscaper;
import javax.annotation.Nonnull;

public class HTMLEscaper {
    private static final char[] QUOT = "&quot;".toCharArray();
    private static final char[] AMP = "&amp;".toCharArray();
    private static final char[] GT = "&gt;".toCharArray();
    private static final char[] LT = "&lt;".toCharArray();
    private static final UnicodeEscaper ESCAPER = new UnicodeEscaper(){

        protected char[] escape(int cp) {
            switch (cp) {
                case 60: {
                    return LT;
                }
                case 62: {
                    return GT;
                }
                case 38: {
                    return AMP;
                }
                case 34: {
                    return QUOT;
                }
                case 39: 
                case 47: {
                    return this.escapeInternal(cp);
                }
            }
            if (cp > 127 || cp < 0) {
                return this.escapeInternal(cp);
            }
            return new char[]{(char)cp};
        }

        @Nonnull
        private char[] escapeInternal(int cp) {
            return ("&#" + Integer.toUnsignedString(cp) + ";").toCharArray();
        }
    };

    @Nonnull
    public static String escape(@Nonnull String s) {
        return ESCAPER.escape(s);
    }
}

