/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.server.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import javax.annotation.Nonnull;

public class Filenames {
    @Nonnull
    public static String limitFilenameLength(@Nonnull String filename, int limit) {
        int totalCharsToDelete = filename.length() - limit;
        if (totalCharsToDelete <= 0) {
            return filename;
        }
        Iterable split = Splitter.on((char)'.').split((CharSequence)filename);
        int totalRemovableChars = 0;
        int minPartLength = 6;
        while (minPartLength > 3 && totalRemovableChars < totalCharsToDelete) {
            --minPartLength;
            totalRemovableChars = 0;
            for (String part : split) {
                if (part.length() <= minPartLength) continue;
                int removableChars = part.length() - minPartLength;
                totalRemovableChars += removableChars;
            }
        }
        if (totalRemovableChars < totalCharsToDelete) {
            return filename.substring(0, limit);
        }
        LinkedList limitedParts = Lists.newLinkedList();
        for (String part : split) {
            if (part.length() < minPartLength || totalCharsToDelete <= 0) {
                limitedParts.add(part);
                continue;
            }
            int removableChars = part.length() - minPartLength;
            int charsToDelete = Math.min(removableChars, (removableChars * totalCharsToDelete + totalRemovableChars / 2) / totalRemovableChars);
            limitedParts.add(part.substring(0, part.length() - charsToDelete));
            totalCharsToDelete -= charsToDelete;
            totalRemovableChars -= removableChars;
        }
        return Joiner.on((char)'.').join((Iterable)limitedParts);
    }

    @Nonnull
    public static String replaceTildeByUserHome(@Nonnull String s) {
        return s.replace("~", System.getProperty("user.home"));
    }
}

