/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.server.util;

import de.justsoftware.toolbox.clock.Clock;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.FilenameUtils;
import org.joda.time.DateTime;
import org.springframework.web.multipart.MultipartFile;

@ParametersAreNonnullByDefault
public final class FileUtils {
    public static final String BACKUP_DATE_FORMAT = "yyyy-MM-dd_HH-mm-ss-SSSS";

    private FileUtils() {
    }

    @Nonnull
    public static File urlToFile(URL baseDir) {
        try {
            return new File(baseDir.toURI());
        }
        catch (URISyntaxException e) {
            return new File(baseDir.getPath());
        }
    }

    public static void moveFileToDir(File fileToMove, File targetDir, boolean deleteExistingFile, Clock clock) throws IOException {
        File destinationFile = new File(FilenameUtils.concat((String)targetDir.getAbsolutePath(), (String)fileToMove.getName()));
        FileUtils.deleteOrBackupFile(destinationFile, deleteExistingFile, clock);
        org.apache.commons.io.FileUtils.moveFileToDirectory((File)fileToMove, (File)targetDir, (boolean)true);
    }

    public static void moveMultipartFile(MultipartFile fileToMove, File destinationFile, boolean deleteExistingFile, Clock clock) throws IOException {
        FileUtils.deleteOrBackupFile(destinationFile, deleteExistingFile, clock);
        fileToMove.transferTo(destinationFile);
    }

    public static void deleteOrBackupFile(File file, boolean delete, Clock clock) throws IOException {
        if (file.exists()) {
            if (delete) {
                org.apache.commons.io.FileUtils.deleteQuietly((File)file);
            } else {
                DateTime now = clock.now();
                String date = new SimpleDateFormat(BACKUP_DATE_FORMAT).format(now.toDate());
                org.apache.commons.io.FileUtils.moveFile((File)file, (File)new File(file.getAbsolutePath() + "-" + date));
            }
        }
    }
}

