/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.server.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.xerces.dom.DocumentImpl;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtil {
    public static final Predicate<Node> CDATA_PREDICATE = new Predicate<Node>(){

        public boolean apply(Node input) {
            return input != null && input.getNodeType() == 4;
        }
    };
    public static final Function<Node, String> TEXT_CONTENT = new Function<Node, String>(){

        public String apply(Node input) {
            return input != null ? input.getTextContent() : null;
        }
    };
    public static final Predicate<Node> HAS_NAMESPACE = new Predicate<Node>(){

        public boolean apply(Node input) {
            return input != null && StringUtils.contains((String)input.getNodeName(), (char)':');
        }
    };

    @Nonnull
    public static Iterable<Node> nodeListIterable(final @Nullable NodeList nodes) {
        if (nodes == null) {
            return ImmutableList.of();
        }
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new NodeListIterator(nodes);
            }
        };
    }

    @Nonnull
    public static Iterable<Node> childNodesIterable(final @Nullable Node node) {
        if (node == null) {
            return ImmutableList.of();
        }
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                NodeList childs = node.getChildNodes();
                if (childs == null) {
                    return ImmutableSet.of().iterator();
                }
                return new NodeListIterator(childs);
            }
        };
    }

    @Nonnull
    public static ImmutableList<Node> filterChildNodes(@Nonnull Iterable<? extends Node> nodes, @Nonnull Predicate<Node> predicate, boolean traverseFoundNodes) {
        return DOMUtil.filterChildNodes(nodes, predicate, (Predicate<? super Node>)(traverseFoundNodes ? Predicates.alwaysTrue() : Predicates.not(predicate)));
    }

    @Nonnull
    public static ImmutableList<Node> filterChildNodes(@Nonnull Iterable<? extends Node> nodes, @Nonnull Predicate<? super Node> addToResultPredicate, @Nonnull Predicate<? super Node> traverseChildPredicate) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Node node : nodes) {
            DOMUtil.filterChildNodes((ImmutableList.Builder<Node>)builder, node, addToResultPredicate, traverseChildPredicate);
        }
        return builder.build();
    }

    private static void filterChildNodes(@Nonnull ImmutableList.Builder<Node> builder, @Nonnull Node node, @Nonnull Predicate<? super Node> addToResultPredicate, @Nonnull Predicate<? super Node> traverseChildPredicate) {
        if (addToResultPredicate.apply((Object)node)) {
            builder.add((Object)node);
        }
        if (traverseChildPredicate.apply((Object)node)) {
            for (Node child : DOMUtil.childNodesIterable(node)) {
                DOMUtil.filterChildNodes(builder, child, addToResultPredicate, traverseChildPredicate);
            }
        }
    }

    @Nonnull
    public static ImmutableList<Node> findLeaves(@Nonnull Iterable<? extends Node> nodes, @Nonnull Predicate<? super Node> predicate) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Node node : nodes) {
            DOMUtil.findLeaves((ImmutableList.Builder<Node>)builder, node, predicate);
        }
        return builder.build();
    }

    private static boolean findLeaves(@Nonnull ImmutableList.Builder<Node> builder, @Nonnull Node node, @Nonnull Predicate<? super Node> predicate) {
        boolean leafFound = false;
        for (Node child : DOMUtil.childNodesIterable(node)) {
            leafFound |= DOMUtil.findLeaves(builder, child, predicate);
        }
        if (!leafFound && predicate.apply((Object)node)) {
            builder.add((Object)node);
            return true;
        }
        return leafFound;
    }

    @Nonnull
    public static Predicate<Node> elementTagnamePredicate(final @Nonnull Predicate<String> predicate) {
        return new Predicate<Node>(){

            public boolean apply(Node input) {
                return input != null && input.getNodeType() == 1 && predicate.apply((Object)input.getNodeName());
            }
        };
    }

    @Nonnull
    public static Document createDocumentFromNode(@Nonnull Node node) {
        DocumentImpl doc = new DocumentImpl();
        doc.appendChild(doc.importNode(node, true));
        return doc;
    }

    @CheckForNull
    public static String getAttributeValue(@Nonnull Node node, @Nonnull String attr) {
        Node resultNode = DOMUtil.getAttribute(node, attr);
        return resultNode != null ? resultNode.getNodeValue() : null;
    }

    @CheckForNull
    public static Node getAttribute(@Nonnull Node node, @Nonnull String attr) {
        NamedNodeMap attrMap = node.getAttributes();
        if (attrMap == null) {
            return null;
        }
        Node attrNode = attrMap.getNamedItem(attr);
        if (attrNode != null) {
            return attrNode;
        }
        for (int i = 0; i < attrMap.getLength(); ++i) {
            Node n = attrMap.item(i);
            if (!attr.equalsIgnoreCase(n.getNodeName())) continue;
            return n;
        }
        return null;
    }

    @Nonnull
    public static Function<Node, String> attributeFunction(final @Nonnull String attributeName) {
        return new Function<Node, String>(){

            public String apply(Node input) {
                return input != null ? DOMUtil.getAttributeValue(input, attributeName) : null;
            }
        };
    }

    private static final class NodeListIterator
    extends UnmodifiableIterator<Node> {
        private int _position = 0;
        private final NodeList _nodes;

        public NodeListIterator(@Nonnull NodeList nodes) {
            this._nodes = nodes;
        }

        public boolean hasNext() {
            return this._position < this._nodes.getLength();
        }

        public Node next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this._nodes.item(this._position++);
        }
    }
}

