/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.server.util;

import de.justsoftware.onx.common.shared.util.Numbers;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@ParametersAreNonnullByDefault
public final class CookieUtil {
    public static final int LONG_LASTING_COOKIE_LIFETIME_SECONDS = Numbers.longToInt(TimeUnit.DAYS.toSeconds(356L));
    private static final String COOKIE_PATH = "/";
    private static final String OBSOLETE_COOKIE_PATH = "/toro";

    private CookieUtil() {
    }

    public static void addCookie(String name, String value, int maxAgeSeconds, HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(COOKIE_PATH);
        cookie.setMaxAge(maxAgeSeconds);
        cookie.setSecure(request.isSecure());
        response.addCookie(cookie);
    }

    public static void removeCookie(String name, HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = CookieUtil.getCookie(name, request);
        if (cookie != null) {
            CookieUtil.removeCookie(cookie, response);
        }
    }

    public static void removeCookie(Cookie cookie, HttpServletResponse response) {
        Cookie deleteCookie = (Cookie)cookie.clone();
        deleteCookie.setMaxAge(0);
        deleteCookie.setValue("");
        deleteCookie.setPath(COOKIE_PATH);
        response.addCookie(deleteCookie);
        Cookie deleteCookieObsolete = (Cookie)deleteCookie.clone();
        deleteCookieObsolete.setPath(OBSOLETE_COOKIE_PATH);
        response.addCookie(deleteCookieObsolete);
    }

    @CheckForNull
    public static String getCookieValueOrNull(String name, HttpServletRequest request) {
        Cookie cookie = CookieUtil.getCookie(name, request);
        return cookie != null ? cookie.getValue() : null;
    }

    @CheckForNull
    public static Cookie getCookie(String name, HttpServletRequest request) {
        if (name == null) {
            return null;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!name.equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    @Nonnull
    public static CookieBakery newCookie(String name, String value) {
        return new CookieBakery(name, value);
    }

    @ParametersAreNonnullByDefault
    public static final class CookieBakery {
        private final Cookie _cookie;

        CookieBakery(String name, String value) {
            this._cookie = new Cookie(name, value);
            this._cookie.setPath(CookieUtil.COOKIE_PATH);
        }

        @Nonnull
        public CookieBakery maxAge(int maxAge) {
            this._cookie.setMaxAge(maxAge);
            return this;
        }

        @Nonnull
        public CookieBakery httpOnly(boolean httpOnly) {
            this._cookie.setHttpOnly(httpOnly);
            return this;
        }

        @Nonnull
        public CookieBakery request(HttpServletRequest request) {
            this._cookie.setSecure(request.isSecure());
            return this;
        }

        @Nonnull
        public CookieBakery path(String path) {
            this._cookie.setPath(path);
            return this;
        }

        public void add(HttpServletResponse response) {
            response.addCookie(this._cookie);
        }
    }
}

