/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.model.component;

import de.justsoftware.onx.common.shared.model.component.ComponentTypeVisitor;
import de.justsoftware.onx.container.shared.model.EntityType;
import javax.annotation.Nonnull;

public enum CssClassComponentTypeVisitor implements ComponentTypeVisitor<String>
{
    INSTANCE;

    private static final String USER_LIST = "user-list";
    private static final String CONTACTS = "contacts";
    private static final String RAW_EDITOR = "raw-editor";

    @Nonnull
    private static String toCssString(@Nonnull String name) {
        return name.trim().toLowerCase().replaceAll("_", "-").replaceAll(" ", "-");
    }

    @Override
    public String visitAlbum() {
        return "images";
    }

    @Override
    public String visitDocument() {
        return "documents";
    }

    @Override
    public String visitVideolink() {
        return "videos";
    }

    @Override
    public String visitChildEntities(EntityType entityType) {
        return "child-entities " + CssClassComponentTypeVisitor.toCssString(entityType.getName());
    }

    @Override
    public String visitWorkstream() {
        return "workstream";
    }

    @Override
    public String visitProfileFriends() {
        return CONTACTS;
    }

    @Override
    public String visitLogo() {
        return "image";
    }

    @Override
    public String visitCalendarSheet() {
        return "calendar";
    }

    @Override
    public String visitRandomMembers() {
        return USER_LIST;
    }

    @Override
    public String visitAdminList() {
        return USER_LIST;
    }

    @Override
    public String visitWikiEditor() {
        return "wiki-editor";
    }

    @Override
    public String visitInfoWidget() {
        return "info";
    }

    @Override
    public String visitSurvey() {
        return "survey";
    }

    @Override
    public String visitRawEditor1() {
        return RAW_EDITOR;
    }

    @Override
    public String visitRawEditor2() {
        return RAW_EDITOR;
    }

    @Override
    public String visitRawEditor3() {
        return RAW_EDITOR;
    }

    @Override
    public String visitRawEditor4() {
        return RAW_EDITOR;
    }

    @Override
    public String visitMultiWiki() {
        return "multi-wiki";
    }

    @Override
    public String visitHierarchy() {
        return "entity-tree";
    }

    @Override
    public String visitContentButtons() {
        return "content-buttons";
    }

    @Override
    @Nonnull
    public String visitTopNews() {
        return "top-news";
    }

    @Override
    public String visitTempDocument() {
        return "";
    }
}

