/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.model.component;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import de.justsoftware.onx.common.shared.model.Creator;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.ComponentTypeCreator;
import de.justsoftware.onx.common.shared.model.component.DynamicComponentType;
import de.justsoftware.onx.common.shared.model.component.DynamicComponentTypeCreator;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.container.shared.model.EntityType;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ComponentTypes {
    public static final Function<EntityType, DynamicComponentType> ENTITY_TYPE_TO_CHILD_ENTITIES_COMPONENT_TYPE = new Function<EntityType, DynamicComponentType>(){

        public DynamicComponentType apply(EntityType input) {
            return input != null ? ComponentTypes.childEntities(input) : null;
        }
    };
    private static final ImmutableMap<String, ComponentTypeCreator<?>> CREATORS = ComponentTypes.createCreatorMap();

    @Nonnull
    private static ImmutableMap<String, ComponentTypeCreator<?>> createCreatorMap() {
        ImmutableMap.Builder result = ImmutableMap.builder();
        result.putAll(ComponentTypes.indexByName(StaticComponentType.values()));
        result.putAll(ComponentTypes.indexByName(DynamicComponentTypeCreator.values()));
        return result.build();
    }

    @Nonnull
    private static ImmutableMap<String, ComponentTypeCreator<?>> indexByName(@Nonnull ComponentTypeCreator<?>[] values) {
        return Maps.uniqueIndex((Iterator)Iterators.forArray((Object[])values), Creator.TO_NAME);
    }

    @Nonnull
    public static DynamicComponentType childEntities(@Nonnull EntityType entityType) {
        return DynamicComponentTypeCreator.CHILD_ENTITIES.create(entityType.getName());
    }

    @Nonnull
    public static ComponentType valueOf(@Nullable String name, @Nullable String param) {
        ComponentTypeCreator creator = (ComponentTypeCreator)CREATORS.get((Object)name);
        if (creator == null) {
            throw new IllegalArgumentException("no componenttype with name \"" + name + "\" known!");
        }
        return (ComponentType)creator.create(param);
    }

    @Nonnull
    public static ImmutableSet<String> allCreatorNames() {
        return CREATORS.keySet();
    }
}

