/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.model.attributes;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Range
implements Serializable {
    public static final Range UNRESTRICTED = new Range(0L, null);
    public static final Range DEFAULT = new Range(0L, 1L);
    public static final Range MANDATORY_ONE = new Range(1L, 1L);
    public static final Range UNRESTRICTED_NON_ZERO = new Range(1L, null);
    private static final long serialVersionUID = 1L;
    private Long _min;
    private Long _max;

    @Deprecated
    public Range() {
    }

    public Range(@Nonnull Long min, @Nullable Long max) {
        this._min = min;
        this._max = max;
    }

    @Nonnull
    public static Range optionalWithMaximum(@Nonnull Long max) {
        return new Range(0L, max);
    }

    @Nonnull
    public Long getMin() {
        return this._min;
    }

    @CheckForNull
    public Long getMax() {
        return this._max;
    }

    public boolean hasMaximum() {
        return this._max != null;
    }

    public boolean hasMinimum() {
        return this._min > 0L;
    }

    public boolean hasRestrictions() {
        return this.hasMaximum() || this.hasMinimum();
    }

    public boolean isEqual(@Nullable Range other) {
        return other != null && Objects.equal((Object)this._min, (Object)other._min) && Objects.equal((Object)this._max, (Object)other._max);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("min", (Object)this._min).add("max", (Object)this._max).toString();
    }
}

