/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.model.attributes;

import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.container.shared.model.EntityType;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class EntityDynamicAttributesUtil {
    private static final String TYPE_SEPARATOR = "_";

    private EntityDynamicAttributesUtil() {
    }

    @Nonnull
    public static String toSearchFieldName(DynamicAttributeId dynamicAttributeId, EntityType entityType) {
        return "entity_dynamic_" + entityType.name() + TYPE_SEPARATOR + dynamicAttributeId.getId();
    }

    @Nonnull
    public static String toFacetFieldName(DynamicAttributeId dynamicAttributeId, EntityType entityType) {
        return "entity_facet_dynamic_" + entityType.name() + TYPE_SEPARATOR + dynamicAttributeId.getId();
    }

    public static boolean isEntityDynamicAttribute(String fieldname) {
        return fieldname.startsWith("entity_dynamic_");
    }

    public static boolean isEntityDynamicAttributeForType(String fieldname, EntityType entityType) {
        return fieldname.startsWith("entity_dynamic_" + entityType.name() + TYPE_SEPARATOR);
    }

    @Nonnull
    public static DynamicAttributeId getAttributeIdFromFieldName(String fieldName, EntityType entityType) {
        return new DynamicAttributeId(fieldName.substring("entity_dynamic_".length() + entityType.name().length() + TYPE_SEPARATOR.length()));
    }
}

