/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.model.attributes;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeId;
import de.justsoftware.onx.common.shared.model.attributes.Input;
import de.justsoftware.onx.common.shared.model.attributes.Range;
import de.justsoftware.onx.common.shared.model.attributes.SearchConfiguration;
import de.justsoftware.onx.container.shared.model.Identifiable;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DynamicAttributeConfig
implements Serializable,
Identifiable<DynamicAttributeId> {
    public static final Predicate<DynamicAttributeConfig> IS_SEARCHABLE = new Predicate<DynamicAttributeConfig>(){

        public boolean apply(DynamicAttributeConfig input) {
            return input != null && input.getSearchConfig().isSearchable();
        }
    };
    public static final Predicate<DynamicAttributeConfig> IS_FACETTING_ENABLED = new Predicate<DynamicAttributeConfig>(){

        public boolean apply(DynamicAttributeConfig input) {
            return input != null && input.getSearchConfig().isSearchable() && input.getSearchConfig().isFacettingEnabled();
        }
    };
    public static final Predicate<DynamicAttributeConfig> ALWAYS_SHOW_IN_RESULT = new Predicate<DynamicAttributeConfig>(){

        public boolean apply(DynamicAttributeConfig input) {
            return input != null && input.getSearchConfig().alwaysShowInResult();
        }
    };
    public static final Function<DynamicAttributeConfig, String> GET_NAME = new Function<DynamicAttributeConfig, String>(){

        public String apply(@Nullable DynamicAttributeConfig input) {
            return input != null ? input.getId().toString() : null;
        }
    };
    private static final long serialVersionUID = 1L;
    private DynamicAttributeId _id;
    private Input _input;
    private Range _multiplicity;
    private SearchConfiguration _searchConfig;

    public DynamicAttributeConfig(@Nonnull DynamicAttributeId id, @Nonnull Range multiplicity, @Nonnull Input input, @Nonnull SearchConfiguration searchConfig) {
        this._id = id;
        this._input = input;
        this._multiplicity = multiplicity;
        this._searchConfig = searchConfig;
    }

    @Deprecated
    public DynamicAttributeConfig() {
    }

    @Override
    @Nonnull
    public DynamicAttributeId getId() {
        return this._id;
    }

    public boolean isMandatory() {
        return this._multiplicity.hasMinimum();
    }

    @Nonnull
    public Range getMultiplicity() {
        return this._multiplicity;
    }

    @Nonnull
    public Input getInput() {
        return this._input;
    }

    @Nonnull
    public SearchConfiguration getSearchConfig() {
        return this._searchConfig;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("input", (Object)this._input).add("multiplicity", (Object)this._multiplicity).add("searchConfig", (Object)this._searchConfig).toString();
    }
}

