/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.model.action;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.DynamicAction;
import de.justsoftware.onx.common.shared.model.action.DynamicActionCreator;
import de.justsoftware.onx.common.shared.model.action.TabNameForConfiguration;
import de.justsoftware.onx.container.shared.model.EntityType;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Actions {
    public static final ImmutableSet<Action> ENTITY_EDIT_TAB_ACTIONS = FluentIterable.from((Object[])TabNameForConfiguration.values()).transform(Actions::entityModifyTab).toSet();

    private Actions() {
    }

    @Nonnull
    public static DynamicAction entityModifyTab(@Nonnull TabNameForConfiguration tabName) {
        return DynamicActionCreator.ENTITY_MODIFY_TAB.create(tabName.name());
    }

    @Nonnull
    public static ImmutableSet<Action> createTabNameBasedAction(final @Nonnull DynamicActionCreator creator) {
        return ImmutableSet.copyOf((Iterator)Iterators.transform((Iterator)Iterators.forArray((Object[])TabNameForConfiguration.values()), (Function)new Function<TabNameForConfiguration, Action>(){

            public Action apply(@Nullable TabNameForConfiguration input) {
                return input != null ? creator.create(input.name()) : null;
            }
        }));
    }

    @Nonnull
    public static DynamicAction entitySelectParent(@Nonnull EntityType entityType) {
        return DynamicActionCreator.ENTITY_SELECT_PARENT.create(entityType.getName());
    }

    @Nonnull
    public static DynamicAction entityModifyParent(@Nonnull EntityType entityType) {
        return DynamicActionCreator.ENTITY_MODIFY_PARENT.create(entityType.getName());
    }

    @Nonnull
    public static DynamicAction entityCreate(@Nonnull EntityType entityType) {
        return DynamicActionCreator.ENTITY_CREATE.create(entityType.getName());
    }

    @Nonnull
    public static DynamicAction startpageCreateEntity(@Nonnull EntityType entityType) {
        return DynamicActionCreator.STARTPAGE_CREATE_ENTITY.create(entityType.getName());
    }

    @Nonnull
    public static ImmutableSet<Action> createEntityTypeBasedAction(@Nonnull DynamicActionCreator creator, @Nonnull Iterable<EntityType> entityTypes) {
        return FluentIterable.from(entityTypes).transform(input -> creator.create(input.getName())).toSet();
    }
}

