/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.model;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.util.Dates;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class TimePeriod {
    public static final int WHOLE_DAY_START_MIN = 0;
    public static final int WHOLE_DAY_START_HOUR = 0;
    public static final int WHOLE_DAY_END_MIN = 59;
    public static final int WHOLE_DAY_END_HOUR = 23;
    private final Date _startTimestamp;
    private final Date _endTimestamp;

    public TimePeriod() {
        this._startTimestamp = new Date();
        this._endTimestamp = Dates.clone(this._startTimestamp);
    }

    public TimePeriod(@Nullable Date startTimestamp, @Nullable Date endTimestamp) {
        this._startTimestamp = Dates.clone(startTimestamp);
        this._endTimestamp = Dates.clone(endTimestamp);
    }

    @CheckForNull
    public Date getStartTimestamp() {
        return Dates.clone(this._startTimestamp);
    }

    @CheckForNull
    public Date getEndTimestamp() {
        return Dates.clone(this._endTimestamp);
    }

    public boolean isWholeDay() {
        return this._startTimestamp != null && this._endTimestamp != null && this._startTimestamp.getHours() == 0 && this._startTimestamp.getMinutes() == 0 && this._endTimestamp.getHours() == 23 && this._endTimestamp.getMinutes() == 59;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("startTimestamp", (Object)this._startTimestamp).add("endTimestamp", (Object)this._endTimestamp).toString();
    }
}

