/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.model;

import com.google.common.base.Function;
import de.justsoftware.onx.common.shared.model.LongId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.StartpageId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.SearchableId;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class PersonId
extends LongId
implements SearchableId {
    public static final Function<PersonId, StartpageId> AS_STARTPAGE_ID = new NullPermeableFunction<PersonId, StartpageId>(){

        @Override
        protected StartpageId applySafe(PersonId input) {
            return input.asStartpageId();
        }
    };
    public static final Function<PersonId, ProfileId> AS_PROFILE_ID = new NullPermeableFunction<PersonId, ProfileId>(){

        @Override
        protected ProfileId applySafe(PersonId input) {
            return input.asProfileId();
        }
    };
    public static final Function<Long, PersonId> FROM_LONG = PersonId::valueOf;
    public static final Function<String, PersonId> PARSE = PersonId::parse;
    private static final long serialVersionUID = 6061894164047874335L;

    public PersonId(long id) {
        super(id);
    }

    @Deprecated
    public PersonId() {
    }

    @Override
    public ProfileId toItemId() {
        return this.asProfileId();
    }

    @CheckForNull
    public static PersonId parse(@Nullable String s) {
        return PersonId.valueOf(GlobalId.parseId(s));
    }

    @CheckForNull
    public static PersonId valueOf(@Nullable Long l) {
        return l != null ? new PersonId(l) : null;
    }

    @CheckForNull
    public static PersonId valueOf(@Nullable ProfileId id) {
        return id != null ? id.asPersonId() : null;
    }

    @Nonnull
    public ProfileId asProfileId() {
        return new ProfileId(this.getId());
    }

    @Nonnull
    public StartpageId asStartpageId() {
        return new StartpageId(this.getId());
    }

    public ProfileId getAsProfileId() {
        return this.asProfileId();
    }

    @Override
    public <T> T accept(SearchableId.Visitor<T> visitor) {
        return visitor.visit(this);
    }
}

