/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"}, justification="unclear what side effects will appear if adding equals and hashcode after so many years...")
public class ListAndCount<T>
extends ArrayList<T> {
    private static final long serialVersionUID = 8839539381779271974L;
    private int _maxCount = 0;

    public ListAndCount(int maxCount, Collection<? extends T> data) {
        super(data);
        this._maxCount = maxCount;
    }

    public ListAndCount(int maxCount, @Nonnull Iterable<? extends T> data) {
        this(maxCount);
        this._maxCount = maxCount;
        Iterables.addAll(this, data);
    }

    public ListAndCount() {
    }

    public ListAndCount(int initialCapazity) {
        super(initialCapazity);
    }

    public ListAndCount(@Nonnull List<? extends T> originalList, int offset, int count) {
        super(count);
        this._maxCount = originalList.size();
        if (offset < this._maxCount && count > 0) {
            this.addAll(originalList.subList(offset, Math.min(offset + count, this._maxCount)));
        }
    }

    public int getMaxCount() {
        return this._maxCount;
    }

    public void setMaxCount(int maxCount) {
        this._maxCount = maxCount;
    }

    public static <T> ListAndCount<T> emptyListAndCount() {
        ListAndCount<T> result = new ListAndCount<T>(0);
        result.setMaxCount(0);
        return result;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("super", (Object)super.toString()).add("maxCount", this._maxCount).toString();
    }

    @Nonnull
    public static <I, O> ListAndCount<O> transform(@Nonnull ListAndCount<I> input, @Nonnull Function<? super I, ? extends O> function) {
        return new ListAndCount(input._maxCount, Lists.transform(input, function));
    }
}

