/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.model;

import com.google.common.collect.Ordering;
import de.justsoftware.onx.album.shared.model.AlbumImageId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.videolink.shared.model.VideolinkId;
import de.justsoftware.onx.workstream.shared.model.attachments.AttachmentType;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

public interface JCMediaContentId
extends ItemId {
    public static final Visitor<AttachmentType> TO_ATTACHMENT_TYPE = new Visitor<AttachmentType>(){

        @Override
        public AttachmentType visit(VideolinkId videolinkId) {
            return AttachmentType.VIDEO;
        }

        @Override
        public AttachmentType visit(AlbumImageId albumImageId) {
            return AttachmentType.PHOTO;
        }

        @Override
        public AttachmentType visit(DriveDocumentId driveDocumentId) {
            return AttachmentType.DRIVE_DOCUMENT;
        }
    };
    public static final Ordering<JCMediaContentId> DEFAULT_ORDERING = AttachmentType.DEFAULT_ORDERING.onResultOf(id -> id.accept(TO_ATTACHMENT_TYPE));

    @Nonnull
    public <T> T accept(@Nonnull Visitor<T> var1);

    @ParametersAreNonnullByDefault
    public static interface Visitor<T> {
        @Nonnull
        public T visit(VideolinkId var1);

        @Nonnull
        public T visit(AlbumImageId var1);

        @Nonnull
        public T visit(DriveDocumentId var1);
    }
}

