/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.model;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.IEntityVersion;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityStatusClientModel;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.EntityVersionType;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class EntityVersionClientModel
implements Serializable {
    private static final long serialVersionUID = 2L;
    private EntityVersionId _id;
    private EntityId _entityId;
    private PersonId _authorId;
    private int _majorVersion;
    private int _minorVersion;
    private int _draftVersion;
    private String _changeMessage;
    private String _commentForReviewers;
    private String _declineMessage;
    private EntityStatusClientModel _status;
    private EntityVersionType _versionType;
    private EntityVersionType _targetType;
    private DateWithoutTimezone _releaseDate;
    private DateWithoutTimezone _expirationDate;
    private DateWithoutTimezone _creationDate;

    @Deprecated
    public EntityVersionClientModel() {
    }

    public EntityVersionClientModel(@Nonnull IEntityVersion origin) {
        this._id = origin.getId();
        this._entityId = origin.getEntityId();
        this._authorId = origin.getAuthorId();
        this._majorVersion = origin.getMajorVersion();
        this._minorVersion = origin.getMinorVersion();
        this._draftVersion = origin.getDraftVersion();
        this._changeMessage = origin.getChangeMessage();
        this._commentForReviewers = origin.getCommentForReviewers();
        this._declineMessage = origin.getDeclineMessage();
        this._status = (EntityStatusClientModel)EntityStatusClientModel.TO_CLIENT_MODEL.apply((Object)origin.getStatus());
        this._versionType = origin.getVersionType();
        this._targetType = origin.getTargetType();
        this._releaseDate = origin.getReleaseDate();
        this._expirationDate = origin.getExpirationDate();
        this._creationDate = origin.getCreationDate();
    }

    @Nonnull
    public EntityVersionId getId() {
        return this._id;
    }

    public void setId(@Nonnull EntityVersionId id) {
        this._id = id;
    }

    @Nonnull
    public EntityId getEntityId() {
        return this._entityId;
    }

    @Nonnull
    public PersonId getAuthorId() {
        return this._authorId;
    }

    public int getMajorVersion() {
        return this._majorVersion;
    }

    public int getMinorVersion() {
        return this._minorVersion;
    }

    public int getDraftVersion() {
        return this._draftVersion;
    }

    public void setDraftVersion(int draftVersion) {
        this._draftVersion = draftVersion;
    }

    @CheckForNull
    public String getChangeMessage() {
        return this._changeMessage;
    }

    @CheckForNull
    public String getCommentForReviewers() {
        return this._commentForReviewers;
    }

    @CheckForNull
    public String getDeclineMessage() {
        return this._declineMessage;
    }

    @Nonnull
    public EntityStatusClientModel getStatus() {
        return this._status;
    }

    @Nonnull
    public EntityVersionType getVersionType() {
        return this._versionType;
    }

    @CheckForNull
    public EntityVersionType getTargetType() {
        return this._targetType;
    }

    @CheckForNull
    public DateWithoutTimezone getReleaseDate() {
        return this._releaseDate;
    }

    @CheckForNull
    public DateWithoutTimezone getExpirationDate() {
        return this._expirationDate;
    }

    @Nonnull
    public String getVersionString() {
        return this._majorVersion + "." + this._minorVersion + "." + this._draftVersion;
    }

    @CheckForNull
    public DateWithoutTimezone getCreationDate() {
        return this._creationDate;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("entityId", (Object)this._entityId).add("authorId", (Object)this._authorId).add("majorVersion", this._majorVersion).add("minorVersion", this._minorVersion).add("draftVersion", this._draftVersion).add("changeMessage", (Object)this._changeMessage).add("commentForReviewers", (Object)this._commentForReviewers).add("declineMessage", (Object)this._declineMessage).add("status", (Object)this._status).add("versionType", (Object)this._versionType).add("targetType", (Object)this._targetType).add("releaseDate", (Object)this._releaseDate).add("expirationDate", (Object)this._expirationDate).add("creationDate", (Object)this._creationDate).toString();
    }
}

