/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.model;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.shared.model.BadgeFieldType;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class BadgeField
implements Serializable {
    public static final Function<BadgeField, String> TO_NAME = new NullPermeableFunction<BadgeField, String>(){

        @Override
        protected String applySafe(BadgeField input) {
            return input.getName();
        }
    };
    private static final long serialVersionUID = 1L;
    private static final Joiner CONTENT_LIST_JOINER = Joiner.on((char)',').skipNulls();
    private String _name;
    private BadgeFieldType _type;
    private ImmutableList<String> _contentList = ImmutableList.of();

    @Deprecated
    public BadgeField() {
    }

    public BadgeField(String name, BadgeFieldType type, ImmutableList<String> contents) {
        this._name = name;
        this._type = type;
        this._contentList = contents;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    @Nonnull
    public BadgeFieldType getType() {
        return this._type;
    }

    @Nonnull
    public String getContent() {
        return CONTENT_LIST_JOINER.join(this._contentList);
    }

    public void setContentList(ImmutableList<String> contentList) {
        this._contentList = contentList;
    }

    @Nonnull
    public ImmutableList<String> getContentList() {
        return this._contentList;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._name, this._type, this._contentList});
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.equalsBadgeField((BadgeField)obj);
    }

    private boolean equalsBadgeField(BadgeField other) {
        return Objects.equal((Object)this._name, (Object)other.getName()) && Objects.equal((Object)((Object)this._type), (Object)((Object)other.getType())) && Objects.equal(this._contentList, other.getContentList());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this._name).add("type", (Object)this._type).add("contentList", this._contentList).toString();
    }
}

