/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.shared.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class AuthorityModel
implements Serializable {
    public static final Predicate<AuthorityModel> IS_FORCED = new NullIsFalsePredicate<AuthorityModel>(){

        @Override
        protected boolean applySafe(AuthorityModel input) {
            return input.isForced();
        }
    };
    public static final Predicate<AuthorityModel> IS_DEFAULT = new NullIsFalsePredicate<AuthorityModel>(){

        @Override
        protected boolean applySafe(AuthorityModel input) {
            return input.isDefault();
        }
    };
    public static final Predicate<AuthorityModel> IS_VISIBLE = new NullIsFalsePredicate<AuthorityModel>(){

        @Override
        protected boolean applySafe(AuthorityModel input) {
            return input.isVisible();
        }
    };
    public static final Function<AuthorityModel, String> TO_NAME = new Function<AuthorityModel, String>(){

        public String apply(AuthorityModel input) {
            return input != null ? input.getAuthority() : null;
        }
    };
    private static final long serialVersionUID = 1L;
    private String _authority;
    private Modifier _modifier;

    @Deprecated
    public AuthorityModel() {
    }

    public AuthorityModel(String authority, Modifier modifier) {
        this._authority = authority;
        this._modifier = modifier;
    }

    @Nonnull
    public String getAuthority() {
        return this._authority;
    }

    public boolean isForced() {
        return this._modifier.isForced();
    }

    public boolean isDefault() {
        return this._modifier.isDefault();
    }

    public boolean isVisible() {
        return this._modifier.isVisible();
    }

    @Nonnull
    public Modifier getModifier() {
        return this._modifier;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && obj instanceof AuthorityModel && Objects.equal((Object)((AuthorityModel)obj)._authority, (Object)this._authority) && Objects.equal((Object)((Object)((AuthorityModel)obj)._modifier), (Object)((Object)this._modifier));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._authority, this._modifier});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("authority", (Object)this._authority).add("modifier", (Object)this._modifier).toString();
    }

    public static enum Modifier {
        DEFAULT(true, true, false),
        FORCED(true, false, true),
        HIDDEN(false, false, true),
        NONE(true, false, false);

        private final boolean _visible;
        private final boolean _default;
        private final boolean _forced;

        private Modifier(boolean isVisible, boolean isDefault, boolean isForced) {
            this._visible = isVisible;
            this._default = isDefault;
            this._forced = isForced;
        }

        public boolean isVisible() {
            return this._visible;
        }

        public boolean isDefault() {
            return this._default;
        }

        public boolean isForced() {
            return this._forced;
        }
    }
}

