/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.server.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.chat.model.ResourceWithHeaders;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.core.io.AbstractResource;

@ParametersAreNonnullByDefault
public class URLResourceWithHeaders
extends AbstractResource
implements ResourceWithHeaders {
    protected final String _url;
    protected URLConnection _openConnection;
    protected Map<String, List<String>> _headers;

    public URLResourceWithHeaders(String url) {
        this._url = url;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        if (this._headers == null) {
            this._headers = (Map)MoreObjects.firstNonNull(this.getHeadersFromConnection(), (Object)ImmutableMap.of());
        }
        return this._headers;
    }

    @CheckForNull
    private Map<String, List<String>> getHeadersFromConnection() {
        try {
            return this.getOpenConnection().getHeaderFields();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public String getDescription() {
        return "Resource at " + this._url;
    }

    @Nonnull
    private URLConnection getOpenConnection() throws IOException {
        if (this._openConnection == null) {
            this._openConnection = this.getURL().openConnection();
        }
        return this._openConnection;
    }

    public URL getURL() throws IOException {
        return new URL(this._url);
    }

    public InputStream getInputStream() throws IOException {
        return this.getOpenConnection().getInputStream();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("getFilename", (Object)this.getFilename()).add("description", (Object)this.getDescription()).add("exists", this.exists()).add("headers", this._headers != null ? Integer.valueOf(this._headers.size()) : null).add("url", (Object)this._url).add("connectionIsOpen", this._openConnection != null).toString();
    }
}

